/*
 * Decompiled with CFR 0.152.
 */
package com.pineapple.export.ui;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.DES;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.json.JSONUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.pineapple.export.config.Config;
import com.pineapple.export.helper.Constants;
import com.pineapple.export.helper.NotificationHelper;
import com.pineapple.export.vo.RecentPathVO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.client.ScpClientCreator;
import org.jetbrains.annotations.NotNull;

public class FastExportUI
extends JDialog {
    private static final Logger LOG = Logger.getInstance(FastExportUI.class);
    private JPanel contentPane;
    private JButton buttonExport;
    private JButton buttonCancel;
    private JTextField tomcatWebPath;
    private JButton chooseTomcatWebPath;
    private JComboBox historyCombox;
    private JTextField sshPathText;
    private JTextField sshUserText;
    private JPasswordField sshPasswordText;
    private JTextField sshPortText;
    private JTextField sshHostText;
    private JRadioButton sshExportYesBtn;
    private JRadioButton sshExportNoBtn;
    private JTextField sshBashPath;
    private ButtonGroup sshExportGroup;
    private AnActionEvent event;
    private VirtualFile[] selectedFiles;
    private DefaultComboBoxModel<RecentPathVO> recentPathComboBoxModel;
    private static final FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
    private RecentPathVO prevPath;
    private Config config;
    private Project project;

    public FastExportUI(AnActionEvent event, VirtualFile[] selectedFiles) {
        this.$$$setupUI$$$();
        this.recentPathComboBoxModel = new DefaultComboBoxModel();
        this.prevPath = null;
        this.config = null;
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonExport);
        this.sshExportGroup = new ButtonGroup();
        this.sshExportGroup.add(this.sshExportYesBtn);
        this.sshExportGroup.add(this.sshExportNoBtn);
        this.event = event;
        this.selectedFiles = selectedFiles;
        this.project = event.getProject();
        if (!this.initData()) {
            return;
        }
        this.initListener();
    }

    private boolean initData() {
        Path path = Paths.get(Constants.HISTORY_PATH, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
                FileUtil.writeString((String)"{}", (String)Constants.HISTORY_PATH, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOG.error("\u5386\u53f2\u8bb0\u5f55\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (Throwable)e);
                return false;
            }
        }
        String historyPathStr = FileUtil.readString((String)Constants.HISTORY_PATH, (Charset)StandardCharsets.UTF_8);
        try {
            this.config = (Config)JSONUtil.toBean((String)historyPathStr, Config.class);
        }
        catch (Exception e) {
            List recentPaths;
            block14: {
                this.config = new Config();
                recentPaths = null;
                try {
                    recentPaths = JSONUtil.toList((String)historyPathStr, RecentPathVO.class);
                }
                catch (Exception ee) {
                    List temp = JSONUtil.toList((String)historyPathStr, String.class);
                    if (!CollUtil.isNotEmpty((Collection)temp)) break block14;
                    AtomicLong timeMillis = new AtomicLong(System.currentTimeMillis());
                    recentPaths = temp.stream().map(item -> RecentPathVO.getInstance(item, timeMillis.getAndIncrement())).collect(Collectors.toList());
                }
            }
            this.config.setData(recentPaths);
        }
        List<RecentPathVO> historyPaths = this.config.getData().stream().distinct().sorted(Comparator.comparingLong(RecentPathVO::getTimestamp).reversed()).collect(Collectors.toList());
        this.config.setData(historyPaths);
        this.historyCombox.setModel(this.recentPathComboBoxModel);
        this.prevPath = historyPaths.get(0);
        ApplicationManager.getApplication().invokeLater(() -> {
            this.recentPathComboBoxModel.addAll(historyPaths);
            if (this.prevPath != null) {
                this.tomcatWebPath.setText(this.prevPath.getPath());
                this.historyCombox.setSelectedItem(this.prevPath);
            }
        });
        if (StrUtil.isBlank((CharSequence)this.config.getSsh().getKey())) {
            byte[] key = SecureUtil.generateKey((String)SymmetricAlgorithm.AES.getValue()).getEncoded();
            String secretKey = Base64.encode((byte[])key);
            this.config.getSsh().setKey(secretKey);
        }
        if (StrUtil.isNotBlank((CharSequence)this.config.getSsh().getOutPath())) {
            this.sshPathText.setText(this.config.getSsh().getOutPath());
        }
        if (StrUtil.isNotBlank((CharSequence)this.config.getSsh().getBashPath())) {
            this.sshBashPath.setText(this.config.getSsh().getBashPath());
        }
        if (StrUtil.isNotBlank((CharSequence)this.config.getSsh().getHost())) {
            this.sshHostText.setText(this.config.getSsh().getHost());
        }
        if (StrUtil.isNotBlank((CharSequence)this.config.getSsh().getPort())) {
            this.sshPortText.setText(this.config.getSsh().getPort());
        }
        if (StrUtil.isNotBlank((CharSequence)this.config.getSsh().getUser())) {
            this.sshUserText.setText(this.config.getSsh().getUser());
        }
        if (StrUtil.isNotBlank((CharSequence)this.config.getSsh().getPassword())) {
            this.sshPasswordText.setText(this.decode(this.config.getSsh().getPassword()));
        }
        return true;
    }

    private void initListener() {
        this.buttonExport.addActionListener(e -> this.onOK());
        this.buttonCancel.addActionListener(e -> this.onCancel());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FastExportUI.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        descriptor.setShowFileSystemRoots(true);
        descriptor.setHideIgnored(true);
        descriptor.setTitle("\u5bfc\u51fa\u76ee\u5f55");
        this.chooseTomcatWebPath.addActionListener(e -> {
            VirtualFile toSelect = this.prevPath == null ? null : LocalFileSystem.getInstance().findFileByPath(this.prevPath.getPath());
            VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, (VirtualFile)toSelect);
            if (virtualFile != null && virtualFile.exists()) {
                this.addOneRecentPath(virtualFile.getCanonicalPath());
            }
        });
        this.tomcatWebPath.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String newValue = FastExportUI.this.tomcatWebPath.getText();
                if (StrUtil.isNotBlank((CharSequence)newValue)) {
                    FastExportUI.this.addOneRecentPath(newValue);
                }
            }
        });
        this.historyCombox.addItemListener(e -> {
            if (1 == e.getStateChange()) {
                RecentPathVO path = (RecentPathVO)e.getItem();
                ApplicationManager.getApplication().invokeLater(() -> this.tomcatWebPath.setText(path.getPath()));
            }
        });
        this.historyCombox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String newValue = FastExportUI.this.tomcatWebPath.getText();
                if (StrUtil.isNotBlank((CharSequence)newValue)) {
                    FastExportUI.this.addOneRecentPath(newValue);
                }
            }
        });
        this.tomcatWebPath.requestFocus();
    }

    private void addOneRecentPath(String path) {
        this.changeHistoryPath(path);
        ApplicationManager.getApplication().invokeLater(() -> {
            this.recentPathComboBoxModel.removeAllElements();
            this.recentPathComboBoxModel.addAll(this.config.getData());
            this.tomcatWebPath.setText(path);
            this.tomcatWebPath.setToolTipText(path);
            this.config.getData().stream().filter(item -> path.equals(item.getPath())).findFirst().ifPresent(item -> this.historyCombox.setSelectedItem(item));
        });
    }

    private void onOK() {
        HashMap<Module, Set> module2Files = new HashMap<Module, Set>();
        final HashMap<Module, List<String>> moduleMapSourcePaths = new HashMap<Module, List<String>>();
        final boolean[] hasJavaArray = new boolean[]{false};
        for (VirtualFile file : this.selectedFiles) {
            final Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.event.getProject());
            if (module != null) {
                final Set virtualFiles = (Set)MapUtil.get(module2Files, (Object)module, HashSet.class, new HashSet());
                if (!file.isDirectory()) {
                    if (this.checkSourcePathValid(moduleMapSourcePaths, module, file.getUrl()) || this.checkWebPathValid(moduleMapSourcePaths, module, file.getUrl())) {
                        virtualFiles.add(file);
                        if (file.getName().toLowerCase().endsWith(".java")) {
                            hasJavaArray[0] = true;
                        }
                    }
                } else {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                        public boolean visitFile(@NotNull VirtualFile child) {
                            if (child == null) {
                                4.$$$reportNull$$$0(0);
                            }
                            if (!child.isDirectory() && (FastExportUI.this.checkSourcePathValid(moduleMapSourcePaths, module, child.getUrl()) || FastExportUI.this.checkWebPathValid(moduleMapSourcePaths, module, child.getUrl()))) {
                                virtualFiles.add(child);
                                if (child.getName().toLowerCase().endsWith(".java")) {
                                    hasJavaArray[0] = true;
                                }
                            }
                            return super.visitFile(child);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/pineapple/export/ui/FastExportUI$4", "visitFile"));
                        }
                    });
                }
                module2Files.put(module, virtualFiles);
                continue;
            }
            NotificationHelper.showWarn(this.event.getProject(), file.getCanonicalPath() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5757");
        }
        long sum = module2Files.values().stream().mapToLong(Set::size).sum();
        if (module2Files.isEmpty() || sum == 0L) {
            NotificationHelper.showError(this.event.getProject(), "\u8bf7\u5148\u9009\u4e2d\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff01");
            return;
        }
        LOG.info("\u9009\u4e2d\u7684\u6570\u636e\uff1a" + sum);
        String outRootPath = this.tomcatWebPath.getText();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.project);
        Module[] modules = module2Files.keySet().toArray(new Module[0]);
        boolean hasJava = hasJavaArray[0];
        ApplicationManager.getApplication().invokeLater(() -> {
            if (hasJava) {
                compilerManager.make(this.project, modules, (aborted, errors, warnings, compileContext) -> {
                    if (aborted) {
                        NotificationHelper.showError(this.project, "\u4ee3\u7801\u7f16\u8bd1\u88ab\u7ec8\u6b62\uff01");
                        return;
                    }
                    if (errors != 0) {
                        NotificationHelper.showError(this.project, "\u4ee3\u7801\u7f16\u8bd1\u65f6\u53d1\u751f\u9519\u8bef\uff01");
                        return;
                    }
                    try {
                        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u51c6\u5907\u5bfc\u51fa.......");
                        this.runExport(module2Files, outRootPath, this.project, modules, compileContext);
                        this.sshSCP();
                        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5bfc\u51fa\u5b8c\u6210\uff01");
                    }
                    catch (Exception e) {
                        NotificationHelper.showError(this.project, "\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25\uff01<br>" + e.getMessage());
                        LOG.error("", (Throwable)e);
                    }
                });
            } else {
                try {
                    LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u51c6\u5907\u5bfc\u51fa.......");
                    this.runExport4WithoutJava(module2Files, outRootPath, this.project);
                    this.sshSCP();
                    LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5bfc\u51fa\u5b8c\u6210\uff01");
                }
                catch (Exception e) {
                    NotificationHelper.showError(this.project, "\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25\uff01<br>" + e.getMessage());
                    LOG.error("\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25", (Throwable)e);
                }
            }
        });
        this.saveHistory();
        this.dispose();
    }

    private void runExport(Map<Module, Set<VirtualFile>> module2Files, String outRootPath, Project project, Module[] modules, CompileContext compileContext) throws IOException {
        HashMap<Path, Path> destFileMapSourceFile = new HashMap<Path, Path>();
        Path finalOutRootPath = Paths.get(outRootPath, new String[0]);
        Path finalSshOutRootPath = Paths.get(Constants.DESKTOP_PATH, "ssh_temp_path");
        FileUtil.del((Path)finalSshOutRootPath);
        Files.createDirectories(finalSshOutRootPath, new FileAttribute[0]);
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (Module module : modules) {
            VirtualFile compilerOutputPath = compileContext.getModuleOutputDirectory(module);
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            Set<VirtualFile> virtualFiles = module2Files.get(module);
            for (VirtualFile exportFile : virtualFiles) {
                Path saveSshStaticPath;
                Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)exportFile, (Project)project);
                if (!module.equals(moduleForFile)) continue;
                Optional<VirtualFile> first = Stream.of(sourceRoots).filter(virtualFile -> exportFile.getUrl().contains(virtualFile.getUrl())).findFirst();
                if (first.isPresent()) {
                    PsiFile psiFile;
                    Path saveSshClassPath;
                    Path packagePath = Paths.get(first.get().getPath(), new String[0]).relativize(Paths.get(exportFile.getParent().getPath(), new String[0]));
                    String classFileNameSuffix = exportFile.getName();
                    Path classFilesPath = Paths.get(compilerOutputPath.getPath(), packagePath.toString());
                    Path saveClassPath = Paths.get(finalOutRootPath.toString(), "WEB-INF", "classes", packagePath.toString());
                    if (Files.notExists(saveClassPath, new LinkOption[0])) {
                        Files.createDirectories(saveClassPath, new FileAttribute[0]);
                    }
                    if (Files.notExists(saveSshClassPath = Paths.get(finalSshOutRootPath.toString(), "WEB-INF", "classes", packagePath.toString()), new LinkOption[0])) {
                        Files.createDirectories(saveSshClassPath, new FileAttribute[0]);
                    }
                    if ((psiFile = PsiManager.getInstance((Project)project).findFile(exportFile)) instanceof PsiJavaFile) {
                        PsiClass[] classes;
                        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
                        for (PsiClass aClass : classes = javaFile.getClasses()) {
                            this.findAllClasses(aClass, destFileMapSourceFile, classFilesPath, saveClassPath, "");
                            this.findAllClasses(aClass, destFileMapSourceFile, classFilesPath, saveSshClassPath, "");
                        }
                        continue;
                    }
                    Path src2 = Paths.get(classFilesPath.toString(), classFileNameSuffix);
                    Path target = Paths.get(saveClassPath.toString(), classFileNameSuffix);
                    destFileMapSourceFile.put(target, src2);
                    Path sshTarget = Paths.get(saveSshClassPath.toString(), classFileNameSuffix);
                    destFileMapSourceFile.put(sshTarget, src2);
                    continue;
                }
                if (!this.containWeb(exportFile.getPath())) continue;
                String relativePath = this.findWebSubPath(exportFile.getPath());
                Path saveStaticPath = Paths.get(finalOutRootPath.toString(), relativePath);
                if (Files.notExists(saveStaticPath, new LinkOption[0])) {
                    Files.createDirectories(saveStaticPath, new FileAttribute[0]);
                }
                if (Files.notExists(saveSshStaticPath = Paths.get(finalSshOutRootPath.toString(), relativePath), new LinkOption[0])) {
                    Files.createDirectories(saveSshStaticPath, new FileAttribute[0]);
                }
                Path src3 = Paths.get(exportFile.getPath(), new String[0]);
                destFileMapSourceFile.put(saveStaticPath, src3);
                destFileMapSourceFile.put(saveSshStaticPath, src3);
            }
        }
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + destFileMapSourceFile.size() + "\u4e2a");
        ArrayList all = new ArrayList();
        AtomicInteger total = new AtomicInteger();
        AtomicInteger failedTotal = new AtomicInteger();
        destFileMapSourceFile.forEach((dest, src) -> all.add(CompletableFuture.runAsync(() -> {
            try {
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString());
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src + ", \u5230\uff1a" + dest + "\u6210\u529f\uff01");
                total.getAndIncrement();
            }
            catch (Exception e) {
                failedTotal.getAndIncrement();
                e.printStackTrace();
            }
        })));
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        long count = module2Files.values().stream().mapToLong(Set::size).sum();
        String content = "\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + count + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u603b\u6570\u91cf\uff1a" + destFileMapSourceFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a).<br> ";
        NotificationHelper.showInfo(project, content, "\u6253\u5f00\u5bfc\u51fa\u7684\u6839\u8def\u5f84", "file://" + outRootPath);
    }

    private void sshSCP() {
        CompletableFuture.runAsync(() -> {
            LOG.info("\u662f\u5426\u5f00\u542fscp\u4f20\u8f93\uff1a" + this.sshExportYesBtn.isSelected());
            if (this.sshExportYesBtn.isSelected()) {
                LOG.info("\u521b\u5efa SSH\u5ba2\u6237\u7aef");
                try (SshClient sshClient = SshClient.setUpDefaultClient();){
                    LOG.info("\u542f\u52a8 SSH\u5ba2\u6237\u7aef");
                    sshClient.start();
                    LOG.info("\u901a\u8fc7\u4e3b\u673aIP\u3001\u7aef\u53e3\u548c\u7528\u6237\u540d\uff0c\u8fde\u63a5\u4e3b\u673a\uff0c\u83b7\u53d6Session");
                    ClientSession clientSession = ((ConnectFuture)sshClient.connect(this.sshUserText.getText(), this.sshHostText.getText(), Integer.parseInt(this.sshPortText.getText())).verify()).getClientSession();
                    LOG.info("\u7ed9Session\u6dfb\u52a0\u5bc6\u7801");
                    clientSession.addPasswordIdentity(String.valueOf(this.sshPasswordText.getPassword()));
                    LOG.info("\u6821\u9a8c\u7528\u6237\u540d\u548c\u5bc6\u7801\u7684\u6709\u6548\u6027");
                    boolean isSuccess = ((AuthFuture)clientSession.auth().verify()).isSuccess();
                    if (isSuccess) {
                        LOG.info("\u6821\u9a8c\u6709\u6548\u6027\u901a\u8fc7\uff01\u521b\u5efascp\u901a\u9053");
                        ScpClientCreator creator = ScpClientCreator.instance();
                        LOG.info("\u521b\u5efascp\u5ba2\u6237\u7aef......");
                        ScpClient scpClient = creator.createScpClient(clientSession);
                        Path local = Paths.get(Constants.DESKTOP_PATH, "ssh_temp_path");
                        String remote = this.sshPathText.getText();
                        LOG.info("Scp \u5f00\u59cb\u4e0a\u4f20. local=" + local + ",remote=" + remote);
                        String[] localChildArray = Arrays.stream(local.toFile().listFiles()).map(File::getAbsolutePath).collect(Collectors.toSet()).toArray(new String[0]);
                        scpClient.upload(localChildArray, remote, new ScpClient.Option[]{ScpClient.Option.Recursive});
                        LOG.info("Scp \u4e0a\u4f20\u5b8c\u6210.");
                        scpClient = null;
                        if (clientSession.isOpen()) {
                            clientSession.close();
                        }
                        if (sshClient.isOpen()) {
                            sshClient.stop();
                            sshClient.close();
                        }
                        String content = "\u4e0a\u4f20\u5730\u5740\uff1ahost=" + this.sshHostText.getText() + ",port=" + this.sshPortText.getText() + ",user=" + this.sshUserText.getText();
                        content = content + "\nlocal=" + local;
                        content = content + "\nremote=" + remote;
                        content = content + "\n\u5b8c\u6210\uff01";
                        NotificationHelper.showInfo(this.project, "\u4e0a\u4f20SSH\u63d0\u793a", content);
                    }
                }
                catch (Exception e) {
                    LOG.error("scp\u5931\u8d25", (Throwable)e);
                }
            }
        });
    }

    private void findAllClasses(PsiClass aClass, Map<Path, Path> destFileMapSourceFile, Path classFilesPath, Path saveClassPath, String prefixName) {
        String fileName = (StrUtil.isBlank((CharSequence)prefixName) ? "" : prefixName + "$") + aClass.getName();
        Path src = Paths.get(classFilesPath.toString(), fileName + ".class");
        Path target = Paths.get(saveClassPath.toString(), src.getFileName().toString());
        destFileMapSourceFile.put(target, src);
        try (DirectoryStream<Path> classPathsProxy = Files.newDirectoryStream(classFilesPath, entry -> entry.getFileName().toString().matches("^" + Pattern.quote(fileName + "$") + "\\d+\\.class$"));){
            for (Path src2 : classPathsProxy) {
                Path target2 = Paths.get(saveClassPath.toString(), src2.getFileName().toString());
                destFileMapSourceFile.put(target2, src2);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        for (PsiClass innerClass : aClass.getInnerClasses()) {
            this.findAllClasses(innerClass, destFileMapSourceFile, classFilesPath, saveClassPath, fileName);
        }
    }

    private void runExport4WithoutJava(Map<Module, Set<VirtualFile>> module2Files, String outRootPath, Project project) throws IOException {
        HashMap<Path, Path> sourceFileMapDestFile = new HashMap<Path, Path>();
        Path finalOutRootPath = Paths.get(outRootPath, new String[0]);
        Path finalSshOutRootPath = Paths.get(Constants.DESKTOP_PATH, "ssh_temp_path");
        FileUtil.del((Path)finalSshOutRootPath);
        Files.createDirectories(finalSshOutRootPath, new FileAttribute[0]);
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (Map.Entry<Module, Set<VirtualFile>> entry : module2Files.entrySet()) {
            Module module = entry.getKey();
            Set<VirtualFile> virtualFiles = entry.getValue();
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            for (VirtualFile exportFile : virtualFiles) {
                Path saveSshStaticPath;
                Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)exportFile, (Project)project);
                if (!module.equals(moduleForFile)) continue;
                Optional<VirtualFile> first = Stream.of(sourceRoots).filter(virtualFile -> exportFile.getUrl().contains(virtualFile.getUrl())).findFirst();
                if (first.isPresent()) {
                    Path saveSshClassPath;
                    Path packagePath = Paths.get(first.get().getPath(), new String[0]).relativize(Paths.get(exportFile.getParent().getPath(), new String[0]));
                    String classFileNameSuffix = exportFile.getName();
                    Path saveClassPath = Paths.get(finalOutRootPath.toString(), "WEB-INF", "classes", packagePath.toString());
                    if (Files.notExists(saveClassPath, new LinkOption[0])) {
                        Files.createDirectories(saveClassPath, new FileAttribute[0]);
                    }
                    if (Files.notExists(saveSshClassPath = Paths.get(finalSshOutRootPath.toString(), "WEB-INF", "classes", packagePath.toString()), new LinkOption[0])) {
                        Files.createDirectories(saveSshClassPath, new FileAttribute[0]);
                    }
                    Path src2 = Paths.get(exportFile.getPath(), new String[0]);
                    Path target = Paths.get(saveClassPath.toString(), classFileNameSuffix);
                    Path sshTarget = Paths.get(saveSshClassPath.toString(), classFileNameSuffix);
                    sourceFileMapDestFile.put(target, src2);
                    sourceFileMapDestFile.put(sshTarget, src2);
                    continue;
                }
                if (!this.containWeb(exportFile.getPath())) continue;
                String relativePath = this.findWebSubPath(exportFile.getPath());
                Path saveStaticPath = Paths.get(finalOutRootPath.toString(), relativePath);
                if (Files.notExists(saveStaticPath, new LinkOption[0])) {
                    Files.createDirectories(saveStaticPath, new FileAttribute[0]);
                }
                if (Files.notExists(saveSshStaticPath = Paths.get(finalSshOutRootPath.toString(), relativePath), new LinkOption[0])) {
                    Files.createDirectories(saveSshStaticPath, new FileAttribute[0]);
                }
                Path src3 = Paths.get(exportFile.getPath(), new String[0]);
                sourceFileMapDestFile.put(saveStaticPath, src3);
                sourceFileMapDestFile.put(saveSshStaticPath, src3);
            }
        }
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + sourceFileMapDestFile.size() + "\u4e2a");
        ArrayList all = new ArrayList();
        AtomicInteger total = new AtomicInteger();
        AtomicInteger failedTotal = new AtomicInteger();
        sourceFileMapDestFile.forEach((dest, src) -> all.add(CompletableFuture.runAsync(() -> {
            try {
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString());
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString() + "\u6210\u529f\uff01");
                total.getAndIncrement();
            }
            catch (Exception e) {
                failedTotal.getAndIncrement();
                LOG.error("", (Throwable)e);
            }
        })));
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        long count = module2Files.values().stream().mapToLong(Set::size).sum();
        String content = "\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + count + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u603b\u6570\u91cf\uff1a" + sourceFileMapDestFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a).<br> ";
        NotificationHelper.showInfo(project, content, "\u6253\u5f00\u5bfc\u51fa\u7684\u6839\u8def\u5f84", "file://" + outRootPath);
    }

    private String findWebSubPath(String path) {
        for (String webPath : Constants.WEB_PATH) {
            if (!path.contains(webPath)) continue;
            int webIndex = path.lastIndexOf(webPath);
            return path.substring(webIndex).replace(webPath, "");
        }
        return "";
    }

    private String findWebPath(String path) {
        for (String webPath : Constants.WEB_PATH) {
            if (!path.contains(webPath)) continue;
            int webIndex = path.lastIndexOf(webPath);
            return path.substring(0, webIndex + webPath.length());
        }
        return "";
    }

    private boolean containWeb(String path) {
        return Arrays.stream(Constants.WEB_PATH).anyMatch(item -> path.lastIndexOf((String)item) > -1);
    }

    private boolean checkSourcePathValid(Map<Module, List<String>> moduleMapSourcePaths, Module module, String path) {
        List sourcePaths = (List)MapUtil.get(moduleMapSourcePaths, (Object)module, List.class);
        if (sourcePaths == null) {
            Object[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRootUrls(false);
            sourcePaths = ListUtil.toList((Object[])sourceRoots);
            moduleMapSourcePaths.put(module, sourcePaths);
        }
        return sourcePaths.stream().anyMatch(path::startsWith);
    }

    private boolean checkWebPathValid(Map<Module, List<String>> moduleMapSourcePaths, Module module, String path) {
        ArrayList<String> sourcePaths = (ArrayList<String>)MapUtil.get(moduleMapSourcePaths, (Object)module, List.class);
        if (sourcePaths == null) {
            sourcePaths = new ArrayList<String>();
            moduleMapSourcePaths.put(module, sourcePaths);
        }
        if (sourcePaths.stream().anyMatch(path::startsWith)) {
            return true;
        }
        if (this.containWeb(path)) {
            sourcePaths.add(this.findWebPath(path));
            return true;
        }
        return false;
    }

    private void onCancel() {
        this.saveHistory();
        this.dispose();
    }

    private void saveHistory() {
        String text = this.tomcatWebPath.getText();
        if (StrUtil.isNotBlank((CharSequence)text)) {
            this.changeHistoryPath(text);
        }
        List sub = this.config.getData();
        if (this.config.getData().size() > 50) {
            sub = CollUtil.sub(this.config.getData(), (int)0, (int)50);
        }
        this.config.setData(sub);
        if (StrUtil.isNotBlank((CharSequence)this.sshPathText.getText())) {
            this.config.getSsh().setOutPath(this.sshPathText.getText());
        }
        if (StrUtil.isNotBlank((CharSequence)this.sshBashPath.getText())) {
            this.config.getSsh().setBashPath(this.sshBashPath.getText());
        }
        if (StrUtil.isNotBlank((CharSequence)this.sshHostText.getText())) {
            this.config.getSsh().setHost(this.sshHostText.getText());
        }
        if (StrUtil.isNumeric((CharSequence)this.sshPortText.getText())) {
            this.config.getSsh().setPort(this.sshPortText.getText());
        }
        if (StrUtil.isNotBlank((CharSequence)this.sshUserText.getText())) {
            this.config.getSsh().setUser(this.sshUserText.getText());
        }
        if (this.sshPasswordText.getPassword() != null && this.sshPasswordText.getPassword().length > 0) {
            this.config.getSsh().setPassword(this.encrypt(String.valueOf(this.sshPasswordText.getPassword())));
        }
        FileUtil.writeString((String)JSONUtil.toJsonPrettyStr((Object)this.config), (String)Constants.HISTORY_PATH, (Charset)StandardCharsets.UTF_8);
    }

    public String encrypt(String info) {
        byte[] key = Base64.decode((CharSequence)this.config.getSsh().getKey());
        DES des = SecureUtil.des((byte[])key);
        return des.encryptHex(info);
    }

    public String decode(String encrypt) {
        byte[] key = Base64.decode((CharSequence)this.config.getSsh().getKey());
        DES des = SecureUtil.des((byte[])key);
        return des.decryptStr(encrypt);
    }

    private void changeHistoryPath(String path) {
        if (StrUtil.isBlank((CharSequence)path)) {
            return;
        }
        this.config.getData().removeIf(item -> StrUtil.equals((CharSequence)item.getPath(), (CharSequence)path));
        this.config.getData().add(RecentPathVO.getInstance(path, System.currentTimeMillis()));
        this.config.setData(this.config.getData().stream().distinct().sorted(Comparator.comparingLong(RecentPathVO::getTimestamp).reversed()).collect(Collectors.toList()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField2;
        JTextField jTextField3;
        JPasswordField jPasswordField;
        JTextField jTextField4;
        JTextField jTextField5;
        JButton jButton;
        JTextField jTextField6;
        JComboBox jComboBox;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel.setMaximumSize(new Dimension(-1, -1));
        jPanel.setMinimumSize(new Dimension(-1, -1));
        jPanel.setPreferredSize(new Dimension(-1, -1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonExport = jButton3 = new JButton();
        jButton3.setText("\u5bfc\u51fa");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton2 = new JButton();
        jButton2.setText("\u53d6\u6d88");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(7, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.historyCombox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 3, 8, 1, 0, 0, null, null, null));
        this.tomcatWebPath = jTextField6 = new JTextField();
        jTextField6.setText("");
        jTextField6.setToolTipText("\u9700\u8981\u586b\u5199\u7684\u76ee\u5f55\u4f8b\u5982\uff1a..\\ApacheJetspeed\\webapps\\seeyon");
        jPanel4.add((Component)jTextField6, new GridConstraints(0, 1, 1, 3, 8, 1, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("\u5386\u53f2\u8bb0\u5f55\uff1a");
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("\u5bfc\u51fa\u6839\u8def\u5f84\uff1a");
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.chooseTomcatWebPath = jButton = new JButton();
        jButton.setText("\u6d4f\u89c8");
        jPanel4.add((Component)jButton, new GridConstraints(0, 4, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("SSH\u5bfc\u51fa\u8def\u5f84\uff1a");
        jPanel4.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.sshPathText = jTextField5 = new JTextField();
        jPanel4.add((Component)jTextField5, new GridConstraints(4, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("SSH \u8d26\u53f7\uff1a");
        jPanel4.add((Component)jLabel4, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("SSH \u5bc6\u7801\uff1a");
        jPanel4.add((Component)jLabel5, new GridConstraints(6, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.sshUserText = jTextField4 = new JTextField();
        jPanel4.add((Component)jTextField4, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.sshPasswordText = jPasswordField = new JPasswordField();
        jPanel4.add((Component)jPasswordField, new GridConstraints(6, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("SSH HOST\uff1a");
        jPanel4.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("SSH \u7aef\u53e3\uff1a");
        jPanel4.add((Component)jLabel7, new GridConstraints(5, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.sshPortText = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(5, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.sshHostText = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("\u662f\u5426\u5f00\u542fSSH\u5bfc\u51fa\uff1a");
        jPanel4.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.sshExportYesBtn = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("\u662f");
        jPanel4.add((Component)jRadioButton2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.sshExportNoBtn = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        jRadioButton.setText("\u5426");
        jPanel4.add((Component)jRadioButton, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("SSH \u53ef\u6267\u884cbash\u7a0b\u5e8f\u8def\u5f84\uff1a");
        jPanel4.add((Component)jLabel9, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.sshBashPath = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(3, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

