/*
 * Decompiled with CFR 0.152.
 */
package com.pineapple.export.helper;

import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.pineapple.export.helper.Constants;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class NotificationHelper {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup(Objects.requireNonNull(Constants.PLUGIN_ID).getIdString());

    public static Notification show(@Nullable Project project, String title, String content, NotificationType type) {
        if (title == null) {
            title = Constants.PLUGIN_NAME;
        }
        Notification notification = NOTIFICATION_GROUP.createNotification(title, content, type);
        notification.notify(project);
        return notification;
    }

    public static Notification open(@Nullable Project project, String title, String content, NotificationType type, String urlText, String url) {
        if (title == null) {
            title = Constants.PLUGIN_NAME;
        }
        Notification notification = NOTIFICATION_GROUP.createNotification(title, content, type);
        notification.addAction((AnAction)new BrowseNotificationAction(urlText, url));
        notification.notify(project);
        return notification;
    }

    public static Notification showInfo(@Nullable Project project, String title, String content, String urlText, String url) {
        return NotificationHelper.open(project, title, content, NotificationType.INFORMATION, urlText, url);
    }

    public static Notification showInfo(@Nullable Project project, String content, String urlText, String url) {
        return NotificationHelper.showInfo(project, null, content, urlText, url);
    }

    public static Notification showError(@Nullable Project project, String title, String content) {
        return NotificationHelper.show(project, title, content, NotificationType.ERROR);
    }

    public static Notification showError(@Nullable Project project, String content) {
        return NotificationHelper.showError(project, null, content);
    }

    public static Notification showWarn(@Nullable Project project, String title, String content) {
        return NotificationHelper.show(project, title, content, NotificationType.WARNING);
    }

    public static Notification showWarn(@Nullable Project project, String content) {
        return NotificationHelper.showWarn(project, null, content);
    }

    public static Notification showInfo(@Nullable Project project, String title, String content) {
        return NotificationHelper.show(project, title, content, NotificationType.INFORMATION);
    }

    public static Notification showInfo(@Nullable Project project, String content) {
        return NotificationHelper.showInfo(project, null, content);
    }
}

