/*
 * Decompiled with CFR 0.152.
 */
package com.pineapple.export.ui;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.pineapple.export.helper.Constants;
import com.pineapple.export.helper.NotificationHelper;
import com.pineapple.export.vo.RecentPathVO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class FastExportUI
extends JDialog {
    private static final Logger LOG = Logger.getInstance(FastExportUI.class);
    private JPanel contentPane;
    private JButton buttonExport;
    private JButton buttonCancel;
    private JTextField tomcatWebPath;
    private JButton chooseTomcatWebPath;
    private JComboBox historyCombox;
    private AnActionEvent event;
    private VirtualFile[] selectedFiles;
    private List<RecentPathVO> historyPaths;
    private DefaultComboBoxModel<RecentPathVO> recentPathComboBoxModel;
    private static final FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
    private RecentPathVO prevPath;

    public FastExportUI(AnActionEvent event, VirtualFile[] selectedFiles) {
        this.$$$setupUI$$$();
        this.recentPathComboBoxModel = new DefaultComboBoxModel();
        this.prevPath = null;
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonExport);
        this.event = event;
        this.selectedFiles = selectedFiles;
        if (!this.initData()) {
            return;
        }
        this.initListener();
    }

    private boolean initData() {
        List<Object> recentPaths;
        block6: {
            Path path = Paths.get(Constants.HISTORY_PATH, new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                try {
                    Files.createFile(path, new FileAttribute[0]);
                    FileUtil.writeString((String)"[]", (String)Constants.HISTORY_PATH, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    LOG.error("\u5386\u53f2\u8bb0\u5f55\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (Throwable)e);
                    return false;
                }
            }
            String historyPathStr = FileUtil.readString((String)Constants.HISTORY_PATH, (Charset)StandardCharsets.UTF_8);
            recentPaths = null;
            try {
                recentPaths = JSONUtil.toList((String)historyPathStr, RecentPathVO.class);
            }
            catch (Exception e) {
                List temp = JSONUtil.toList((String)historyPathStr, String.class);
                if (!CollUtil.isNotEmpty((Collection)temp)) break block6;
                AtomicLong timeMillis = new AtomicLong(System.currentTimeMillis());
                recentPaths = temp.stream().map(item -> RecentPathVO.getInstance(item, timeMillis.getAndIncrement())).collect(Collectors.toList());
            }
        }
        if (recentPaths == null) {
            recentPaths = new ArrayList();
        }
        this.historyPaths = recentPaths.stream().distinct().sorted(Comparator.comparingLong(RecentPathVO::getTimestamp).reversed()).collect(Collectors.toList());
        this.historyCombox.setModel(this.recentPathComboBoxModel);
        this.prevPath = this.historyPaths.get(0);
        ApplicationManager.getApplication().invokeLater(() -> {
            this.recentPathComboBoxModel.addAll(this.historyPaths);
            if (this.prevPath != null) {
                this.tomcatWebPath.setText(this.prevPath.getPath());
                this.historyCombox.setSelectedItem(this.prevPath);
            }
        });
        return true;
    }

    private void initListener() {
        this.buttonExport.addActionListener(e -> this.onOK());
        this.buttonCancel.addActionListener(e -> this.onCancel());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FastExportUI.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        descriptor.setShowFileSystemRoots(true);
        descriptor.setHideIgnored(true);
        descriptor.setTitle("\u5bfc\u51fa\u76ee\u5f55");
        this.chooseTomcatWebPath.addActionListener(e -> {
            VirtualFile toSelect = this.prevPath == null ? null : LocalFileSystem.getInstance().findFileByPath(this.prevPath.getPath());
            VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, (VirtualFile)toSelect);
            if (virtualFile != null && virtualFile.exists()) {
                this.addOneRecentPath(virtualFile.getCanonicalPath());
            }
        });
        this.tomcatWebPath.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String newValue = FastExportUI.this.tomcatWebPath.getText();
                if (StrUtil.isNotBlank((CharSequence)newValue)) {
                    FastExportUI.this.addOneRecentPath(newValue);
                }
            }
        });
        this.historyCombox.addItemListener(e -> {
            if (1 == e.getStateChange()) {
                RecentPathVO path = (RecentPathVO)e.getItem();
                ApplicationManager.getApplication().invokeLater(() -> this.tomcatWebPath.setText(path.getPath()));
            }
        });
        this.historyCombox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String newValue = FastExportUI.this.tomcatWebPath.getText();
                if (StrUtil.isNotBlank((CharSequence)newValue)) {
                    FastExportUI.this.addOneRecentPath(newValue);
                }
            }
        });
        this.tomcatWebPath.requestFocus();
    }

    private void addOneRecentPath(String path) {
        this.changeHistoryPath(path);
        ApplicationManager.getApplication().invokeLater(() -> {
            this.recentPathComboBoxModel.removeAllElements();
            this.recentPathComboBoxModel.addAll(this.historyPaths);
            this.tomcatWebPath.setText(path);
            this.tomcatWebPath.setToolTipText(path);
            this.historyPaths.stream().filter(item -> path.equals(item.getPath())).findFirst().ifPresent(item -> this.historyCombox.setSelectedItem(item));
        });
    }

    private void onOK() {
        HashMap<Module, Set> module2Files = new HashMap<Module, Set>();
        final HashMap<Module, List<String>> moduleMapSourcePaths = new HashMap<Module, List<String>>();
        final boolean[] hasJavaArray = new boolean[]{false};
        for (VirtualFile file : this.selectedFiles) {
            final Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.event.getProject());
            if (module != null) {
                final Set virtualFiles = (Set)MapUtil.get(module2Files, (Object)module, HashSet.class, new HashSet());
                if (!file.isDirectory()) {
                    if (this.checkSourcePathValid(moduleMapSourcePaths, module, file.getUrl()) || this.checkWebPathValid(moduleMapSourcePaths, module, file.getUrl())) {
                        virtualFiles.add(file);
                        if (file.getName().toLowerCase().endsWith(".java")) {
                            hasJavaArray[0] = true;
                        }
                    }
                } else {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                        public boolean visitFile(@NotNull VirtualFile child) {
                            if (child == null) {
                                4.$$$reportNull$$$0(0);
                            }
                            if (!child.isDirectory() && (FastExportUI.this.checkSourcePathValid(moduleMapSourcePaths, module, child.getUrl()) || FastExportUI.this.checkWebPathValid(moduleMapSourcePaths, module, child.getUrl()))) {
                                virtualFiles.add(child);
                                if (child.getName().toLowerCase().endsWith(".java")) {
                                    hasJavaArray[0] = true;
                                }
                            }
                            return super.visitFile(child);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/pineapple/export/ui/FastExportUI$4", "visitFile"));
                        }
                    });
                }
                module2Files.put(module, virtualFiles);
                continue;
            }
            NotificationHelper.showWarn(this.event.getProject(), file.getCanonicalPath() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5757");
        }
        long sum = module2Files.values().stream().mapToLong(Set::size).sum();
        if (module2Files.isEmpty() || sum == 0L) {
            NotificationHelper.showError(this.event.getProject(), "\u8bf7\u5148\u9009\u4e2d\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff01");
            return;
        }
        LOG.info("\u9009\u4e2d\u7684\u6570\u636e\uff1a" + sum);
        String outRootPath = this.tomcatWebPath.getText();
        Project project = this.event.getProject();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        Module[] modules = module2Files.keySet().toArray(new Module[0]);
        boolean hasJava = hasJavaArray[0];
        ApplicationManager.getApplication().invokeLater(() -> {
            if (hasJava) {
                compilerManager.make(project, modules, (aborted, errors, warnings, compileContext) -> {
                    if (aborted) {
                        NotificationHelper.showError(project, "\u4ee3\u7801\u7f16\u8bd1\u88ab\u7ec8\u6b62\uff01");
                        return;
                    }
                    if (errors != 0) {
                        NotificationHelper.showError(project, "\u4ee3\u7801\u7f16\u8bd1\u65f6\u53d1\u751f\u9519\u8bef\uff01");
                        return;
                    }
                    try {
                        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u51c6\u5907\u5bfc\u51fa.......");
                        this.runExport(module2Files, outRootPath, project, modules, compileContext);
                        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5bfc\u51fa\u5b8c\u6210\uff01");
                    }
                    catch (Exception e) {
                        NotificationHelper.showError(project, "\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25\uff01<br>" + e.getMessage());
                        LOG.error("", (Throwable)e);
                    }
                });
            } else {
                try {
                    LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u51c6\u5907\u5bfc\u51fa.......");
                    this.runExport4WithoutJava(module2Files, outRootPath, project);
                    LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5bfc\u51fa\u5b8c\u6210\uff01");
                }
                catch (Exception e) {
                    NotificationHelper.showError(project, "\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25\uff01<br>" + e.getMessage());
                    LOG.error("\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25", (Throwable)e);
                }
            }
        });
        this.saveHistory();
        this.dispose();
    }

    private void runExport(Map<Module, Set<VirtualFile>> module2Files, String outRootPath, Project project, Module[] modules, CompileContext compileContext) throws IOException {
        HashMap<Path, Path> sourceFileMapDestFile = new HashMap<Path, Path>();
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (Module module : modules) {
            VirtualFile compilerOutputPath = compileContext.getModuleOutputDirectory(module);
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            Path finalOutRootPath = Paths.get(outRootPath, new String[0]);
            Set<VirtualFile> virtualFiles = module2Files.get(module);
            for (VirtualFile exportFile : virtualFiles) {
                Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)exportFile, (Project)project);
                if (!module.equals(moduleForFile)) continue;
                Optional<VirtualFile> first = Stream.of(sourceRoots).filter(virtualFile -> exportFile.getUrl().contains(virtualFile.getUrl())).findFirst();
                if (first.isPresent()) {
                    PsiFile psiFile;
                    Path packagePath = Paths.get(first.get().getPath(), new String[0]).relativize(Paths.get(exportFile.getParent().getPath(), new String[0]));
                    String classFileNameSuffix = exportFile.getName();
                    Path classFilesPath = Paths.get(compilerOutputPath.getPath(), packagePath.toString());
                    Path saveClassPath = Paths.get(finalOutRootPath.toString(), "WEB-INF", "classes", packagePath.toString());
                    if (Files.notExists(saveClassPath, new LinkOption[0])) {
                        Files.createDirectories(saveClassPath, new FileAttribute[0]);
                    }
                    if ((psiFile = PsiManager.getInstance((Project)project).findFile(exportFile)) instanceof PsiJavaFile) {
                        PsiClass[] classes;
                        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
                        for (PsiClass aClass : classes = javaFile.getClasses()) {
                            this.findAllClasses(aClass, sourceFileMapDestFile, classFilesPath, saveClassPath, "");
                        }
                        continue;
                    }
                    Path next = Paths.get(classFilesPath.toString(), classFileNameSuffix);
                    Path target = Paths.get(saveClassPath.toString(), classFileNameSuffix);
                    sourceFileMapDestFile.put(next, target);
                    continue;
                }
                if (!this.containWeb(exportFile.getPath())) continue;
                String relativePath = this.findWebSubPath(exportFile.getPath());
                Path saveStaticPath = Paths.get(finalOutRootPath.toString(), relativePath);
                if (Files.notExists(saveStaticPath, new LinkOption[0])) {
                    Files.createDirectories(saveStaticPath, new FileAttribute[0]);
                }
                Path next = Paths.get(exportFile.getPath(), new String[0]);
                sourceFileMapDestFile.put(next, saveStaticPath);
            }
        }
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + sourceFileMapDestFile.size() + "\u4e2a");
        ArrayList all = new ArrayList();
        AtomicInteger total = new AtomicInteger();
        AtomicInteger failedTotal = new AtomicInteger();
        sourceFileMapDestFile.forEach((src, dest) -> all.add(CompletableFuture.runAsync(() -> {
            try {
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString());
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src + ", \u5230\uff1a" + dest + "\u6210\u529f\uff01");
                total.getAndIncrement();
            }
            catch (Exception e) {
                failedTotal.getAndIncrement();
                e.printStackTrace();
            }
        })));
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        long count = module2Files.values().stream().mapToLong(Set::size).sum();
        String content = "\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + count + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u603b\u6570\u91cf\uff1a" + sourceFileMapDestFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a).<br> ";
        NotificationHelper.showInfo(project, content, "\u6253\u5f00\u5bfc\u51fa\u7684\u6839\u8def\u5f84", "file://" + outRootPath);
    }

    private void findAllClasses(PsiClass aClass, Map<Path, Path> sourceFileMapDestFile, Path classFilesPath, Path saveClassPath, String prefixName) {
        String fileName = (StrUtil.isBlank((CharSequence)prefixName) ? "" : prefixName + "$") + aClass.getName();
        Path next = Paths.get(classFilesPath.toString(), fileName + ".class");
        Path target = Paths.get(saveClassPath.toString(), next.getFileName().toString());
        sourceFileMapDestFile.put(next, target);
        try (DirectoryStream<Path> classPathsProxy = Files.newDirectoryStream(classFilesPath, entry -> entry.getFileName().toString().matches("^" + Pattern.quote(fileName + "$") + "\\d+\\.class$"));){
            for (Path next2 : classPathsProxy) {
                Path target2 = Paths.get(saveClassPath.toString(), next2.getFileName().toString());
                sourceFileMapDestFile.put(next2, target2);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        for (PsiClass innerClass : aClass.getInnerClasses()) {
            this.findAllClasses(innerClass, sourceFileMapDestFile, classFilesPath, saveClassPath, fileName);
        }
    }

    private void runExport4WithoutJava(Map<Module, Set<VirtualFile>> module2Files, String outRootPath, Project project) throws IOException {
        HashMap<Path, Path> sourceFileMapDestFile = new HashMap<Path, Path>();
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (Map.Entry<Module, Set<VirtualFile>> entry : module2Files.entrySet()) {
            Module module = entry.getKey();
            Set<VirtualFile> virtualFiles = entry.getValue();
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            Path finalOutRootPath = Paths.get(outRootPath, new String[0]);
            for (VirtualFile exportFile : virtualFiles) {
                Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)exportFile, (Project)project);
                if (!module.equals(moduleForFile)) continue;
                Optional<VirtualFile> first = Stream.of(sourceRoots).filter(virtualFile -> exportFile.getUrl().contains(virtualFile.getUrl())).findFirst();
                if (first.isPresent()) {
                    Path packagePath = Paths.get(first.get().getPath(), new String[0]).relativize(Paths.get(exportFile.getParent().getPath(), new String[0]));
                    String classFileNameSuffix = exportFile.getName();
                    Path saveClassPath = Paths.get(finalOutRootPath.toString(), "WEB-INF", "classes", packagePath.toString());
                    if (Files.notExists(saveClassPath, new LinkOption[0])) {
                        Files.createDirectories(saveClassPath, new FileAttribute[0]);
                    }
                    Path src2 = Paths.get(exportFile.getPath(), new String[0]);
                    Path target = Paths.get(saveClassPath.toString(), classFileNameSuffix);
                    sourceFileMapDestFile.put(src2, target);
                    continue;
                }
                if (!this.containWeb(exportFile.getPath())) continue;
                String relativePath = this.findWebSubPath(exportFile.getPath());
                Path saveStaticPath = Paths.get(finalOutRootPath.toString(), relativePath);
                if (Files.notExists(saveStaticPath, new LinkOption[0])) {
                    Files.createDirectories(saveStaticPath, new FileAttribute[0]);
                }
                Path src3 = Paths.get(exportFile.getPath(), new String[0]);
                sourceFileMapDestFile.put(src3, saveStaticPath);
            }
        }
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + sourceFileMapDestFile.size() + "\u4e2a");
        ArrayList all = new ArrayList();
        AtomicInteger total = new AtomicInteger();
        AtomicInteger failedTotal = new AtomicInteger();
        sourceFileMapDestFile.forEach((src, dest) -> all.add(CompletableFuture.runAsync(() -> {
            try {
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString());
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString() + "\u6210\u529f\uff01");
                total.getAndIncrement();
            }
            catch (Exception e) {
                failedTotal.getAndIncrement();
                LOG.error("", (Throwable)e);
            }
        })));
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        long count = module2Files.values().stream().mapToLong(Set::size).sum();
        String content = "\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + count + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u603b\u6570\u91cf\uff1a" + sourceFileMapDestFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a).<br> ";
        NotificationHelper.showInfo(project, content, "\u6253\u5f00\u5bfc\u51fa\u7684\u6839\u8def\u5f84", "file://" + outRootPath);
    }

    private String findWebSubPath(String path) {
        for (String webPath : Constants.WEB_PATH) {
            if (!path.contains(webPath)) continue;
            int webIndex = path.lastIndexOf(webPath);
            return path.substring(webIndex).replace(webPath, "");
        }
        return "";
    }

    private String findWebPath(String path) {
        for (String webPath : Constants.WEB_PATH) {
            if (!path.contains(webPath)) continue;
            int webIndex = path.lastIndexOf(webPath);
            return path.substring(0, webIndex + webPath.length());
        }
        return "";
    }

    private boolean containWeb(String path) {
        return Arrays.stream(Constants.WEB_PATH).anyMatch(item -> path.lastIndexOf((String)item) > -1);
    }

    private boolean checkSourcePathValid(Map<Module, List<String>> moduleMapSourcePaths, Module module, String path) {
        List sourcePaths = (List)MapUtil.get(moduleMapSourcePaths, (Object)module, List.class);
        if (sourcePaths == null) {
            Object[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRootUrls(false);
            sourcePaths = ListUtil.toList((Object[])sourceRoots);
            moduleMapSourcePaths.put(module, sourcePaths);
        }
        return sourcePaths.stream().anyMatch(path::startsWith);
    }

    private boolean checkWebPathValid(Map<Module, List<String>> moduleMapSourcePaths, Module module, String path) {
        ArrayList<String> sourcePaths = (ArrayList<String>)MapUtil.get(moduleMapSourcePaths, (Object)module, List.class);
        if (sourcePaths == null) {
            sourcePaths = new ArrayList<String>();
            moduleMapSourcePaths.put(module, sourcePaths);
        }
        if (sourcePaths.stream().anyMatch(path::startsWith)) {
            return true;
        }
        if (this.containWeb(path)) {
            sourcePaths.add(this.findWebPath(path));
            return true;
        }
        return false;
    }

    private void onCancel() {
        this.saveHistory();
        this.dispose();
    }

    private void saveHistory() {
        String text = this.tomcatWebPath.getText();
        if (StrUtil.isNotBlank((CharSequence)text)) {
            this.changeHistoryPath(text);
        }
        List sub = this.historyPaths;
        if (this.historyPaths.size() > 50) {
            sub = CollUtil.sub(this.historyPaths, (int)0, (int)50);
        }
        FileUtil.writeString((String)JSONUtil.toJsonPrettyStr(sub), (String)Constants.HISTORY_PATH, (Charset)StandardCharsets.UTF_8);
    }

    private void changeHistoryPath(String path) {
        if (StrUtil.isBlank((CharSequence)path)) {
            return;
        }
        this.historyPaths.removeIf(item -> StrUtil.equals((CharSequence)item.getPath(), (CharSequence)path));
        this.historyPaths.add(RecentPathVO.getInstance(path, System.currentTimeMillis()));
        this.historyPaths = this.historyPaths.stream().distinct().sorted(Comparator.comparingLong(RecentPathVO::getTimestamp).reversed()).collect(Collectors.toList());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextField jTextField;
        JComboBox jComboBox;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel.setMaximumSize(new Dimension(-1, -1));
        jPanel.setMinimumSize(new Dimension(-1, -1));
        jPanel.setPreferredSize(new Dimension(-1, -1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonExport = jButton3 = new JButton();
        jButton3.setText("\u5bfc\u51fa");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton2 = new JButton();
        jButton2.setText("\u53d6\u6d88");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.historyCombox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 2, 8, 1, 0, 0, null, null, null));
        this.tomcatWebPath = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setToolTipText("\u9700\u8981\u586b\u5199\u7684\u76ee\u5f55\u4f8b\u5982\uff1a..\\ApacheJetspeed\\webapps\\seeyon");
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("\u5386\u53f2\u8bb0\u5f55\uff1a");
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("\u5bfc\u51fa\u6839\u8def\u5f84\uff1a");
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.chooseTomcatWebPath = jButton = new JButton();
        jButton.setText("\u6d4f\u89c8");
        jPanel4.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

