/*
 * Decompiled with CFR 0.152.
 */
package com.pineapple.export.config;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.pineapple.export.config.Bug;
import com.pineapple.export.config.Class;
import com.pineapple.export.config.Patch;
import com.pineapple.export.config.PatchDesc;
import com.pineapple.export.config.Source;
import com.pineapple.export.config.Webapps;
import com.pineapple.export.constants.Constants;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Config
implements Serializable {
    private static final Logger LOG = Logger.getInstance(Config.class);
    private static final JSONConfig jsonConfig = JSONConfig.create().setOrder(false).setIgnoreError(false).setIgnoreCase(false).setDateFormat(null).setIgnoreNullValue(false).setTransientSupport(false).setStripTrailingZeros(false);
    private static Config config = null;
    private String outRootPath = "";
    private Source source;
    private Class classes;
    private Patch patch;
    private Bug bug;
    private PatchDesc patchDesc;
    private Webapps webapps;
    private Map<String, String> jarNameMapping;

    private Config() {
    }

    public static Config getInstance() throws Exception {
        Config defaultConfig = Config.getDefaultConfig();
        Config cloneConfig = new Config();
        CopyOptions copyOptions = CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true).setIgnoreCase(false).setTransientSupport(false);
        BeanUtil.copyProperties((Object)defaultConfig, (Object)cloneConfig, (CopyOptions)copyOptions);
        Path path = Paths.get(Constants.CONFIG_FILE_PATH, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
                FileUtil.writeString((String)"{}", (String)Constants.CONFIG_FILE_PATH, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                LOG.error("\u914d\u7f6e\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (Throwable)e);
                throw new Exception(e);
            }
        }
        try {
            String configJson = FileUtil.readString((String)Constants.CONFIG_FILE_PATH, (Charset)StandardCharsets.UTF_8);
            if (StrUtil.isNotBlank((CharSequence)configJson) && !"{}".equals(configJson)) {
                Config diyConfig;
                JSONObject jsonObject = JSONUtil.parseObj((String)configJson);
                if (jsonObject.containsKey((Object)"Source")) {
                    Object object = jsonObject.get((Object)"Source");
                    jsonObject.remove((Object)"Source");
                    jsonObject.putOpt("source", object);
                }
                if ((diyConfig = (Config)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((Object)(configJson = JSONUtil.toJsonStr((JSON)jsonObject)), (JSONConfig)jsonConfig), Config.class)) != null) {
                    if (diyConfig.getJarNameMapping() == null) {
                        diyConfig.setJarNameMapping(new HashMap<String, String>());
                    }
                    BeanUtil.copyProperties((Object)diyConfig, (Object)cloneConfig, (CopyOptions)copyOptions);
                }
            }
        }
        catch (Exception e) {
            LOG.error("\u81ea\u5b9a\u4e49\u914d\u7f6e\u8f6c\u6362\u5931\u8d25\u65f6\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7684\u914d\u7f6e", (Throwable)e);
        }
        config = cloneConfig;
        return config;
    }

    private static Config getDefaultConfig() throws Exception {
        URL url = Config.class.getClassLoader().getResource("idea-export-patch-config-template.conf");
        String configJson = FileUtil.readString((URL)url, (Charset)StandardCharsets.UTF_8);
        Config defaultConfig = (Config)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((Object)configJson, (JSONConfig)jsonConfig), Config.class);
        defaultConfig.getPatch().setSuffixName(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        return config;
    }

    public static void updateConfig(Config config) {
        FileUtil.writeString((String)JSONUtil.toJsonPrettyStr((JSON)JSONUtil.parse((Object)config, (JSONConfig)jsonConfig)), (String)Constants.CONFIG_FILE_PATH, (Charset)StandardCharsets.UTF_8);
    }

    public String getOutRootPath() {
        return this.outRootPath;
    }

    public Source getSource() {
        return this.source;
    }

    public Class getClasses() {
        return this.classes;
    }

    public Patch getPatch() {
        return this.patch;
    }

    public Bug getBug() {
        return this.bug;
    }

    public PatchDesc getPatchDesc() {
        return this.patchDesc;
    }

    public Webapps getWebapps() {
        return this.webapps;
    }

    public Map<String, String> getJarNameMapping() {
        return this.jarNameMapping;
    }

    public void setOutRootPath(String outRootPath) {
        this.outRootPath = outRootPath;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setClasses(Class classes) {
        this.classes = classes;
    }

    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    public void setBug(Bug bug) {
        this.bug = bug;
    }

    public void setPatchDesc(PatchDesc patchDesc) {
        this.patchDesc = patchDesc;
    }

    public void setWebapps(Webapps webapps) {
        this.webapps = webapps;
    }

    public void setJarNameMapping(Map<String, String> jarNameMapping) {
        this.jarNameMapping = jarNameMapping;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$outRootPath = this.getOutRootPath();
        String other$outRootPath = other.getOutRootPath();
        if (this$outRootPath == null ? other$outRootPath != null : !this$outRootPath.equals(other$outRootPath)) {
            return false;
        }
        Source this$source = this.getSource();
        Source other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Class this$classes = this.getClasses();
        Class other$classes = other.getClasses();
        if (this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes)) {
            return false;
        }
        Patch this$patch = this.getPatch();
        Patch other$patch = other.getPatch();
        if (this$patch == null ? other$patch != null : !((Object)this$patch).equals(other$patch)) {
            return false;
        }
        Bug this$bug = this.getBug();
        Bug other$bug = other.getBug();
        if (this$bug == null ? other$bug != null : !((Object)this$bug).equals(other$bug)) {
            return false;
        }
        PatchDesc this$patchDesc = this.getPatchDesc();
        PatchDesc other$patchDesc = other.getPatchDesc();
        if (this$patchDesc == null ? other$patchDesc != null : !((Object)this$patchDesc).equals(other$patchDesc)) {
            return false;
        }
        Webapps this$webapps = this.getWebapps();
        Webapps other$webapps = other.getWebapps();
        if (this$webapps == null ? other$webapps != null : !((Object)this$webapps).equals(other$webapps)) {
            return false;
        }
        Map<String, String> this$jarNameMapping = this.getJarNameMapping();
        Map<String, String> other$jarNameMapping = other.getJarNameMapping();
        return !(this$jarNameMapping == null ? other$jarNameMapping != null : !((Object)this$jarNameMapping).equals(other$jarNameMapping));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $outRootPath = this.getOutRootPath();
        result = result * 59 + ($outRootPath == null ? 43 : $outRootPath.hashCode());
        Source $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Class $classes = this.getClasses();
        result = result * 59 + ($classes == null ? 43 : ((Object)$classes).hashCode());
        Patch $patch = this.getPatch();
        result = result * 59 + ($patch == null ? 43 : ((Object)$patch).hashCode());
        Bug $bug = this.getBug();
        result = result * 59 + ($bug == null ? 43 : ((Object)$bug).hashCode());
        PatchDesc $patchDesc = this.getPatchDesc();
        result = result * 59 + ($patchDesc == null ? 43 : ((Object)$patchDesc).hashCode());
        Webapps $webapps = this.getWebapps();
        result = result * 59 + ($webapps == null ? 43 : ((Object)$webapps).hashCode());
        Map<String, String> $jarNameMapping = this.getJarNameMapping();
        result = result * 59 + ($jarNameMapping == null ? 43 : ((Object)$jarNameMapping).hashCode());
        return result;
    }

    public String toString() {
        return "Config(outRootPath=" + this.getOutRootPath() + ", source=" + this.getSource() + ", classes=" + this.getClasses() + ", patch=" + this.getPatch() + ", bug=" + this.getBug() + ", patchDesc=" + this.getPatchDesc() + ", webapps=" + this.getWebapps() + ", jarNameMapping=" + this.getJarNameMapping() + ")";
    }
}

