/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.util.CharsetUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class FileAppender
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FileWriter writer;
    private final int capacity;
    private final boolean isNewLineMode;
    private final List<String> list = new ArrayList<String>(100);

    public FileAppender(File destFile, int capacity, boolean isNewLineMode) {
        this(destFile, CharsetUtil.CHARSET_UTF_8, capacity, isNewLineMode);
    }

    public FileAppender(File destFile, Charset charset, int capacity, boolean isNewLineMode) {
        this.capacity = capacity;
        this.isNewLineMode = isNewLineMode;
        this.writer = FileWriter.create(destFile, charset);
    }

    public FileAppender append(String line) {
        if (this.list.size() >= this.capacity) {
            this.flush();
        }
        this.list.add(line);
        return this;
    }

    public FileAppender flush() {
        try (PrintWriter pw = this.writer.getPrintWriter(true);){
            for (String str : this.list) {
                pw.print(str);
                if (!this.isNewLineMode) continue;
                pw.println();
            }
        }
        this.list.clear();
        return this;
    }
}

