/*
 * Decompiled with CFR 0.152.
 */
package com.pineapple.export.ui;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.pineapple.export.config.Config;
import com.pineapple.export.constants.Constants;
import com.pineapple.export.utils.LogUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jetbrains.annotations.NotNull;

public class FastExportUI
extends JDialog {
    private static final Logger LOG = Logger.getInstance(FastExportUI.class);
    private JPanel contentPane;
    private JButton buttonExport;
    private JButton buttonCancel;
    private JTextField sourceOutDirName;
    private JCheckBox sourceTreeCheckBox;
    private JTextField classOutDirName;
    private JCheckBox classTreeCheckBox;
    private JTextField webContextName;
    private JTextField outRootPath;
    private JButton outRootPathChooseBtn;
    private JTextField bugNum;
    private final AnActionEvent event;
    private JTextArea bugDesc;
    private JTextField bugFileName;
    private JTextField webappsNameText;
    private final Project project;
    private final VirtualFile[] selectedFiles;
    private JComboBox<String> oaVersion;
    private JTextField fileNamePrefix;
    private JTextField fileNameSuffix;
    private JTextField fileNameSplit;
    private final Config config;
    private final FileChooserDescriptor descriptor;
    private JCheckBox classesIsExport;
    private JCheckBox sourceIsExport;
    private JCheckBox webappsIsExport;

    public FastExportUI(AnActionEvent event, VirtualFile[] selectedFiles, Config config) {
        this.$$$setupUI$$$();
        this.descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonExport);
        this.config = config;
        this.event = event;
        this.selectedFiles = selectedFiles;
        this.project = event.getProject();
        if (this.project == null) {
            LogUtils.error(null, "\u8bf7\u5148\u914d\u7f6e\u9879\u76ee\u7ed3\u6784\uff01");
            return;
        }
        this.descriptor.setShowFileSystemRoots(true);
        this.descriptor.setHideIgnored(true);
        this.descriptor.setTitle("\u5bfc\u51fa\u6839\u76ee\u5f55");
        this.initEvent();
        this.initUIShowData();
    }

    private void initEvent() {
        this.buttonExport.addActionListener(e -> this.onOK());
        this.buttonCancel.addActionListener(e -> this.onCancel());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FastExportUI.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.outRootPathChooseBtn.addActionListener(e -> {
            VirtualFile toSelect = StrUtil.isBlank((CharSequence)this.config.getOutRootPath()) ? null : LocalFileSystem.getInstance().findFileByPath(this.config.getOutRootPath());
            VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)this.descriptor, null, (VirtualFile)toSelect);
            if (virtualFile != null && virtualFile.exists()) {
                this.outRootPath.setText(virtualFile.getCanonicalPath());
            }
        });
    }

    private void initUIShowData() {
        this.outRootPath.setText(this.config.getOutRootPath());
        this.sourceOutDirName.setText(this.config.getSource().getPrefixFileName());
        this.sourceTreeCheckBox.setSelected(this.config.getSource().getIsTreeStructure());
        this.sourceIsExport.setSelected(this.config.getSource().getNeedExport());
        this.classOutDirName.setText(this.config.getClasses().getPrefixFileName());
        this.classesIsExport.setSelected(this.config.getClasses().getNeedExport());
        this.classTreeCheckBox.setSelected(this.config.getClasses().getIsTreeStructure());
        this.fileNamePrefix.setText(this.config.getPatch().getPrefixName());
        this.fileNameSuffix.setText(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        this.fileNameSplit.setText(this.config.getPatch().getNameSeparator());
        this.bugNum.setText(this.config.getBug().getBugNumber());
        this.config.getBug().getOaVersions().forEach(item -> {
            this.oaVersion.addItem(item.getName());
            if (item.isSelected()) {
                this.config.getBug().setVersion(item.getName());
                this.oaVersion.setSelectedItem(item.getName());
            }
        });
        this.bugDesc.setText(this.config.getBug().getBugDesc());
        this.bugFileName.setText(this.config.getPatchDesc().getTemplateFileName());
        this.webappsNameText.setText(this.config.getWebapps().getWebappsName());
        this.webappsIsExport.setSelected(this.config.getWebapps().getNeedExport());
    }

    private void savePreData() {
        String outRootPathStr = StrUtil.isNotBlank((CharSequence)this.outRootPath.getText()) ? this.outRootPath.getText().trim() : "";
        this.config.setOutRootPath(outRootPathStr);
        String srcOutDirNameStr = StrUtil.isNotBlank((CharSequence)this.sourceOutDirName.getText()) ? this.sourceOutDirName.getText().trim() : "[\u6e90\u7801]";
        boolean isSrcTree = this.sourceTreeCheckBox.isSelected();
        boolean isSrcExport = this.sourceIsExport.isSelected();
        this.config.getSource().setPrefixFileName(srcOutDirNameStr);
        this.config.getSource().setIsTreeStructure(isSrcTree);
        this.config.getSource().setNeedExport(isSrcExport);
        String classOutDirNameStr = StrUtil.isNotBlank((CharSequence)this.classOutDirName.getText()) ? this.classOutDirName.getText().trim() : "[\u8865\u4e01\u5305]";
        boolean isClassExport = this.classesIsExport.isSelected();
        boolean isClassTree = this.classTreeCheckBox.isSelected();
        String webContextNameStr = StrUtil.isNotBlank((CharSequence)this.webContextName.getText()) ? this.webContextName.getText().trim() : "seeyon";
        this.config.getClasses().setPrefixFileName(classOutDirNameStr);
        this.config.getClasses().setNeedExport(isClassExport);
        this.config.getClasses().setIsTreeStructure(isClassTree);
        this.config.getClasses().setWebappsName(webContextNameStr);
        String fileNamePrefixStr = StrUtil.isNotBlank((CharSequence)this.fileNamePrefix.getText()) ? this.fileNamePrefix.getText().trim() : "BUG";
        String fileNameSplitStr = StrUtil.isNotBlank((CharSequence)this.fileNameSplit.getText()) ? this.fileNameSplit.getText().trim() : "_";
        String fileNameSuffixStr = StrUtil.isNotBlank((CharSequence)this.fileNameSuffix.getText()) ? this.fileNameSuffix.getText().trim() : DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        this.config.getPatch().setPrefixName(fileNamePrefixStr);
        this.config.getPatch().setNameSeparator(fileNameSplitStr);
        this.config.getPatch().setSuffixName(fileNameSuffixStr);
        String bugNumStr = StrUtil.isNotBlank((CharSequence)this.bugNum.getText()) ? this.bugNum.getText().trim() : "";
        String bugDescStr = StrUtil.isNotBlank((CharSequence)this.bugDesc.getText()) ? this.bugDesc.getText().trim() : "";
        String oaVersionStr = StrUtil.isNotBlank((CharSequence)this.oaVersion.getSelectedItem().toString()) ? this.oaVersion.getSelectedItem().toString().trim() : "";
        this.config.getBug().setBugNumber(bugNumStr);
        this.config.getBug().setBugDesc(bugDescStr);
        this.config.getBug().getOaVersions().forEach(item -> {
            item.setSelected(StrUtil.equals((CharSequence)oaVersionStr, (CharSequence)item.getName()));
            if (item.isSelected()) {
                this.config.getBug().setVersion(item.getName());
            }
        });
        String bugFileNameStr = StrUtil.isNotBlank((CharSequence)this.bugFileName.getText()) ? this.bugFileName.getText().trim() : "";
        this.config.getPatchDesc().setTemplateFileName(bugFileNameStr);
        String webappsNameTextStr = StrUtil.isNotBlank((CharSequence)this.webappsNameText.getText()) ? this.webappsNameText.getText().trim() : "seeyon";
        boolean webappsIsExportSelected = this.webappsIsExport.isSelected();
        this.config.getWebapps().setWebappsName(webappsNameTextStr);
        this.config.getWebapps().setNeedExport(webappsIsExportSelected);
        Config.updateConfig(this.config);
    }

    private void onOK() {
        String outPath = this.outRootPath.getText().trim();
        if (StrUtil.isBlank((CharSequence)outPath)) {
            LogUtils.waring(this.project, "\u8bf7\u5148\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6839\u8def\u5f84");
            return;
        }
        if (!(this.classesIsExport.isSelected() || this.sourceIsExport.isSelected() || this.webappsIsExport.isSelected())) {
            LogUtils.error(this.project, "\u5fc5\u987b\u8981\u9009\u62e9\u4e00\u4e2a\u8981\u5bfc\u51fa\u7684\u7c7b\u578b");
            return;
        }
        this.savePreData();
        HashMap<Module, Set> module2Files = new HashMap<Module, Set>();
        final HashMap<Module, List<String>> moduleMapSourcePaths = new HashMap<Module, List<String>>();
        final boolean[] hasJavaArray = new boolean[]{false};
        for (VirtualFile file : this.selectedFiles) {
            final Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.event.getProject());
            if (module != null) {
                final Set virtualFiles = (Set)MapUtil.get(module2Files, (Object)module, HashSet.class, new HashSet());
                if (!file.isDirectory()) {
                    if (this.checkFile(moduleMapSourcePaths, file, module)) {
                        virtualFiles.add(file);
                        if (file.getName().toLowerCase().endsWith(".java")) {
                            hasJavaArray[0] = true;
                        }
                    }
                } else {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                        public boolean visitFile(@NotNull VirtualFile child) {
                            if (child == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (!child.isDirectory() && FastExportUI.this.checkFile(moduleMapSourcePaths, child, module)) {
                                virtualFiles.add(child);
                                if (child.getName().toLowerCase().endsWith(".java")) {
                                    hasJavaArray[0] = true;
                                }
                            }
                            return super.visitFile(child);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/pineapple/export/ui/FastExportUI$2", "visitFile"));
                        }
                    });
                }
                module2Files.put(module, virtualFiles);
                continue;
            }
            LogUtils.waring(this.event.getProject(), file.getCanonicalPath() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5757");
        }
        long sum = module2Files.values().stream().mapToLong(Set::size).sum();
        if (module2Files.isEmpty() || sum == 0L) {
            LogUtils.error(null, "\u8bf7\u5148\u9009\u4e2d\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff01");
            return;
        }
        boolean hasJava = hasJavaArray[0];
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.config.getSource().getNeedExport().booleanValue()) {
                try {
                    this.runExport4Source(module2Files);
                }
                catch (IOException e) {
                    LOG.error("\u76ee\u5f55\u521b\u5efa\u4e0d\u6210\u529f\uff01", (Throwable)e);
                    LogUtils.error(this.project, "\u5bfc\u51fa\u5931\u8d25\uff01\u6267\u884c\u5f02\u5e38\u8be6\u60c5\u8bf7\u89c1idea.log");
                    return;
                }
            }
            if (this.config.getClasses().getNeedExport().booleanValue() || this.config.getWebapps().getNeedExport().booleanValue()) {
                if (hasJava) {
                    CompilerManager compilerManager = CompilerManager.getInstance((Project)this.project);
                    Module[] modules = module2Files.keySet().toArray(new Module[0]);
                    compilerManager.make(this.project, modules, (aborted, errors, warnings, compileContext) -> {
                        if (aborted) {
                            LogUtils.error(this.project, "\u4ee3\u7801\u7f16\u8bd1\u88ab\u7ec8\u6b62\uff01");
                            return;
                        }
                        if (errors != 0) {
                            LogUtils.error(this.project, "\u4ee3\u7801\u7f16\u8bd1\u65f6\u53d1\u751f\u9519\u8bef\uff01");
                            return;
                        }
                        try {
                            LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u51c6\u5907\u5bfc\u51fa.......");
                            if (this.config.getClasses().getNeedExport().booleanValue()) {
                                this.runExport4Patch(module2Files, this.project, modules, compileContext);
                            }
                            if (this.config.getWebapps().getNeedExport().booleanValue()) {
                                this.runExport4Webapps(module2Files, this.project, modules, compileContext);
                            }
                            LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5bfc\u51fa\u5b8c\u6210\uff01");
                        }
                        catch (Exception e) {
                            LogUtils.error(this.project, "\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25\uff01<br>" + e.getMessage());
                            LOG.error("\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25\uff01", (Throwable)e);
                        }
                        String content = "classes\u5bfc\u51fa\u6210\u529f <a href=\"file://" + this.config.getOutRootPath() + "\" target=\"blank\">\u6253\u5f00\u5bfc\u51fa\u7684\u6839\u8def\u5f84</a>";
                        LogUtils.open(this.project, content);
                    });
                } else {
                    try {
                        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u51c6\u5907\u5bfc\u51fa.......");
                        if (this.config.getClasses().getNeedExport().booleanValue()) {
                            this.runExport4WithoutJavaPatch(module2Files, this.project);
                        }
                        if (this.config.getWebapps().getNeedExport().booleanValue()) {
                            this.runExport4WithoutJavaWebapps(module2Files, this.project);
                        }
                        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5bfc\u51fa\u5b8c\u6210\uff01");
                    }
                    catch (Exception e) {
                        LogUtils.error(this.project, "\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25\uff01<br>" + e.getMessage());
                        LOG.error("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25\uff01", (Throwable)e);
                    }
                }
            }
        });
        this.dispose();
    }

    private void runExport4Source(Map<Module, Set<VirtualFile>> module2Files) throws IOException {
        HashMap<Path, Path> sourceFileMapDestFile = new HashMap<Path, Path>();
        String fileName = this.getFileName(this.config.getSource().getPrefixFileName());
        Path finalOutRootPath = Paths.get(this.config.getOutRootPath(), new String[0]);
        for (Map.Entry<Module, Set<VirtualFile>> entry : module2Files.entrySet()) {
            Module module = entry.getKey();
            Set<VirtualFile> virtualFiles = entry.getValue();
            for (VirtualFile exportFile : virtualFiles) {
                Path saveClassPath;
                String moduleFileUrl = ModuleUtilCore.getModuleDirPath((Module)module);
                String moduleName = module.getName();
                VirtualFile moduleDirFile = VirtualFileManager.getInstance().findFileByUrl("file://" + moduleFileUrl.substring(0, moduleFileUrl.indexOf(moduleName) + moduleName.length()));
                if (!this.config.getSource().getIsTreeStructure().booleanValue()) {
                    saveClassPath = Paths.get(finalOutRootPath.toString(), fileName, moduleName, exportFile.getName());
                } else {
                    Path relativizePath = Paths.get(moduleDirFile.getPath(), new String[0]).relativize(Paths.get(exportFile.getPath(), new String[0]));
                    saveClassPath = Paths.get(finalOutRootPath.toString(), fileName, moduleName, relativizePath.toString());
                }
                Path next = Paths.get(exportFile.getPath(), new String[0]);
                Path target = Paths.get(saveClassPath.toString(), new String[0]);
                sourceFileMapDestFile.put(next, target);
            }
        }
        LOG.info("\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + sourceFileMapDestFile.size() + "\u4e2a");
        ArrayList all = new ArrayList();
        AtomicInteger total = new AtomicInteger();
        AtomicInteger failedTotal = new AtomicInteger();
        sourceFileMapDestFile.forEach((src, dest) -> all.add(CompletableFuture.runAsync(() -> {
            try {
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString());
                if (Files.notExists(dest.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                }
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString() + "\u6210\u529f\uff01");
                total.getAndIncrement();
            }
            catch (Exception e) {
                failedTotal.getAndIncrement();
            }
        })));
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        long count = module2Files.values().stream().mapToLong(Set::size).sum();
        String content = "\u6e90\u7801\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + count + "\u4e2a).<br>  \u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a).<br>  <a href=\"file://" + finalOutRootPath + "\" target=\"blank\">\u6253\u5f00\u5bfc\u51fa\u7684\u6839\u8def\u5f84</a>";
        LogUtils.open(this.project, content);
    }

    private void runExport4Webapps(Map<Module, Set<VirtualFile>> module2Files, Project project, Module[] modules, CompileContext compileContext) throws IOException {
        HashMap<Path, Path> sourceFileMapDestFile = new HashMap<Path, Path>();
        String outRootPath = this.config.getOutRootPath();
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (Module module : modules) {
            VirtualFile compilerOutputPath = compileContext.getModuleOutputDirectory(module);
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            Path finalOutRootPath = Paths.get(outRootPath, new String[0]);
            Set<VirtualFile> virtualFiles = module2Files.get(module);
            for (VirtualFile exportFile : virtualFiles) {
                Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)exportFile, (Project)project);
                if (!module.equals(moduleForFile)) continue;
                Optional<VirtualFile> first = Stream.of(sourceRoots).filter(virtualFile -> exportFile.getUrl().contains(virtualFile.getUrl())).findFirst();
                if (first.isPresent()) {
                    Path packagePath = Paths.get(first.get().getPath(), new String[0]).relativize(Paths.get(exportFile.getParent().getPath(), new String[0]));
                    String classFileNameSuffix = exportFile.getName();
                    String classFileName = exportFile.getNameWithoutExtension();
                    String classSuffix = exportFile.getExtension();
                    Path classFilesPath = Paths.get(compilerOutputPath.getPath(), packagePath.toString());
                    Path saveClassPath = Paths.get(finalOutRootPath.toString(), this.config.getWebapps().getWebappsName(), "WEB-INF", "classes", packagePath.toString());
                    if (Files.notExists(saveClassPath, new LinkOption[0])) {
                        Files.createDirectories(saveClassPath, new FileAttribute[0]);
                    }
                    if ("java".equals(classSuffix)) {
                        DirectoryStream<Path> classPaths = Files.newDirectoryStream(classFilesPath, classFileName + ".class");
                        for (Path next : classPaths) {
                            Path target = Paths.get(saveClassPath.toString(), next.getFileName().toString());
                            sourceFileMapDestFile.put(next, target);
                        }
                        DirectoryStream<Path> classPathsProxy = Files.newDirectoryStream(classFilesPath, classFileName + "$*.class");
                        for (Path next : classPathsProxy) {
                            Path target = Paths.get(saveClassPath.toString(), next.getFileName().toString());
                            sourceFileMapDestFile.put(next, target);
                        }
                        continue;
                    }
                    Path next = Paths.get(classFilesPath.toString(), classFileNameSuffix);
                    Path target = Paths.get(saveClassPath.toString(), classFileNameSuffix);
                    sourceFileMapDestFile.put(next, target);
                    continue;
                }
                if (!this.containWeb(exportFile.getPath())) continue;
                String relativePath = this.findWebSubPath(exportFile.getPath());
                Path saveStaticPath = Paths.get(finalOutRootPath.toString(), this.config.getWebapps().getWebappsName(), relativePath);
                if (Files.notExists(saveStaticPath, new LinkOption[0])) {
                    Files.createDirectories(saveStaticPath, new FileAttribute[0]);
                }
                Path next = Paths.get(exportFile.getPath(), new String[0]);
                sourceFileMapDestFile.put(next, saveStaticPath);
            }
        }
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + sourceFileMapDestFile.size() + "\u4e2a");
        ArrayList all = new ArrayList();
        AtomicInteger total = new AtomicInteger();
        AtomicInteger failedTotal = new AtomicInteger();
        sourceFileMapDestFile.forEach((src, dest) -> all.add(CompletableFuture.runAsync(() -> {
            try {
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString());
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString() + "\u6210\u529f\uff01");
                total.getAndIncrement();
            }
            catch (Exception e) {
                failedTotal.getAndIncrement();
            }
        })));
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        long count = module2Files.values().stream().mapToLong(Set::size).sum();
        String content = "webapps\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + count + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u603b\u6570\u91cf\uff1a" + sourceFileMapDestFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a). ";
        LogUtils.info(project, content);
    }

    private void runExport4WithoutJavaWebapps(Map<Module, Set<VirtualFile>> module2Files, Project project) throws IOException {
        HashMap<Path, Path> sourceFileMapDestFile = new HashMap<Path, Path>();
        String outRootPath = this.config.getOutRootPath();
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (Map.Entry<Module, Set<VirtualFile>> entry : module2Files.entrySet()) {
            Module module = entry.getKey();
            Set<VirtualFile> virtualFiles = entry.getValue();
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            Path finalOutRootPath = Paths.get(outRootPath, new String[0]);
            for (VirtualFile exportFile : virtualFiles) {
                Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)exportFile, (Project)project);
                if (!module.equals(moduleForFile)) continue;
                Optional<VirtualFile> first = Stream.of(sourceRoots).filter(virtualFile -> exportFile.getUrl().contains(virtualFile.getUrl())).findFirst();
                if (first.isPresent()) {
                    Path packagePath = Paths.get(first.get().getPath(), new String[0]).relativize(Paths.get(exportFile.getParent().getPath(), new String[0]));
                    String classFileNameSuffix = exportFile.getName();
                    Path saveClassPath = Paths.get(finalOutRootPath.toString(), this.config.getWebapps().getWebappsName(), "WEB-INF", "classes", packagePath.toString());
                    if (Files.notExists(saveClassPath, new LinkOption[0])) {
                        Files.createDirectories(saveClassPath, new FileAttribute[0]);
                    }
                    Path src2 = Paths.get(exportFile.getPath(), new String[0]);
                    Path target = Paths.get(saveClassPath.toString(), classFileNameSuffix);
                    sourceFileMapDestFile.put(src2, target);
                    continue;
                }
                if (!this.containWeb(exportFile.getPath())) continue;
                String relativePath = this.findWebSubPath(exportFile.getPath());
                Path saveStaticPath = Paths.get(finalOutRootPath.toString(), this.config.getWebapps().getWebappsName(), relativePath);
                if (Files.notExists(saveStaticPath, new LinkOption[0])) {
                    Files.createDirectories(saveStaticPath, new FileAttribute[0]);
                }
                Path next = Paths.get(exportFile.getPath(), new String[0]);
                sourceFileMapDestFile.put(next, saveStaticPath);
            }
        }
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + sourceFileMapDestFile.size() + "\u4e2a");
        ArrayList all = new ArrayList();
        AtomicInteger total = new AtomicInteger();
        AtomicInteger failedTotal = new AtomicInteger();
        sourceFileMapDestFile.forEach((src, dest) -> all.add(CompletableFuture.runAsync(() -> {
            try {
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString());
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString() + "\u6210\u529f\uff01");
                total.getAndIncrement();
            }
            catch (Exception e) {
                failedTotal.getAndIncrement();
            }
        })));
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        long count = module2Files.values().stream().mapToLong(Set::size).sum();
        String content = "webapps\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + count + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u603b\u6570\u91cf\uff1a" + sourceFileMapDestFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a). ";
        LogUtils.info(project, content);
    }

    private void runExport4Patch(Map<Module, Set<VirtualFile>> module2Files, Project project, Module[] modules, CompileContext compileContext) throws IOException {
        HashMap<Path, Path> sourceFileMapDestFile = new HashMap<Path, Path>();
        String outRootPath = this.config.getOutRootPath();
        String fileName = this.getFileName(this.config.getClasses().getPrefixFileName());
        Path finalOutRootPath = Paths.get(outRootPath, fileName);
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (Module module : modules) {
            VirtualFile compilerOutputPath = compileContext.getModuleOutputDirectory(module);
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            Set<VirtualFile> virtualFiles = module2Files.get(module);
            String moduleName = module.getName();
            for (VirtualFile exportFile : virtualFiles) {
                Path target;
                Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)exportFile, (Project)project);
                if (!module.equals(moduleForFile)) continue;
                Optional<VirtualFile> first = Stream.of(sourceRoots).filter(virtualFile -> exportFile.getUrl().contains(virtualFile.getUrl())).findFirst();
                if (first.isPresent()) {
                    Path packagePath = Paths.get(first.get().getPath(), new String[0]).relativize(Paths.get(exportFile.getParent().getPath(), new String[0]));
                    String classFileNameSuffix = exportFile.getName();
                    String classFileName = exportFile.getNameWithoutExtension();
                    String classSuffix = exportFile.getExtension();
                    Path classFilesPath = Paths.get(compilerOutputPath.getPath(), packagePath.toString());
                    String moduleDirName = StrUtil.isNotBlank((CharSequence)this.config.getClasses().getWebappsName()) ? this.config.getClasses().getWebappsName() + "-" + moduleName : moduleName;
                    Path saveClassPath = Paths.get(finalOutRootPath.toString(), moduleDirName);
                    if (Files.notExists(saveClassPath, new LinkOption[0])) {
                        Files.createDirectories(saveClassPath, new FileAttribute[0]);
                    }
                    if ("java".equals(classSuffix)) {
                        DirectoryStream<Path> classPaths = Files.newDirectoryStream(classFilesPath, classFileName + ".class");
                        for (Path next : classPaths) {
                            Path target2 = this.config.getClasses().getIsTreeStructure() == false ? Paths.get(saveClassPath.toString(), next.getFileName().toString()) : Paths.get(saveClassPath.toString(), packagePath.toString(), next.getFileName().toString());
                            sourceFileMapDestFile.put(next, target2);
                        }
                        DirectoryStream<Path> classPathsProxy = Files.newDirectoryStream(classFilesPath, classFileName + "$*.class");
                        for (Path next : classPathsProxy) {
                            Path target3 = this.config.getClasses().getIsTreeStructure() == false ? Paths.get(saveClassPath.toString(), next.getFileName().toString()) : Paths.get(saveClassPath.toString(), packagePath.toString(), next.getFileName().toString());
                            sourceFileMapDestFile.put(next, target3);
                        }
                        continue;
                    }
                    Path next = Paths.get(classFilesPath.toString(), classFileNameSuffix);
                    Path target4 = this.config.getClasses().getIsTreeStructure() == false ? Paths.get(saveClassPath.toString(), classFileNameSuffix) : Paths.get(saveClassPath.toString(), packagePath.toString(), classFileNameSuffix);
                    sourceFileMapDestFile.put(next, target4);
                    continue;
                }
                if (!this.containWeb(exportFile.getPath())) continue;
                Path next = Paths.get(exportFile.getPath(), new String[0]);
                if (!this.config.getClasses().getIsTreeStructure().booleanValue()) {
                    target = Paths.get(finalOutRootPath.toString(), this.config.getClasses().getWebappsName(), exportFile.getName());
                } else {
                    String relativePath = this.findWebSubPath(exportFile.getPath());
                    target = Paths.get(finalOutRootPath.toString(), this.config.getClasses().getWebappsName(), relativePath);
                }
                sourceFileMapDestFile.put(next, target);
            }
        }
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + sourceFileMapDestFile.size() + "\u4e2a");
        ArrayList all = new ArrayList();
        AtomicInteger total = new AtomicInteger();
        AtomicInteger failedTotal = new AtomicInteger();
        sourceFileMapDestFile.forEach((src, dest) -> all.add(CompletableFuture.runAsync(() -> {
            try {
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString());
                if (Files.notExists(dest.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                }
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString() + "\u6210\u529f\uff01");
                total.getAndIncrement();
            }
            catch (Exception e) {
                failedTotal.getAndIncrement();
            }
        })));
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        this.generatorBugDescFile(finalOutRootPath.toString());
        long count = module2Files.values().stream().mapToLong(Set::size).sum();
        String content = "\u8865\u4e01\u5305\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + count + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u603b\u6570\u91cf\uff1a" + sourceFileMapDestFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a). ";
        LogUtils.info(project, content);
    }

    private void runExport4WithoutJavaPatch(Map<Module, Set<VirtualFile>> module2Files, Project project) throws IOException {
        HashMap<Path, Path> sourceFileMapDestFile = new HashMap<Path, Path>();
        String outRootPath = this.config.getOutRootPath();
        String fileName = this.getFileName(this.config.getClasses().getPrefixFileName());
        Path finalOutRootPath = Paths.get(outRootPath, fileName);
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (Map.Entry<Module, Set<VirtualFile>> entry : module2Files.entrySet()) {
            Module module = entry.getKey();
            Set<VirtualFile> virtualFiles = entry.getValue();
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            String moduleName = module.getName();
            for (VirtualFile exportFile : virtualFiles) {
                Path target;
                Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)exportFile, (Project)project);
                if (!module.equals(moduleForFile)) continue;
                Optional<VirtualFile> first = Stream.of(sourceRoots).filter(virtualFile -> exportFile.getUrl().contains(virtualFile.getUrl())).findFirst();
                if (first.isPresent()) {
                    Path packagePath = Paths.get(first.get().getPath(), new String[0]).relativize(Paths.get(exportFile.getParent().getPath(), new String[0]));
                    String classFileNameSuffix = exportFile.getName();
                    String moduleDirName = StrUtil.isNotBlank((CharSequence)this.config.getClasses().getWebappsName()) ? this.config.getClasses().getWebappsName() + "-" + moduleName : moduleName;
                    Path saveClassPath = Paths.get(finalOutRootPath.toString(), moduleDirName);
                    if (Files.notExists(saveClassPath, new LinkOption[0])) {
                        Files.createDirectories(saveClassPath, new FileAttribute[0]);
                    }
                    Path src2 = Paths.get(exportFile.getPath(), new String[0]);
                    Path target2 = this.config.getClasses().getIsTreeStructure() == false ? Paths.get(saveClassPath.toString(), classFileNameSuffix) : Paths.get(saveClassPath.toString(), packagePath.toString(), classFileNameSuffix);
                    sourceFileMapDestFile.put(src2, target2);
                    continue;
                }
                if (!this.containWeb(exportFile.getPath())) continue;
                Path src3 = Paths.get(exportFile.getPath(), new String[0]);
                if (!this.config.getClasses().getIsTreeStructure().booleanValue()) {
                    target = Paths.get(finalOutRootPath.toString(), this.config.getClasses().getWebappsName(), exportFile.getName());
                } else {
                    String relativePath = this.findWebSubPath(exportFile.getPath());
                    target = Paths.get(finalOutRootPath.toString(), this.config.getClasses().getWebappsName(), relativePath);
                }
                sourceFileMapDestFile.put(src3, target);
            }
        }
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + sourceFileMapDestFile.size() + "\u4e2a");
        ArrayList all = new ArrayList();
        AtomicInteger total = new AtomicInteger();
        AtomicInteger failedTotal = new AtomicInteger();
        sourceFileMapDestFile.forEach((src, dest) -> all.add(CompletableFuture.runAsync(() -> {
            try {
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString());
                if (Files.notExists(dest.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                }
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src.toString() + ", \u5230\uff1a" + dest.toString() + "\u6210\u529f\uff01");
                total.getAndIncrement();
            }
            catch (Exception e) {
                failedTotal.getAndIncrement();
            }
        })));
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        this.generatorBugDescFile(finalOutRootPath.toString());
        long count = module2Files.values().stream().mapToLong(Set::size).sum();
        String content = "\u8865\u4e01\u5305\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + count + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u603b\u6570\u91cf\uff1a" + sourceFileMapDestFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a). ";
        LogUtils.info(project, content);
    }

    private String getFileName(String prefixFileName) {
        return MessageFormat.format("{0}{1}{2}{3}{4}{5}{6}{7}{8}{9}", FileNameUtil.cleanInvalid((String)prefixFileName), FileNameUtil.cleanInvalid((String)this.config.getPatch().getPrefixName()), this.config.getPatch().getNameSeparator(), FileNameUtil.cleanInvalid((String)this.config.getBug().getVersion()), this.config.getPatch().getNameSeparator(), FileNameUtil.cleanInvalid((String)StrUtil.maxLength((CharSequence)this.config.getBug().getBugDesc(), (int)100)), this.config.getPatch().getNameSeparator(), FileNameUtil.cleanInvalid((String)this.config.getBug().getBugNumber()), this.config.getPatch().getNameSeparator(), this.config.getPatch().getSuffixName()).replaceAll("\n|\r|\r\n", "");
    }

    private void generatorBugDescFile(String outPath) {
        String webContextName = this.config.getClasses().getWebappsName();
        String bugFileName = this.config.getPatchDesc().getTemplateFileName();
        String bugNum = this.config.getBug().getBugNumber();
        String oaVersion = this.config.getBug().getVersion();
        String bugDesc = this.config.getBug().getBugDesc();
        File seeyon = new File(outPath);
        if (seeyon.exists()) {
            File[] files = seeyon.listFiles();
            ArrayList moduleNames = new ArrayList();
            Arrays.stream(files).forEach(file -> {
                if (file.isDirectory()) {
                    moduleNames.add(file.getName());
                }
            });
            File bugFixFile = new File(Paths.get(outPath, bugFileName, bugFileName.lastIndexOf(".") > -1 ? "" : ".txt").toString());
            try {
                bugFixFile.delete();
            }
            catch (Exception e) {
                LOG.error("\u751f\u6210\u8bf4\u660e\u6587\u4ef6\u65f6\uff0c\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            }
            try {
                bugFixFile.createNewFile();
            }
            catch (IOException e) {
                LOG.error("\u751f\u6210\u8bf4\u660e\u6587\u4ef6\u65f6\uff0c\u521b\u5efaBUG\u8bf4\u660e\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
            }
            if (bugFixFile.exists()) {
                try {
                    String content = "\u4e00\u3001BUG\u7f16\u53f7\uff1a\n    %s\n\n    \u5236\u4f5c\u65e5\u671f\uff1a%s\n\u4e8c\u3001\u4fee\u6539\u95ee\u9898\uff1a\n    %s\n\n\u4e09\u3001\u9002\u7528\u73af\u5883\uff1a\n\n    \u4f9d\u8d56\u7248\u672c: %s\n    \u6570\u636e\u5e93\uff1a\u6240\u6709\u6570\u636e\u5e93\n\n\u56db\u3001\u64cd\u4f5c\u6b65\u9aa4\uff1a\n\n    \u7b2c\u4e00\u6b65\uff1a\u505c\u6b62A8\u670d\u52a1\n    \u7b2c\u4e8c\u6b65\uff1a\u5907\u4efd\u6587\u4ef6\u3001\u6587\u4ef6\u5939\uff08\u6ce8\u610f\u662f\u5907\u4efd\uff0c\u4e0d\u662f\u5c06\u539f\u6587\u4ef6\u3001\u6587\u4ef6\u5939\u66f4\u540d\u6216\u5220\u9664\uff09 \u5907\u4efdApacheJetspeed\\webapps\\seeyon\u6587\u4ef6\u5939\n    \u7b2c\u4e09\u6b65\uff1a\u8986\u76d6\u6587\u4ef6\u3001\u6587\u4ef6\u5939\n        %s\n        \n    \u7b2c\u56db\u6b65\uff1a\u6e05\u7a7aA8\u7684\\ApacheJetspeed\\work\u76ee\u5f55\u4e0b\u6240\u6709\u5185\u5bb9\uff1b \n\n    \u7b2c\u4e94\u6b65\uff1a\u542f\u52a8A8\u670d\u52a1\uff1b\n\n    \u7b2c\u516d\u6b65: \u6e05\u9664\u5ba2\u6237\u7aef\u6d4f\u89c8\u5668\u7f13\u5b58\u548cie\u4e34\u65f6\u6587\u4ef6\n\n";
                    StringBuilder desc = new StringBuilder();
                    ArrayList<String> descList = new ArrayList<String>();
                    if (moduleNames.contains(webContextName)) {
                        descList.add("%s\u3001\u5c06\u8865\u4e01\u5305\u4e0b\u7684seeyon\u6587\u4ef6\u5939\u62f7\u8d1d\u5230\u670d\u52a1\u5668\u4e0b\u7684webapps\\seeyon \u6587\u4ef6\u5939\u7684\u76f8\u540c\u6587\u4ef6 \n");
                    }
                    moduleNames.forEach(fileName -> {
                        if (!fileName.equals(webContextName)) {
                            descList.add("%s\u3001\u627e\u5230\u5b89\u88c5\u76ee\u5f55\u7684ApacheJetspeed\u4e0b\u7684webapps\\seeyon\\WEB-INF\\lib \u6587\u4ef6\u5939\u4e0b\uff1a\u5c06" + fileName + ".jar\u7528\u89e3\u538b\u7f29\u5de5\u5177\u6253\u5f00\uff0c\u7136\u540e\u628a\u8865\u4e01\u5305\u4e0b " + fileName + " \u6587\u4ef6\u52a0\u4e0b\u7684com\u6587\u4ef6\u4e0b \u62d6\u5230\u91cc\u9762\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c\u3002\u7136\u540e\u5173\u95ed\u89e3\u538b\u7f29\u540e\u7684" + fileName + ".jar\n");
                        }
                    });
                    for (int i = 0; i < descList.size(); ++i) {
                        desc.append(i == 0 ? "" : "        ").append(String.format((String)descList.get(i), i + 1));
                    }
                    String date = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                    content = String.format(content, bugNum, date, bugDesc, oaVersion, desc);
                    FileUtil.writeString((String)content, (File)bugFixFile, (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    LOG.error("\u751f\u6210\u8bf4\u660e\u6587\u4ef6\u65f6\uff0c\u5199\u5165BUG\u8bf4\u660e\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
                }
            }
        }
    }

    private boolean checkFile(Map<Module, List<String>> moduleMapSourcePaths, VirtualFile file, Module module) {
        return this.checkSourcePathValid(moduleMapSourcePaths, module, file.getUrl()) || this.checkWebPathValid(moduleMapSourcePaths, module, file.getUrl());
    }

    private String findWebSubPath(String path) {
        for (String webPath : Constants.WEB_PATH) {
            if (!path.contains(webPath)) continue;
            int webIndex = path.lastIndexOf(webPath);
            return path.substring(webIndex).replace(webPath, "");
        }
        return "";
    }

    private String findWebPath(String path) {
        for (String webPath : Constants.WEB_PATH) {
            if (!path.contains(webPath)) continue;
            int webIndex = path.lastIndexOf(webPath);
            return path.substring(0, webIndex + webPath.length());
        }
        return "";
    }

    private boolean containWeb(String path) {
        return Arrays.stream(Constants.WEB_PATH).anyMatch(item -> path.lastIndexOf((String)item) > -1);
    }

    private boolean checkSourcePathValid(Map<Module, List<String>> moduleMapSourcePaths, Module module, String path) {
        List sourcePaths = (List)MapUtil.get(moduleMapSourcePaths, (Object)module, List.class);
        if (sourcePaths == null) {
            Object[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRootUrls(false);
            sourcePaths = ListUtil.toList((Object[])sourceRoots);
            moduleMapSourcePaths.put(module, sourcePaths);
        }
        return sourcePaths.stream().anyMatch(path::startsWith);
    }

    private boolean checkWebPathValid(Map<Module, List<String>> moduleMapSourcePaths, Module module, String path) {
        ArrayList<String> sourcePaths = (ArrayList<String>)MapUtil.get(moduleMapSourcePaths, (Object)module, List.class);
        if (sourcePaths == null) {
            sourcePaths = new ArrayList<String>();
            moduleMapSourcePaths.put(module, sourcePaths);
        }
        if (sourcePaths.stream().anyMatch(path::startsWith)) {
            return true;
        }
        if (this.containWeb(path)) {
            sourcePaths.add(this.findWebPath(path));
            return true;
        }
        return false;
    }

    private void onCancel() {
        this.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JTextArea jTextArea;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JTextField jTextField7;
        JTextField jTextField8;
        JCheckBox jCheckBox5;
        JTextField jTextField9;
        JButton jButton;
        JTextField jTextField10;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonExport = jButton3 = new JButton();
        jButton3.setText("\u5bfc\u51fa");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton2 = new JButton();
        jButton2.setText("\u53d6\u6d88");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(20, 6, new Insets(10, 0, 10, 0), -1, -1, false, false));
        jScrollPane.setViewportView(jPanel4);
        JLabel jLabel = new JLabel();
        Font font = this.$$$getFont$$$("Source Code Pro", 1, 16, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        jLabel.setText("\u5bfc\u51fa\u6839\u76ee\u5f55\uff1a");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.outRootPath = jTextField10 = new JTextField();
        jPanel4.add((Component)jTextField10, new GridConstraints(0, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.outRootPathChooseBtn = jButton = new JButton();
        jButton.setText("\u6d4f\u89c8");
        jPanel4.add((Component)jButton, new GridConstraints(0, 5, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        Font font2 = this.$$$getFont$$$("Source Code Pro", 1, 14, jLabel2.getFont());
        if (font2 != null) {
            jLabel2.setFont(font2);
        }
        jLabel2.setText("\u6e90\u6587\u4ef6\u5bfc\u51fa\u914d\u7f6e");
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("\u8865\u4e01\u5305\u6e90\u7801\u6587\u4ef6\u540d\u79f0\u524d\u7f00\uff1a");
        jPanel4.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.sourceOutDirName = jTextField9 = new JTextField();
        jTextField9.setEditable(true);
        jTextField9.setText("[\u6e90\u7801]");
        jPanel4.add((Component)jTextField9, new GridConstraints(2, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.sourceTreeCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setSelected(true);
        jCheckBox5.setText("\u662f\u5426\u5bfc\u51fa\u6811\u7ed3\u6784");
        jPanel4.add((Component)jCheckBox5, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        Font font3 = this.$$$getFont$$$("Source Code Pro", 1, 14, jLabel4.getFont());
        if (font3 != null) {
            jLabel4.setFont(font3);
        }
        jLabel4.setText("class\u6587\u4ef6\u5bfc\u51fa\u914d\u7f6e");
        jPanel4.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("\u8865\u4e01\u5305\u6587\u4ef6\u540d\u79f0\u524d\u7f00\uff1a");
        jPanel4.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.classOutDirName = jTextField8 = new JTextField();
        jTextField8.setEditable(true);
        ((Component)jTextField8).setEnabled(true);
        jTextField8.setText("[\u8865\u4e01\u5305]");
        jPanel4.add((Component)jTextField8, new GridConstraints(5, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("web\u76ee\u5f55\u540d\u79f0\uff1a");
        jPanel4.add((Component)jLabel6, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.webContextName = jTextField7 = new JTextField();
        jTextField7.setEditable(true);
        jTextField7.setText("seeyon");
        jPanel4.add((Component)jTextField7, new GridConstraints(6, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("BUG\u7f16\u53f7\uff1a");
        jPanel4.add((Component)jLabel7, new GridConstraints(13, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.bugNum = jTextField6 = new JTextField();
        jTextField6.setText("");
        jPanel4.add((Component)jTextField6, new GridConstraints(13, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("OA\u7248\u672c\uff1a");
        jPanel4.add((Component)jLabel8, new GridConstraints(14, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.oaVersion = jComboBox;
        jPanel4.add(jComboBox, new GridConstraints(14, 1, 1, 4, 8, 1, 2, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("\u95ee\u9898\u63cf\u8ff0\uff1a");
        jPanel4.add((Component)jLabel9, new GridConstraints(15, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        Font font4 = this.$$$getFont$$$("Source Code Pro", 1, 14, jLabel10.getFont());
        if (font4 != null) {
            jLabel10.setFont(font4);
        }
        jLabel10.setText("webapps\u5bfc\u51fa\u914d\u7f6e");
        jPanel4.add((Component)jLabel10, new GridConstraints(18, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("\u5bfc\u51fa\u76ee\u5f55\u540d\u79f0\uff1a");
        jPanel4.add((Component)jLabel11, new GridConstraints(19, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.webappsNameText = jTextField5 = new JTextField();
        jTextField5.setText("seeyon");
        jPanel4.add((Component)jTextField5, new GridConstraints(19, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("\u6587\u4ef6\u540d\u79f0\u524d\u7f00\uff1a");
        jPanel4.add((Component)jLabel12, new GridConstraints(9, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.fileNamePrefix = jTextField4 = new JTextField();
        jTextField4.setText("BUG");
        jPanel4.add((Component)jTextField4, new GridConstraints(9, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("\u6587\u4ef6\u540d\u79f0\u5206\u9694\u7b26\uff1a");
        jPanel4.add((Component)jLabel13, new GridConstraints(11, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.fileNameSplit = jTextField3 = new JTextField();
        jTextField3.setText("_");
        jPanel4.add((Component)jTextField3, new GridConstraints(11, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("\u6253\u5305\u8bf4\u660e\u6587\u4ef6\u540d\u79f0\uff1a");
        jPanel4.add((Component)jLabel14, new GridConstraints(17, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.bugFileName = jTextField2 = new JTextField();
        jTextField2.setText("BUG\u4fee\u590d\u5305\u8bf4\u660e.txt");
        jTextField2.setToolTipText("\u8def\u5f84\u5728:C:\\Users\\\u7528\u6237\u540d\u79f0\\");
        jPanel4.add((Component)jTextField2, new GridConstraints(17, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("\u6587\u4ef6\u540d\u79f0\u540e\u7f00\uff1a");
        jPanel4.add((Component)jLabel15, new GridConstraints(10, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.fileNameSuffix = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setToolTipText("\u9ed8\u8ba4\u5f53\u524d\u65e5\u671f");
        jPanel4.add((Component)jTextField, new GridConstraints(10, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel4.add((Component)jScrollPane2, new GridConstraints(15, 1, 1, 4, 0, 3, 7, 7, null, null, null));
        this.bugDesc = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane2.setViewportView(jTextArea);
        JLabel jLabel16 = new JLabel();
        Font font5 = this.$$$getFont$$$("Source Code Pro", 1, 14, jLabel16.getFont());
        if (font5 != null) {
            jLabel16.setFont(font5);
        }
        jLabel16.setText("BUG\u4fee\u590d\u8bf4\u660e\u6587\u4ef6\u5c5e\u6027");
        jPanel4.add((Component)jLabel16, new GridConstraints(16, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel17 = new JLabel();
        Font font6 = this.$$$getFont$$$("Source Code Pro", 1, 14, jLabel17.getFont());
        if (font6 != null) {
            jLabel17.setFont(font6);
        }
        jLabel17.setText("\u6587\u4ef6\u540d\u79f0\u57fa\u7840\u914d\u7f6e");
        jPanel4.add((Component)jLabel17, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.classTreeCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setSelected(true);
        jCheckBox4.setText("\u662f\u5426\u5bfc\u51fa\u6811\u7ed3\u6784");
        jPanel4.add((Component)jCheckBox4, new GridConstraints(7, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel18 = new JLabel();
        Font font7 = this.$$$getFont$$$("Source Code Pro", 1, 14, jLabel18.getFont());
        if (font7 != null) {
            jLabel18.setFont(font7);
        }
        jLabel18.setText("BUG\u76f8\u5173");
        jPanel4.add((Component)jLabel18, new GridConstraints(12, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.classesIsExport = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("\u662f\u5426\u5bfc\u51fa");
        jPanel4.add((Component)jCheckBox3, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.sourceIsExport = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("\u662f\u5426\u5bfc\u51fa");
        jPanel4.add((Component)jCheckBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.webappsIsExport = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("\u662f\u5426\u5bfc\u51fa");
        jPanel4.add((Component)jCheckBox, new GridConstraints(18, 1, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

