/*
 * Decompiled with CFR 0.152.
 */
package com.pineapple.export.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.pineapple.export.constants.Constants;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class OaVersion
implements Serializable {
    public static final List<String> DEFAULT_ALL_VERSIONS = Lists.newArrayList((Object[])new String[]{"V8.1SP1", "V8.1", "V8.0SP2-2021\u5e748\u6708LTS\u7248", "V8.0SP2", "V8.0SP1-2020\u5e7410\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V8.0SP1", "V8.0", "V7.1SP1-2020\u5e747\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V7.1SP1-2020\u5e742\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V7.1SP1-2019\u5e749\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V7.1SP1", "V7.1", "V7.0SP3-2019\u5e746\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V7.0SP3", "V7.0SP2", "V7.0SP1", "V7.0", "V6.1SP2-2018\u5e7410\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V6.1SP2-2018\u5e743\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V6.1SP2", "V6.0SP1-2017\u5e749\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V6.0SP1-2017\u5e744\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V6.0SP1-2016\u5e7412\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V6.0SP1", "V6.0", "V5.6SP1-2017\u5e742\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.6SP1-2016\u5e743\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.6SP1-2015\u5e7412\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.6SP1", "V5.6-2015\u5e747\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.6", "V5.1SP1-2016\u5e747\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.1SP1-2015\u5e748\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.1SP1-2015\u5e743\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.1SP1-2014\u5e7411\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.1SP1", "V5.1-2014\u5e747\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.1", "V5.0SP2-2014\u5e748\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.0SP2-2014\u5e745\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.0SP1-2013\u5e7410\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V5.0SP1", "V5.0", "V3.50SP1-2014\u5e742\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V3.50SP1-2014\u5e7412\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V3.50SP1-2013\u5e749\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V3.50SP1-2013\u5e743\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V3.50SP1-2012\u5e7410\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V3.20SP1-2012\u5e745\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V3.20SP1-2011\u5e7412\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V3.0SP5-2015\u5e747\u6708\u6708\u5ea6\u4fee\u590d\u5305", "V3.0SP5"});
    private static final Logger LOG = Logger.getInstance(OaVersion.class);
    private static final List<OaVersion> defaultOaVersions = DEFAULT_ALL_VERSIONS.stream().map(item -> new OaVersion((String)item, false)).collect(Collectors.toList());
    private String name = "";
    private boolean selected;

    public static List<OaVersion> getOaVersions(boolean getDefault) throws Exception {
        List<OaVersion> oaVersions;
        if (getDefault) {
            oaVersions = defaultOaVersions;
        } else {
            List diyOaVersion;
            Path path = Paths.get(Constants.OA_VERSION_FILE_PATH, new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                try {
                    Files.createFile(path, new FileAttribute[0]);
                }
                catch (Exception e) {
                    LOG.error("\u81ea\u5b9a\u4e49oa\u7248\u672c\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (Throwable)e);
                    throw new Exception(e);
                }
            }
            oaVersions = CollUtil.isNotEmpty((Collection)(diyOaVersion = FileUtil.readLines((String)Constants.OA_VERSION_FILE_PATH, (Charset)StandardCharsets.UTF_8))) ? diyOaVersion.stream().map(item -> new OaVersion((String)item, false)).collect(Collectors.toList()) : defaultOaVersions;
        }
        oaVersions.forEach(oaVersion -> oaVersion.setSelected(false));
        oaVersions.get(0).setSelected(true);
        return oaVersions;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OaVersion)) {
            return false;
        }
        OaVersion other = (OaVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSelected() != other.isSelected()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSelected() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "OaVersion(name=" + this.getName() + ", selected=" + this.isSelected() + ")";
    }

    public OaVersion(String name, boolean selected) {
        this.name = name;
        this.selected = selected;
    }

    public OaVersion() {
    }
}

