/*
 * Decompiled with CFR 0.152.
 */
package com.pineapple.export.config;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.pineapple.export.config.Bug;
import com.pineapple.export.config.Class;
import com.pineapple.export.config.OaVersion;
import com.pineapple.export.config.Patch;
import com.pineapple.export.config.PatchDesc;
import com.pineapple.export.config.Source;
import com.pineapple.export.config.Webapps;
import com.pineapple.export.constants.Constants;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;

public class Config
implements Serializable {
    private static final Logger LOG = Logger.getInstance(Config.class);
    private static final JSONConfig jsonConfig = JSONConfig.create().setOrder(false).setIgnoreError(false).setIgnoreCase(false).setDateFormat(null).setIgnoreNullValue(false).setTransientSupport(false).setStripTrailingZeros(false);
    private static Config config = null;
    private String outRootPath = "";
    private Source Source;
    private Class classes;
    private Patch patch;
    private Bug bug;
    private PatchDesc patchDesc;
    private Webapps webapps;

    private Config() {
    }

    public static Config getInstance() throws Exception {
        if (config == null) {
            Config defaultConfig = Config.getDefaultConfig();
            Config cloneConfig = new Config();
            CopyOptions copyOptions = CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true).setIgnoreCase(false).setTransientSupport(false);
            BeanUtil.copyProperties((Object)defaultConfig, (Object)cloneConfig, (CopyOptions)copyOptions);
            Path path = Paths.get(Constants.CONFIG_FILE_PATH, new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                try {
                    Files.createFile(path, new FileAttribute[0]);
                    FileUtil.writeString((String)"{}", (String)Constants.CONFIG_FILE_PATH, (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    LOG.error("\u914d\u7f6e\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (Throwable)e);
                    throw new Exception(e);
                }
            }
            String configJson = FileUtil.readString((String)Constants.CONFIG_FILE_PATH, (Charset)StandardCharsets.UTF_8);
            Config diyConfig = (Config)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((Object)configJson, (JSONConfig)jsonConfig), Config.class);
            BeanUtil.copyProperties((Object)diyConfig, (Object)cloneConfig, (CopyOptions)copyOptions);
            config = cloneConfig;
        }
        return config;
    }

    private static Config getDefaultConfig() throws Exception {
        Config config = new Config();
        config.setOutRootPath("");
        Source source = new Source();
        source.setNeedExport(true);
        source.setPrefixFileName("[\u6e90\u7801]");
        source.setIsTreeStructure(true);
        config.setSource(source);
        Class classes = new Class();
        classes.setNeedExport(true);
        classes.setPrefixFileName("[\u8865\u4e01\u5305]");
        classes.setWebappsName("seeyon");
        classes.setIsTreeStructure(true);
        config.setClasses(classes);
        Patch patchData = new Patch();
        patchData.setPrefixName("BUG");
        patchData.setSuffixName(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        patchData.setNameSeparator("_");
        config.setPatch(patchData);
        Bug bugData = new Bug();
        bugData.setBugNumber("");
        bugData.setOaVersions(OaVersion.getOaVersions(true));
        bugData.setVersion(bugData.getOaVersions().get(0).getName());
        bugData.setBugDesc("");
        config.setBug(bugData);
        PatchDesc patchDescData = new PatchDesc();
        patchDescData.setTemplateFileName("BUG\u4fee\u590d\u5305\u8bf4\u660e\u6a21\u677f.txt");
        config.setPatchDesc(patchDescData);
        Webapps webappsData = new Webapps();
        webappsData.setNeedExport(true);
        webappsData.setWebappsName("seeyon");
        config.setWebapps(webappsData);
        return config;
    }

    public static void updateConfig(Config config) {
        FileUtil.writeString((String)JSONUtil.toJsonPrettyStr((JSON)JSONUtil.parse((Object)config, (JSONConfig)jsonConfig)), (String)Constants.CONFIG_FILE_PATH, (Charset)StandardCharsets.UTF_8);
    }

    public String getOutRootPath() {
        return this.outRootPath;
    }

    public Source getSource() {
        return this.Source;
    }

    public Class getClasses() {
        return this.classes;
    }

    public Patch getPatch() {
        return this.patch;
    }

    public Bug getBug() {
        return this.bug;
    }

    public PatchDesc getPatchDesc() {
        return this.patchDesc;
    }

    public Webapps getWebapps() {
        return this.webapps;
    }

    public void setOutRootPath(String outRootPath) {
        this.outRootPath = outRootPath;
    }

    public void setSource(Source Source2) {
        this.Source = Source2;
    }

    public void setClasses(Class classes) {
        this.classes = classes;
    }

    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    public void setBug(Bug bug) {
        this.bug = bug;
    }

    public void setPatchDesc(PatchDesc patchDesc) {
        this.patchDesc = patchDesc;
    }

    public void setWebapps(Webapps webapps) {
        this.webapps = webapps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$outRootPath = this.getOutRootPath();
        String other$outRootPath = other.getOutRootPath();
        if (this$outRootPath == null ? other$outRootPath != null : !this$outRootPath.equals(other$outRootPath)) {
            return false;
        }
        Source this$Source = this.getSource();
        Source other$Source = other.getSource();
        if (this$Source == null ? other$Source != null : !((Object)this$Source).equals(other$Source)) {
            return false;
        }
        Class this$classes = this.getClasses();
        Class other$classes = other.getClasses();
        if (this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes)) {
            return false;
        }
        Patch this$patch = this.getPatch();
        Patch other$patch = other.getPatch();
        if (this$patch == null ? other$patch != null : !((Object)this$patch).equals(other$patch)) {
            return false;
        }
        Bug this$bug = this.getBug();
        Bug other$bug = other.getBug();
        if (this$bug == null ? other$bug != null : !((Object)this$bug).equals(other$bug)) {
            return false;
        }
        PatchDesc this$patchDesc = this.getPatchDesc();
        PatchDesc other$patchDesc = other.getPatchDesc();
        if (this$patchDesc == null ? other$patchDesc != null : !((Object)this$patchDesc).equals(other$patchDesc)) {
            return false;
        }
        Webapps this$webapps = this.getWebapps();
        Webapps other$webapps = other.getWebapps();
        return !(this$webapps == null ? other$webapps != null : !((Object)this$webapps).equals(other$webapps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $outRootPath = this.getOutRootPath();
        result = result * 59 + ($outRootPath == null ? 43 : $outRootPath.hashCode());
        Source $Source = this.getSource();
        result = result * 59 + ($Source == null ? 43 : ((Object)$Source).hashCode());
        Class $classes = this.getClasses();
        result = result * 59 + ($classes == null ? 43 : ((Object)$classes).hashCode());
        Patch $patch = this.getPatch();
        result = result * 59 + ($patch == null ? 43 : ((Object)$patch).hashCode());
        Bug $bug = this.getBug();
        result = result * 59 + ($bug == null ? 43 : ((Object)$bug).hashCode());
        PatchDesc $patchDesc = this.getPatchDesc();
        result = result * 59 + ($patchDesc == null ? 43 : ((Object)$patchDesc).hashCode());
        Webapps $webapps = this.getWebapps();
        result = result * 59 + ($webapps == null ? 43 : ((Object)$webapps).hashCode());
        return result;
    }

    public String toString() {
        return "Config(outRootPath=" + this.getOutRootPath() + ", Source=" + this.getSource() + ", classes=" + this.getClasses() + ", patch=" + this.getPatch() + ", bug=" + this.getBug() + ", patchDesc=" + this.getPatchDesc() + ", webapps=" + this.getWebapps() + ")";
    }
}

