/*
 * Decompiled with CFR 0.152.
 */
package com.xf.export.ui;

import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.system.OS;
import com.xf.export.config.Config;
import com.xf.export.helper.Constants;
import com.xf.export.helper.MessageHelper;
import com.xf.export.helper.NotificationHelper;
import com.xf.export.ui.FastExportUI;
import com.xf.export.vo.Es6ToEs5VO;
import com.xf.export.vo.RecentPathVO;
import com.xf.export.vo.SSHVO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.client.ScpClientCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 b2\u00020\u0001:\u0001bB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J6\u0010+\u001a\u00020,2\u001c\u0010-\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\f\u0012\n\u0012\u0004\u0012\u000201\u0018\u0001000.2\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u000201H\u0002J6\u00104\u001a\u00020,2\u001c\u0010-\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\f\u0012\n\u0012\u0004\u0012\u000201\u0018\u0001000.2\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u000201H\u0002J\u0010\u00105\u001a\u00020,2\u0006\u00103\u001a\u000201H\u0002JN\u00106\u001a\u0002072\u001c\u00108\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u0001090.2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;0.2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;0.H\u0002J\u0018\u0010=\u001a\u0002012\u0006\u0010>\u001a\u0002012\u0006\u0010?\u001a\u000201H\u0002J\u0018\u0010@\u001a\u00020,2\u0006\u0010A\u001a\u0002012\u0006\u0010?\u001a\u000201H\u0002J\u0018\u0010B\u001a\u0002072\u0006\u0010C\u001a\u0002012\u0006\u0010D\u001a\u00020\u0015H\u0002J8\u0010E\u001a\u0002072\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;0.2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;0.2\u0006\u0010F\u001a\u00020\u0006H\u0002J<\u0010G\u001a\u0002072\u0006\u0010H\u001a\u00020I2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;0.2\u0006\u0010J\u001a\u00020;2\u0006\u0010K\u001a\u00020;2\u0006\u0010L\u001a\u000201H\u0002J\u0010\u0010M\u001a\u0002012\u0006\u00103\u001a\u000201H\u0002J\u0010\u0010N\u001a\u0002012\u0006\u00103\u001a\u000201H\u0002J\b\u0010O\u001a\u00020,H\u0002J\b\u0010P\u001a\u000207H\u0002J\b\u0010Q\u001a\u000207H\u0002J\b\u0010R\u001a\u000207H\u0002J\b\u0010S\u001a\u000207H\u0002J\b\u0010T\u001a\u000207H\u0002J\b\u0010U\u001a\u000207H\u0002J\u001c\u0010V\u001a\u00020,2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;0.H\u0002JC\u0010W\u001a\u0002072\u001c\u00108\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u0001090.2\u000e\u0010X\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0\u00052\u0006\u0010Y\u001a\u00020ZH\u0002\u00a2\u0006\u0002\u0010[J&\u0010\\\u001a\u0002072\u001c\u00108\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u0001090.H\u0002J\b\u0010]\u001a\u000207H\u0002J\b\u0010^\u001a\u000207H\u0002J\b\u0010_\u001a\u000207H\u0002J\b\u0010`\u001a\u000207H\u0002J\b\u0010a\u001a\u000207H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/xf/export/ui/FastExportUI;", "Ljavax/swing/JDialog;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "selectedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "buttonCancel", "Ljavax/swing/JButton;", "buttonExport", "chooseTomcatWebPath", "config", "Lcom/xf/export/config/Config;", "contentPane", "Ljavax/swing/JPanel;", "es6Toes5RadioNoBtn", "Ljavax/swing/JRadioButton;", "es6Toes5RadioYesBtn", "es6Toes5RootPathChooseBtn", "es6Toes5RootPathText", "Ljavax/swing/JTextField;", "es6Toes5SrcFileRootPathChooseBtn", "es6Toes5SrcFileRootPathText", "historyCombo", "Ljavax/swing/JComboBox;", "Lcom/xf/export/vo/RecentPathVO;", "prevPath", "project", "Lcom/intellij/openapi/project/Project;", "recentPathComboBoxModel", "Lcom/intellij/ui/MutableCollectionComboBoxModel;", "[Lcom/intellij/openapi/vfs/VirtualFile;", "sshBashPath", "sshExportNoBtn", "sshExportYesBtn", "sshHostText", "sshPasswordText", "Ljavax/swing/JPasswordField;", "sshPathText", "sshPortText", "sshUserText", "tomcatWebPath", "checkSourcePathValid", "", "moduleMapSourcePaths", "", "Lcom/intellij/openapi/module/Module;", "", "", "module", "path", "checkWebPathValid", "containWeb", "copyFileAndShowMessage", "", "module2Files", "", "destFileMapSourceFile", "Ljava/nio/file/Path;", "es6ToEs5DestFileMapSourceFile", "execCmd", "dir", "cmd", "execCmdGulp", "execDir", "fileChoose", "lastSelectPath", "textField", "fillStaticFile", "exportFile", "findAllClasses", "aClass", "Lcom/intellij/psi/PsiClass;", "classFilesPath", "saveClassPath", "prefixName", "findWebPath", "findWebSubPath", "initData", "initEs6ToEs5", "initHistoryPath", "initListener", "initSsh", "onCancel", "onOK", "runEs6ToEs5", "runExport", "modules", "compileContext", "Lcom/intellij/openapi/compiler/CompileContext;", "(Ljava/util/Map;[Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/compiler/CompileContext;)V", "runExport4WithoutJava", "saveConfig", "saveEs6ToEs5", "saveHistoryPathList", "saveSSH", "sshSCP", "Companion", "Idea-Export-Web2-Jdk17"})
@SourceDebugExtension(value={"SMAP\nFastExportUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastExportUI.kt\ncom/xf/export/ui/FastExportUI\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,873:1\n37#2:874\n36#2,3:875\n37#2:883\n36#2,3:884\n1858#3,3:878\n211#4,2:881\n*S KotlinDebug\n*F\n+ 1 FastExportUI.kt\ncom/xf/export/ui/FastExportUI\n*L\n311#1:874\n311#1:875,3\n608#1:883\n608#1:884,3\n113#1:878,3\n429#1:881,2\n*E\n"})
public final class FastExportUI
extends JDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnActionEvent event;
    @NotNull
    private final VirtualFile[] selectedFiles;
    @Nullable
    private JPanel contentPane;
    @Nullable
    private JButton buttonExport;
    @Nullable
    private JButton buttonCancel;
    @Nullable
    private JTextField tomcatWebPath;
    @Nullable
    private JButton chooseTomcatWebPath;
    @Nullable
    private JComboBox<RecentPathVO> historyCombo;
    @Nullable
    private JTextField sshPathText;
    @Nullable
    private JTextField sshUserText;
    @Nullable
    private JPasswordField sshPasswordText;
    @Nullable
    private JTextField sshPortText;
    @Nullable
    private JTextField sshHostText;
    @Nullable
    private JRadioButton sshExportYesBtn;
    @Nullable
    private JRadioButton sshExportNoBtn;
    @Nullable
    private JTextField sshBashPath;
    @Nullable
    private JRadioButton es6Toes5RadioYesBtn;
    @Nullable
    private JRadioButton es6Toes5RadioNoBtn;
    @Nullable
    private JTextField es6Toes5RootPathText;
    @Nullable
    private JButton es6Toes5RootPathChooseBtn;
    @Nullable
    private JTextField es6Toes5SrcFileRootPathText;
    @Nullable
    private JButton es6Toes5SrcFileRootPathChooseBtn;
    @NotNull
    private MutableCollectionComboBoxModel<RecentPathVO> recentPathComboBoxModel;
    @Nullable
    private RecentPathVO prevPath;
    @NotNull
    private Project project;
    @NotNull
    private Config config;
    @NotNull
    private static Logger LOG;
    @Nullable
    private static FileChooserDescriptor descriptor;

    public FastExportUI(@NotNull AnActionEvent event, @NotNull VirtualFile[] selectedFiles) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)selectedFiles, (String)"selectedFiles");
        this.event = event;
        this.selectedFiles = selectedFiles;
        this.$$$setupUI$$$();
        this.recentPathComboBoxModel = new MutableCollectionComboBoxModel();
        Project project = this.event.getProject();
        Intrinsics.checkNotNull((Object)project);
        this.project = project;
        this.config = Config.Companion.getInstance(this.project);
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonExport);
        ButtonGroup sshBtnGroup = new ButtonGroup();
        sshBtnGroup.add(this.sshExportYesBtn);
        sshBtnGroup.add(this.sshExportNoBtn);
        ButtonGroup es6ToEs5BtnGroup = new ButtonGroup();
        es6ToEs5BtnGroup.add(this.es6Toes5RadioYesBtn);
        es6ToEs5BtnGroup.add(this.es6Toes5RadioNoBtn);
        this.initData();
        this.initListener();
    }

    private final boolean initData() {
        this.initHistoryPath();
        this.initSsh();
        this.initEs6ToEs5();
        return true;
    }

    private final void initHistoryPath() {
        JComboBox<RecentPathVO> jComboBox = this.historyCombo;
        if (jComboBox != null) {
            jComboBox.setModel((ComboBoxModel)this.recentPathComboBoxModel);
        }
        List<RecentPathVO> data = this.config.getData();
        ApplicationManager.getApplication().invokeLater(() -> FastExportUI.initHistoryPath$lambda$1(this, data));
    }

    private final void initEs6ToEs5() {
        Es6ToEs5VO es6ToEs5 = this.config.getEs6ToEs5();
        if (StringUtil.isNotEmpty((String)es6ToEs5.getRootPath())) {
            JTextField jTextField = this.es6Toes5RootPathText;
            if (jTextField != null) {
                jTextField.setText(es6ToEs5.getRootPath());
            }
        }
        if (StringUtil.isNotEmpty((String)es6ToEs5.getFileRootPath())) {
            JTextField jTextField = this.es6Toes5SrcFileRootPathText;
            if (jTextField != null) {
                jTextField.setText(es6ToEs5.getFileRootPath());
            }
        }
    }

    private final void initSsh() {
        SSHVO ssh = this.config.getSsh();
        String string = ssh.getKey();
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            byte[] byArray;
            Base64.Encoder encoder = Base64.getEncoder();
            String string2 = ssh.getKey();
            if (string2 != null) {
                byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            } else {
                byArray = null;
            }
            ssh.setKey(encoder.encodeToString(byArray));
        }
        String string3 = ssh.getOutPath();
        boolean bl2 = string3 != null ? !StringsKt.isBlank((CharSequence)string3) : false;
        if (bl2) {
            JTextField jTextField = this.sshPathText;
            if (jTextField != null) {
                jTextField.setText(ssh.getOutPath());
            }
        }
        if (StringUtil.isNotEmpty((String)ssh.getBashPath())) {
            JTextField jTextField = this.sshBashPath;
            if (jTextField != null) {
                jTextField.setText(ssh.getBashPath());
            }
        }
        if (StringUtil.isNotEmpty((String)ssh.getHost())) {
            JTextField jTextField = this.sshHostText;
            if (jTextField != null) {
                jTextField.setText(ssh.getHost());
            }
        }
        if (StringUtil.isNotEmpty((String)ssh.getPort())) {
            JTextField jTextField = this.sshPortText;
            if (jTextField != null) {
                jTextField.setText(ssh.getPort());
            }
        }
        if (StringUtil.isNotEmpty((String)ssh.getUser())) {
            JTextField jTextField = this.sshUserText;
            if (jTextField != null) {
                jTextField.setText(ssh.getUser());
            }
        }
        if (StringUtil.isNotEmpty((String)ssh.getPassword())) {
            JPasswordField jPasswordField = this.sshPasswordText;
            if (jPasswordField != null) {
                byte[] byArray;
                Base64.Encoder encoder = Base64.getEncoder();
                String string4 = ssh.getPassword();
                if (string4 != null) {
                    byte[] byArray3 = string4.getBytes(Charsets.UTF_8);
                    byArray = byArray3;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
                } else {
                    byArray = null;
                }
                jPasswordField.setText(encoder.encodeToString(byArray));
            }
        }
    }

    private final void initListener() {
        block8: {
            JButton jButton = this.buttonExport;
            if (jButton != null) {
                jButton.addActionListener(arg_0 -> FastExportUI.initListener$lambda$2(this, arg_0));
            }
            JButton jButton2 = this.buttonCancel;
            if (jButton2 != null) {
                jButton2.addActionListener(arg_0 -> FastExportUI.initListener$lambda$3(this, arg_0));
            }
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(this){
                final /* synthetic */ FastExportUI this$0;
                {
                    this.this$0 = $receiver;
                }

                public void windowClosing(@NotNull WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    FastExportUI.access$onCancel(this.this$0);
                }
            });
            JPanel jPanel = this.contentPane;
            if (jPanel != null) {
                jPanel.registerKeyboardAction(arg_0 -> FastExportUI.initListener$lambda$4(this, arg_0), KeyStroke.getKeyStroke(27, 0), 1);
            }
            JButton jButton3 = this.chooseTomcatWebPath;
            if (jButton3 != null) {
                jButton3.addActionListener(arg_0 -> FastExportUI.initListener$lambda$6(this, arg_0));
            }
            JTextField jTextField = this.tomcatWebPath;
            if (jTextField != null) {
                jTextField.addFocusListener(new FocusAdapter(this){
                    final /* synthetic */ FastExportUI this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void focusLost(@NotNull FocusEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        JTextField jTextField = FastExportUI.access$getTomcatWebPath$p(this.this$0);
                        String newValue = jTextField != null ? jTextField.getText() : null;
                        FastExportUI.Companion.getLOG().info("\u5bfc\u51fa\u6839\u8def\u5f84focus\u7684\u8def\u5f84\uff1a" + newValue);
                        String string = newValue;
                        boolean bl = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
                        if (bl) {
                            ApplicationManager.getApplication().invokeLater(() -> initListener.6.focusLost$lambda$0(newValue, this.this$0));
                        }
                    }

                    private static final void focusLost$lambda$0(String $newValue, FastExportUI this$0) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        RecentPathVO instance = RecentPathVO.Companion.getInstance($newValue, System.currentTimeMillis());
                        FastExportUI.access$getRecentPathComboBoxModel$p(this$0).removeElement((Object)instance);
                        FastExportUI.access$getRecentPathComboBoxModel$p(this$0).insertElementAt((Object)instance, 0);
                        FastExportUI.access$getRecentPathComboBoxModel$p(this$0).setSelectedItem((Object)instance);
                    }
                });
            }
            JComboBox<RecentPathVO> jComboBox = this.historyCombo;
            if (jComboBox != null) {
                jComboBox.addItemListener(arg_0 -> FastExportUI.initListener$lambda$8(this, arg_0));
            }
            JButton jButton4 = this.es6Toes5RootPathChooseBtn;
            if (jButton4 != null) {
                jButton4.addActionListener(arg_0 -> FastExportUI.initListener$lambda$9(this, arg_0));
            }
            JButton jButton5 = this.es6Toes5SrcFileRootPathChooseBtn;
            if (jButton5 != null) {
                jButton5.addActionListener(arg_0 -> FastExportUI.initListener$lambda$10(this, arg_0));
            }
            JTextField jTextField2 = this.tomcatWebPath;
            if (jTextField2 == null) break block8;
            jTextField2.requestFocus();
        }
    }

    private final void fileChoose(String lastSelectPath, JTextField textField) {
        VirtualFile toSelect = StringsKt.isBlank((CharSequence)lastSelectPath) ? null : LocalFileSystem.getInstance().findFileByPath(lastSelectPath);
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        Intrinsics.checkNotNull((Object)fileChooserDescriptor);
        VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, null, (VirtualFile)toSelect);
        if (virtualFile != null && virtualFile.exists()) {
            ApplicationManager.getApplication().invokeLater(() -> FastExportUI.fileChoose$lambda$11(textField, virtualFile));
        }
    }

    private final void onOK() {
        String[] file22;
        block23: {
            block24: {
                CharSequence charSequence;
                block21: {
                    block22: {
                        this.saveConfig();
                        JRadioButton jRadioButton = this.sshExportYesBtn;
                        Boolean bl = jRadioButton != null ? Boolean.valueOf(jRadioButton.isSelected()) : null;
                        Intrinsics.checkNotNull((Object)bl);
                        if (!bl.booleanValue()) break block21;
                        JTextField jTextField = this.sshPathText;
                        charSequence = jTextField != null ? jTextField.getText() : null;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block22;
                        JTextField jTextField2 = this.sshUserText;
                        charSequence = jTextField2 != null ? jTextField2.getText() : null;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block22;
                        JTextField jTextField3 = this.sshHostText;
                        charSequence = jTextField3 != null ? jTextField3.getText() : null;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block22;
                        JTextField jTextField4 = this.sshPortText;
                        charSequence = jTextField4 != null ? jTextField4.getText() : null;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block22;
                        JTextField jTextField5 = this.sshBashPath;
                        charSequence = jTextField5 != null ? jTextField5.getText() : null;
                        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) break block21;
                    }
                    NotificationHelper.INSTANCE.showError(this.event.getProject(), "\u8bf7\u5148\u586b\u5199\u5b8c\u6574SSH\u7684\u914d\u7f6e\uff01");
                    return;
                }
                JRadioButton jRadioButton = this.es6Toes5RadioYesBtn;
                Boolean bl = jRadioButton != null ? Boolean.valueOf(jRadioButton.isSelected()) : null;
                Intrinsics.checkNotNull((Object)bl);
                if (!bl.booleanValue()) break block23;
                JTextField jTextField = this.es6Toes5RootPathText;
                charSequence = jTextField != null ? jTextField.getText() : null;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block24;
                JTextField jTextField6 = this.es6Toes5SrcFileRootPathText;
                charSequence = jTextField6 != null ? jTextField6.getText() : null;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) break block23;
            }
            NotificationHelper.INSTANCE.showError(this.event.getProject(), "\u8bf7\u5148\u586b\u5199\u5b8c\u6574ES6\u8f6cES5\u7684\u914d\u7f6e\uff01");
            return;
        }
        Map module2Files = new HashMap();
        Map moduleMapSourcePaths = new HashMap();
        boolean[] objectArray = new boolean[]{false};
        boolean[] hasJavaArray = objectArray;
        for (String[] file22 : this.selectedFiles) {
            block25: {
                Set virtualFiles;
                Module module;
                block28: {
                    block26: {
                        block27: {
                            module = ModuleUtil.findModuleForFile((VirtualFile)file22, (Project)this.project);
                            if (module == null) break block25;
                            virtualFiles = module2Files.getOrDefault(module, new HashSet());
                            if (file22.isDirectory()) break block26;
                            String string = file22.getUrl();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                            if (this.checkSourcePathValid(moduleMapSourcePaths, module, string)) break block27;
                            String string2 = file22.getUrl();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
                            if (!this.checkWebPathValid(moduleMapSourcePaths, module, string2)) break block28;
                        }
                        Set set = virtualFiles;
                        if (set != null) {
                            set.add(file22);
                        }
                        String string = file22.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String string3 = string.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                        if (StringsKt.endsWith$default((String)string3, (String)".java", (boolean)false, (int)2, null)) {
                            hasJavaArray[0] = true;
                        }
                        break block28;
                    }
                    VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)file22, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<VirtualFile>(this, (Map<Module, List<String>>)moduleMapSourcePaths, module, (Set<VirtualFile>)virtualFiles, hasJavaArray, optionArray){
                        final /* synthetic */ FastExportUI this$0;
                        final /* synthetic */ Map<Module, List<String>> $moduleMapSourcePaths;
                        final /* synthetic */ Module $module;
                        final /* synthetic */ Set<VirtualFile> $virtualFiles;
                        final /* synthetic */ boolean[] $hasJavaArray;
                        {
                            this.this$0 = $receiver;
                            this.$moduleMapSourcePaths = $moduleMapSourcePaths;
                            this.$module = $module;
                            this.$virtualFiles = $virtualFiles;
                            this.$hasJavaArray = $hasJavaArray;
                            super($super_call_param$1);
                        }

                        public boolean visitFile(@NotNull VirtualFile child) {
                            block5: {
                                block6: {
                                    Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                                    if (child.isDirectory()) break block5;
                                    String string = child.getUrl();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                                    if (FastExportUI.access$checkSourcePathValid(this.this$0, this.$moduleMapSourcePaths, this.$module, string)) break block6;
                                    String string2 = child.getUrl();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
                                    if (!FastExportUI.access$checkWebPathValid(this.this$0, this.$moduleMapSourcePaths, this.$module, string2)) break block5;
                                }
                                Set<VirtualFile> set = this.$virtualFiles;
                                if (set != null) {
                                    set.add(child);
                                }
                                String string = child.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                String string3 = string.toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                                if (StringsKt.endsWith$default((String)string3, (String)".java", (boolean)false, (int)2, null)) {
                                    this.$hasJavaArray[0] = true;
                                }
                            }
                            return super.visitFile(child);
                        }
                    }));
                }
                module2Files.put(module, virtualFiles);
                continue;
            }
            NotificationHelper.INSTANCE.showWarn(this.event.getProject(), file22.getCanonicalPath() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5757");
        }
        long l = module2Files.values().stream().mapToLong(arg_0 -> FastExportUI.onOK$lambda$12(onOK.sum.1.INSTANCE, arg_0)).sum();
        if (module2Files.isEmpty() || l == 0L) {
            NotificationHelper.INSTANCE.showError(this.event.getProject(), "\u8bf7\u5148\u9009\u4e2d\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff01");
            return;
        }
        file22 = new String[]{"ssh_temp_path"};
        Path finalSshOutRootPath = Paths.get(Constants.INSTANCE.getDESKTOP_PATH(), file22);
        try {
            JRadioButton jRadioButton = this.sshExportYesBtn;
            Intrinsics.checkNotNull((Object)jRadioButton);
            if (jRadioButton.isSelected()) {
                Files.delete(finalSshOutRootPath);
                Files.createDirectories(finalSshOutRootPath, new FileAttribute[0]);
            }
            JRadioButton jRadioButton2 = this.es6Toes5RadioYesBtn;
            Intrinsics.checkNotNull((Object)jRadioButton2);
            if (jRadioButton2.isSelected()) {
                JTextField jTextField = this.es6Toes5SrcFileRootPathText;
                String string = jTextField != null ? jTextField.getText() : null;
                Intrinsics.checkNotNull((Object)string);
                Files.delete(Paths.get(string, new String[0]));
                JTextField jTextField7 = this.es6Toes5SrcFileRootPathText;
                String string4 = jTextField7 != null ? jTextField7.getText() : null;
                Intrinsics.checkNotNull((Object)string4);
                Files.createDirectories(Paths.get(string4, new String[0]), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOG.error("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a", (Throwable)e);
            throw new RuntimeException(e);
        }
        LOG.info("\u9009\u4e2d\u7684\u6570\u636e\uff1a" + l);
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.project);
        Collection $this$toTypedArray$iv = module2Files.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Module[] moduleArray = thisCollection$iv.toArray(new Module[0]);
        if (moduleArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        Module[] modules = moduleArray;
        boolean hasJava = hasJavaArray[0];
        ApplicationManager.getApplication().invokeLater(() -> FastExportUI.onOK$lambda$14(hasJava, compilerManager, this, modules, module2Files));
        this.dispose();
    }

    private final void runExport(Map<Module, Set<VirtualFile>> module2Files, Module[] modules, CompileContext compileContext) {
        Map destFileMapSourceFile = new HashMap();
        Map es6ToEs5DestFileMapSourceFile = new HashMap();
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        int n = modules.length;
        for (int i = 0; i < n; ++i) {
            Set<VirtualFile> virtualFiles;
            Module module;
            Module module2 = module = modules[i];
            Intrinsics.checkNotNull((Object)module2);
            VirtualFile compilerOutputPath = compileContext.getModuleOutputDirectory(module2);
            if (compilerOutputPath == null) {
                LOG.error("\u7f16\u8bd1\u6210\u529f\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6, \u83b7\u53d6\u6a21\u5757\u7684\u7f16\u8bd1\u8f93\u51fa\u8def\u5f84\u4e3anull\uff0c \u4e0d\u53ef\u5bfc\u51fa\uff01");
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ModuleRootManager.getInstance((Module)module).getSourceRoots(false), (String)"getSourceRoots(...)");
            Set<VirtualFile> set = virtualFiles = module2Files.get(module);
            Intrinsics.checkNotNull(set);
            for (VirtualFile exportFile : set) {
                VirtualFile[] sourceRoots;
                Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)exportFile, (Project)this.project);
                if (!Intrinsics.areEqual((Object)module, (Object)moduleForFile)) continue;
                Optional<Object> first2 = Stream.of(Arrays.copyOf(sourceRoots, sourceRoots.length)).filter(arg_0 -> FastExportUI.runExport$lambda$15((Function1)new Function1<VirtualFile, Boolean>(exportFile){
                    final /* synthetic */ VirtualFile $exportFile;
                    {
                        this.$exportFile = $exportFile;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull VirtualFile virtualFile) {
                        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                        String string = this.$exportFile.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                        CharSequence charSequence = string;
                        String string2 = virtualFile.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
                        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null);
                    }
                }, arg_0)).findFirst();
                if (first2.isPresent()) {
                    String classFileNameSuffix;
                    Path packagePath = Paths.get(((VirtualFile)first2.get()).getPath(), new String[0]).relativize(Paths.get(exportFile.getParent().getPath(), new String[0]));
                    Intrinsics.checkNotNullExpressionValue((Object)exportFile.getName(), (String)"getName(...)");
                    String[] stringArray = new String[]{((Object)packagePath).toString()};
                    Path classFilesPath = Paths.get(compilerOutputPath.getPath(), stringArray);
                    JTextField jTextField = this.tomcatWebPath;
                    String string = jTextField != null ? jTextField.getText() : null;
                    Intrinsics.checkNotNull((Object)string);
                    String[] stringArray2 = new String[]{"WEB-INF", "classes", ((Object)packagePath).toString()};
                    Path saveClassPath = Paths.get(((Object)Paths.get(string, new String[0])).toString(), stringArray2);
                    String[] stringArray3 = new String[]{"WEB-INF", "classes", ((Object)packagePath).toString()};
                    Path saveSshClassPath = Paths.get(((Object)Constants.INSTANCE.getSSH_TEMP_PATH()).toString(), stringArray3);
                    PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(exportFile);
                    if (psiFile instanceof PsiJavaFile) {
                        PsiClass[] classes;
                        Intrinsics.checkNotNullExpressionValue((Object)((PsiJavaFile)psiFile).getClasses(), (String)"getClasses(...)");
                        for (PsiClass aClass : classes) {
                            Intrinsics.checkNotNull((Object)aClass);
                            Intrinsics.checkNotNull((Object)classFilesPath);
                            Intrinsics.checkNotNull((Object)saveClassPath);
                            this.findAllClasses(aClass, destFileMapSourceFile, classFilesPath, saveClassPath, "");
                            JRadioButton jRadioButton = this.sshExportYesBtn;
                            Intrinsics.checkNotNull((Object)jRadioButton);
                            if (!jRadioButton.isSelected()) continue;
                            Intrinsics.checkNotNull((Object)saveSshClassPath);
                            this.findAllClasses(aClass, destFileMapSourceFile, classFilesPath, saveSshClassPath, "");
                        }
                        continue;
                    }
                    String[] stringArray4 = new String[]{classFileNameSuffix};
                    Path src = Paths.get(((Object)classFilesPath).toString(), stringArray4);
                    String[] stringArray5 = new String[]{classFileNameSuffix};
                    Path target = Paths.get(((Object)saveClassPath).toString(), stringArray5);
                    Intrinsics.checkNotNull((Object)target);
                    Intrinsics.checkNotNull((Object)src);
                    destFileMapSourceFile.put(target, src);
                    JRadioButton jRadioButton = this.sshExportYesBtn;
                    Intrinsics.checkNotNull((Object)jRadioButton);
                    if (!jRadioButton.isSelected()) continue;
                    String[] stringArray6 = new String[]{classFileNameSuffix};
                    Path sshTarget = Paths.get(((Object)saveSshClassPath).toString(), stringArray6);
                    Intrinsics.checkNotNull((Object)sshTarget);
                    destFileMapSourceFile.put(sshTarget, src);
                    continue;
                }
                String string = exportFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (!this.containWeb(string)) continue;
                this.fillStaticFile(destFileMapSourceFile, es6ToEs5DestFileMapSourceFile, exportFile);
            }
        }
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + destFileMapSourceFile.size() + "\u4e2a");
        this.copyFileAndShowMessage(module2Files, destFileMapSourceFile, es6ToEs5DestFileMapSourceFile);
    }

    private final void copyFileAndShowMessage(Map<Module, Set<VirtualFile>> module2Files, Map<Path, Path> destFileMapSourceFile, Map<Path, Path> es6ToEs5DestFileMapSourceFile) {
        if (this.runEs6ToEs5(es6ToEs5DestFileMapSourceFile)) {
            return;
        }
        Pair num = FastExportUI.Companion.runAsyncForCopyFile(destFileMapSourceFile);
        int total = ((Number)num.getFirst()).intValue();
        int failedTotal = ((Number)num.getSecond()).intValue();
        long count2 = module2Files.values().stream().mapToLong(arg_0 -> FastExportUI.copyFileAndShowMessage$lambda$16(copyFileAndShowMessage.count.1.INSTANCE, arg_0)).sum();
        String content = "\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + count2 + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u603b\u6570\u91cf\uff1a" + destFileMapSourceFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a).<br> ";
        JTextField jTextField = this.tomcatWebPath;
        NotificationHelper.INSTANCE.showInfo(this.project, content, "\u6253\u5f00\u5bfc\u51fa\u7684\u6839\u8def\u5f84", "file://" + (jTextField != null ? jTextField.getText() : null));
    }

    private final boolean runEs6ToEs5(Map<Path, Path> es6ToEs5DestFileMapSourceFile) {
        boolean bl;
        JRadioButton jRadioButton = this.es6Toes5RadioYesBtn;
        Intrinsics.checkNotNull((Object)jRadioButton);
        if (jRadioButton.isSelected()) {
            Boolean bl2;
            CompletableFuture<Boolean> voidCompletableFuture = CompletableFuture.supplyAsync(() -> FastExportUI.runEs6ToEs5$lambda$18(es6ToEs5DestFileMapSourceFile, this));
            try {
                bl2 = voidCompletableFuture.get();
            }
            catch (Exception e) {
                LOG.error("\u7ebf\u7a0b\u5904\u7406\u8fc7\u7a0b\u4e2d\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException(e);
            }
            Boolean bl3 = bl2;
            Intrinsics.checkNotNull((Object)bl3);
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean execCmdGulp(String execDir, String cmd) {
        String cmdResult = this.execCmd(execDir, cmd);
        CharSequence charSequence = cmdResult;
        if (new Regex("\u603b\u8ba1\uff1a\\d+").containsMatchIn(charSequence)) {
            return true;
        }
        boolean windowsCmdNotFound = StringsKt.startsWith$default((String)cmdResult, (String)("'" + cmd + "' "), (boolean)false, (int)2, null);
        boolean linuxCmdNotFound = StringsKt.contains$default((CharSequence)cmdResult, (CharSequence)("/bin/bash: " + cmd + ":"), (boolean)false, (int)2, null);
        if (windowsCmdNotFound || linuxCmdNotFound || StringsKt.contains$default((CharSequence)cmdResult, (CharSequence)("npm install " + cmd), (boolean)false, (int)2, null)) {
            cmdResult = this.execCmd(execDir, "npm install " + cmd + " -g");
            CharSequence charSequence2 = cmdResult;
            return new Regex("(changed|added) \\d+ packages, and audited \\d+ packages").containsMatchIn(charSequence2) ? this.execCmdGulp(execDir, cmd) : false;
        }
        if (StringsKt.contains$default((CharSequence)cmdResult, (CharSequence)"Local modules not found in", (boolean)false, (int)2, null)) {
            cmdResult = this.execCmd(execDir, "npm install");
            CharSequence charSequence3 = cmdResult;
            return new Regex("(changed|added) \\d+ packages, and audited \\d+ packages").containsMatchIn(charSequence3) ? this.execCmdGulp(execDir, cmd) : false;
        }
        if (StringsKt.contains$default((CharSequence)cmdResult, (CharSequence)" Local gulp not found in", (boolean)false, (int)2, null)) {
            cmdResult = this.execCmd(execDir, "npm install " + cmd);
            CharSequence charSequence4 = cmdResult;
            return new Regex("(changed|added) \\d+ packages, and audited \\d+ packages").containsMatchIn(charSequence4) ? this.execCmdGulp(execDir, cmd) : false;
        }
        return false;
    }

    private final String execCmd(String dir, String cmd) {
        List cmdList = new ArrayList();
        if (OS.CURRENT == OS.Windows) {
            cmdList.add("cmd");
            cmdList.add("/c");
            cmdList.add("chcp 65001 & cd /d " + dir + " & " + cmd);
        } else {
            cmdList.add("/bin/bash");
            cmdList.add("-c");
            cmdList.add("cd " + dir + " && " + cmd);
        }
        Process process = null;
        try {
            LOG.info("[ES6\u8f6cES5]\u5f00\u59cb\u6267\u884c\u547d\u4ee4" + CollectionsKt.joinToString$default((Iterable)cmdList, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            process = new ProcessBuilder(cmdList).redirectErrorStream(true).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8), 1024);
            StringBuilder cmdResult = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"Active code page", (boolean)false, (int)2, null)) {
                    cmdResult.append(line);
                }
                LOG.info("[ES6\u8f6cES5]\u547d\u4ee4\u6267\u884c\u8fc7\u7a0b\uff1a" + line);
                line = reader.readLine();
            }
            int waitFor = process.waitFor();
            if (waitFor == 0) {
                LOG.info("[ES6\u8f6cES5]\u547d\u4ee4\u6267\u884c\u6210\u529f\uff01cmd\u7ed3\u679c\uff1a" + cmdResult);
            } else {
                LOG.info("[ES6\u8f6cES5]\u547d\u4ee4\u6267\u884c\u5931\u8d25\uff01cmd\u7ed3\u679c\uff1a" + cmdResult);
            }
            process.destroy();
            String string = cmdResult.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        catch (Exception e) {
            block8: {
                LOG.error("[ES6\u8f6cES5]\u6267\u884c\u5f02\u5e38", (Throwable)e);
                MessageHelper.Companion.alert(LOG, "[ES6\u8f6cES5]\u6267\u884c\u5f02\u5e38" + e.getMessage());
                Process process2 = process;
                if (process2 == null) break block8;
                process2.destroy();
            }
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void fillStaticFile(Map<Path, Path> destFileMapSourceFile, Map<Path, Path> es6ToEs5DestFileMapSourceFile, VirtualFile exportFile) {
        Path src = Paths.get(exportFile.getPath(), new String[0]);
        String string = exportFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String relativeFilePath = this.findWebSubPath(string);
        String[] stringArray = new String[]{relativeFilePath};
        Path saveSshStaticPath = Paths.get(((Object)Constants.INSTANCE.getSSH_TEMP_PATH()).toString(), stringArray);
        JRadioButton jRadioButton = this.es6Toes5RadioYesBtn;
        Intrinsics.checkNotNull((Object)jRadioButton);
        if (jRadioButton.isSelected()) {
            String string2 = exportFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (StringsKt.endsWith$default((String)string3, (String)".js", (boolean)false, (int)2, null)) {
                JTextField jTextField = this.es6Toes5SrcFileRootPathText;
                String string4 = jTextField != null ? jTextField.getText() : null;
                Intrinsics.checkNotNull((Object)string4);
                String[] stringArray2 = new String[]{relativeFilePath};
                Path fileRootPathJsFile = Paths.get(string4, stringArray2);
                Intrinsics.checkNotNull((Object)fileRootPathJsFile);
                Intrinsics.checkNotNull((Object)src);
                es6ToEs5DestFileMapSourceFile.put(fileRootPathJsFile, src);
                JTextField jTextField2 = this.es6Toes5SrcFileRootPathText;
                String string5 = jTextField2 != null ? jTextField2.getText() : null;
                Intrinsics.checkNotNull((Object)string5);
                String[] stringArray3 = new String[]{relativeFilePath + ".map"};
                Path fileRootPathJsMapFile = Paths.get(string5, stringArray3);
                JTextField jTextField3 = this.tomcatWebPath;
                String string6 = jTextField3 != null ? jTextField3.getText() : null;
                Intrinsics.checkNotNull((Object)string6);
                String[] stringArray4 = new String[]{relativeFilePath};
                Path saveStaticJsPath = Paths.get(((Object)Paths.get(string6, new String[0])).toString(), stringArray4);
                JTextField jTextField4 = this.tomcatWebPath;
                String string7 = jTextField4 != null ? jTextField4.getText() : null;
                Intrinsics.checkNotNull((Object)string7);
                String[] stringArray5 = new String[]{relativeFilePath + ".map"};
                Path saveStaticJsMapPath = Paths.get(((Object)Paths.get(string7, new String[0])).toString(), stringArray5);
                Intrinsics.checkNotNull((Object)saveStaticJsPath);
                destFileMapSourceFile.put(saveStaticJsPath, fileRootPathJsFile);
                Intrinsics.checkNotNull((Object)saveStaticJsMapPath);
                Intrinsics.checkNotNull((Object)fileRootPathJsMapFile);
                destFileMapSourceFile.put(saveStaticJsMapPath, fileRootPathJsMapFile);
                JRadioButton jRadioButton2 = this.sshExportYesBtn;
                Intrinsics.checkNotNull((Object)jRadioButton2);
                if (!jRadioButton2.isSelected()) return;
                String[] stringArray6 = new String[]{relativeFilePath + ".map"};
                Path saveSshStaticJsMapPath = Paths.get(((Object)Constants.INSTANCE.getSSH_TEMP_PATH()).toString(), stringArray6);
                Intrinsics.checkNotNull((Object)saveSshStaticPath);
                destFileMapSourceFile.put(saveSshStaticPath, fileRootPathJsFile);
                Intrinsics.checkNotNull((Object)saveSshStaticJsMapPath);
                destFileMapSourceFile.put(saveSshStaticJsMapPath, fileRootPathJsMapFile);
                return;
            }
        }
        JTextField jTextField = this.tomcatWebPath;
        String string8 = jTextField != null ? jTextField.getText() : null;
        Intrinsics.checkNotNull((Object)string8);
        String[] stringArray7 = new String[]{relativeFilePath};
        Path saveStaticPath = Paths.get(((Object)Paths.get(string8, new String[0])).toString(), stringArray7);
        Intrinsics.checkNotNull((Object)saveStaticPath);
        Intrinsics.checkNotNull((Object)src);
        destFileMapSourceFile.put(saveStaticPath, src);
        JRadioButton jRadioButton3 = this.sshExportYesBtn;
        Intrinsics.checkNotNull((Object)jRadioButton3);
        if (!jRadioButton3.isSelected()) return;
        Intrinsics.checkNotNull((Object)saveSshStaticPath);
        destFileMapSourceFile.put(saveSshStaticPath, src);
    }

    private final void sshSCP() {
        CompletableFuture.runAsync(() -> FastExportUI.sshSCP$lambda$22(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void findAllClasses(PsiClass aClass, Map<Path, Path> destFileMapSourceFile, Path classFilesPath, Path saveClassPath, String prefixName) {
        String fileName = (String)(StringsKt.isBlank((CharSequence)prefixName) ? "" : prefixName + "$") + aClass.getName();
        String[] stringArray = new String[]{fileName + ".class"};
        Path src = Paths.get(((Object)classFilesPath).toString(), stringArray);
        String[] object = new String[]{((Object)src.getFileName()).toString()};
        Path target = Paths.get(((Object)saveClassPath).toString(), object);
        Intrinsics.checkNotNull((Object)target);
        Intrinsics.checkNotNull((Object)src);
        destFileMapSourceFile.put(target, src);
        try {
            Closeable closeable = Files.newDirectoryStream(classFilesPath, arg_0 -> FastExportUI.findAllClasses$lambda$23((Function1)new Function1<Path, Boolean>(fileName){
                final /* synthetic */ String $fileName;
                {
                    this.$fileName = $fileName;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Path entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    CharSequence charSequence = ((Object)entry.getFileName()).toString();
                    return new Regex("^" + Pattern.quote(this.$fileName + "$") + "\\d+\\.class$").matches(charSequence);
                }
            }, arg_0));
            Throwable throwable = null;
            try {
                DirectoryStream classPathsProxy = (DirectoryStream)closeable;
                boolean bl = false;
                for (Path src2 : classPathsProxy) {
                    String[] stringArray2 = new String[]{((Object)src2.getFileName()).toString()};
                    Path target2 = Paths.get(((Object)saveClassPath).toString(), stringArray2);
                    Intrinsics.checkNotNull((Object)target2);
                    Intrinsics.checkNotNull((Object)src2);
                    destFileMapSourceFile.put(target2, src2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), (Throwable)iOException);
        }
        PsiClass[] psiClassArray = aClass.getInnerClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getInnerClasses(...)");
        for (PsiClass psiClass : psiClassArray) {
            Intrinsics.checkNotNull((Object)psiClass);
            this.findAllClasses(psiClass, destFileMapSourceFile, classFilesPath, saveClassPath, fileName);
        }
    }

    private final void runExport4WithoutJava(Map<Module, Set<VirtualFile>> module2Files) {
        Map destFileMapSourceFile = new HashMap();
        Map es6ToEs5DestFileMapSourceFile = new HashMap();
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (Map.Entry<Module, Set<VirtualFile>> entry : module2Files.entrySet()) {
            Module module = entry.getKey();
            Set<VirtualFile> virtualFiles = entry.getValue();
            Module module2 = module;
            Intrinsics.checkNotNull((Object)module2);
            Intrinsics.checkNotNullExpressionValue((Object)ModuleRootManager.getInstance((Module)module2).getSourceRoots(false), (String)"getSourceRoots(...)");
            Set<VirtualFile> set = virtualFiles;
            Intrinsics.checkNotNull(set);
            for (VirtualFile exportFile : set) {
                VirtualFile[] sourceRoots;
                Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)exportFile, (Project)this.project);
                if (!Intrinsics.areEqual((Object)module, (Object)moduleForFile)) continue;
                Optional<Object> first2 = Stream.of(Arrays.copyOf(sourceRoots, sourceRoots.length)).filter(arg_0 -> FastExportUI.runExport4WithoutJava$lambda$25((Function1)new Function1<VirtualFile, Boolean>(exportFile){
                    final /* synthetic */ VirtualFile $exportFile;
                    {
                        this.$exportFile = $exportFile;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull VirtualFile virtualFile) {
                        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                        String string = this.$exportFile.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                        CharSequence charSequence = string;
                        String string2 = virtualFile.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
                        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null);
                    }
                }, arg_0)).findFirst();
                if (first2.isPresent()) {
                    String classFileNameSuffix;
                    Path packagePath = Paths.get(((VirtualFile)first2.get()).getPath(), new String[0]).relativize(Paths.get(exportFile.getParent().getPath(), new String[0]));
                    Intrinsics.checkNotNullExpressionValue((Object)exportFile.getName(), (String)"getName(...)");
                    JTextField jTextField = this.tomcatWebPath;
                    String string = jTextField != null ? jTextField.getText() : null;
                    Intrinsics.checkNotNull((Object)string);
                    String[] stringArray = new String[]{"WEB-INF", "classes", ((Object)packagePath).toString()};
                    Path saveClassPath = Paths.get(string, stringArray);
                    String[] stringArray2 = new String[]{"WEB-INF", "classes", ((Object)packagePath).toString()};
                    Path saveSshClassPath = Paths.get(((Object)Constants.INSTANCE.getSSH_TEMP_PATH()).toString(), stringArray2);
                    Path src = Paths.get(exportFile.getPath(), new String[0]);
                    String[] stringArray3 = new String[]{classFileNameSuffix};
                    Path target = Paths.get(((Object)saveClassPath).toString(), stringArray3);
                    Intrinsics.checkNotNull((Object)target);
                    Intrinsics.checkNotNull((Object)src);
                    destFileMapSourceFile.put(target, src);
                    JRadioButton jRadioButton = this.sshExportYesBtn;
                    Intrinsics.checkNotNull((Object)jRadioButton);
                    if (!jRadioButton.isSelected()) continue;
                    String[] stringArray4 = new String[]{classFileNameSuffix};
                    Path sshTarget = Paths.get(((Object)saveSshClassPath).toString(), stringArray4);
                    Intrinsics.checkNotNull((Object)sshTarget);
                    destFileMapSourceFile.put(sshTarget, src);
                    continue;
                }
                String string = exportFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (!this.containWeb(string)) continue;
                this.fillStaticFile(destFileMapSourceFile, es6ToEs5DestFileMapSourceFile, exportFile);
            }
        }
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + destFileMapSourceFile.size() + "\u4e2a");
        this.copyFileAndShowMessage(module2Files, destFileMapSourceFile, es6ToEs5DestFileMapSourceFile);
    }

    private final String findWebSubPath(String path) {
        for (String webPath : Constants.INSTANCE.getWEB_PATH()) {
            if (!StringsKt.contains$default((CharSequence)path, (CharSequence)webPath, (boolean)false, (int)2, null)) continue;
            int webIndex = StringsKt.lastIndexOf$default((CharSequence)path, (String)webPath, (int)0, (boolean)false, (int)6, null);
            String string = path.substring(webIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            return StringsKt.replace$default((String)string, (String)webPath, (String)"", (boolean)false, (int)4, null);
        }
        return "";
    }

    private final String findWebPath(String path) {
        for (String webPath : Constants.INSTANCE.getWEB_PATH()) {
            if (!StringsKt.contains$default((CharSequence)path, (CharSequence)webPath, (boolean)false, (int)2, null)) continue;
            int webIndex = StringsKt.lastIndexOf$default((CharSequence)path, (String)webPath, (int)0, (boolean)false, (int)6, null);
            String string = path.substring(0, webIndex + webPath.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        return "";
    }

    private final boolean containWeb(String path) {
        return Constants.INSTANCE.getWEB_PATH().stream().anyMatch(arg_0 -> FastExportUI.containWeb$lambda$26((Function1)new Function1<String, Boolean>(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@Nullable String item) {
                CharSequence charSequence = this.$path;
                String string = item;
                Intrinsics.checkNotNull((Object)string);
                return StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string, (int)0, (boolean)false, (int)6, null) > -1;
            }
        }, arg_0));
    }

    private final boolean checkSourcePathValid(Map<Module, List<String>> moduleMapSourcePaths, Module module, String path) {
        List sourcePaths = moduleMapSourcePaths.get(module);
        if (sourcePaths == null) {
            Object[] objectArray = ModuleRootManager.getInstance((Module)module).getSourceRootUrls(false);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSourceRootUrls(...)");
            Object[] sourceRoots = objectArray;
            sourcePaths = ArraysKt.toMutableList((Object[])sourceRoots);
            moduleMapSourcePaths.put(module, sourcePaths);
        }
        return sourcePaths.stream().anyMatch(arg_0 -> FastExportUI.checkSourcePathValid$lambda$27((Function1)new Function1<String, Boolean>(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@Nullable String prefix) {
                String string = prefix;
                Intrinsics.checkNotNull((Object)string);
                return StringsKt.startsWith$default((String)this.$path, (String)string, (boolean)false, (int)2, null);
            }
        }, arg_0));
    }

    private final boolean checkWebPathValid(Map<Module, List<String>> moduleMapSourcePaths, Module module, String path) {
        List sourcePaths = moduleMapSourcePaths.get(module);
        if (sourcePaths == null) {
            sourcePaths = new ArrayList();
            moduleMapSourcePaths.put(module, sourcePaths);
        }
        if (sourcePaths.stream().anyMatch(arg_0 -> FastExportUI.checkWebPathValid$lambda$28((Function1)new Function1<String, Boolean>(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@Nullable String prefix) {
                String string = prefix;
                Intrinsics.checkNotNull((Object)string);
                return StringsKt.startsWith$default((String)this.$path, (String)string, (boolean)false, (int)2, null);
            }
        }, arg_0))) {
            return true;
        }
        if (this.containWeb(path)) {
            sourcePaths.add(this.findWebPath(path));
            return true;
        }
        return false;
    }

    private final void onCancel() {
        this.saveConfig();
        this.dispose();
    }

    private final void saveConfig() {
        this.saveHistoryPathList();
        this.saveSSH();
        this.saveEs6ToEs5();
    }

    private final void saveEs6ToEs5() {
        Es6ToEs5VO es6ToEs5 = this.config.getEs6ToEs5();
        JTextField jTextField = this.es6Toes5RootPathText;
        if (StringUtil.isNotEmpty((String)(jTextField != null ? jTextField.getText() : null))) {
            JTextField jTextField2 = this.es6Toes5RootPathText;
            es6ToEs5.setRootPath(jTextField2 != null ? jTextField2.getText() : null);
        }
        JTextField jTextField3 = this.es6Toes5SrcFileRootPathText;
        if (StringUtil.isNotEmpty((String)(jTextField3 != null ? jTextField3.getText() : null))) {
            JTextField jTextField4 = this.es6Toes5SrcFileRootPathText;
            es6ToEs5.setFileRootPath(jTextField4 != null ? jTextField4.getText() : null);
        }
    }

    private final void saveSSH() {
        SSHVO ssh = this.config.getSsh();
        Object object = this.sshPathText;
        boolean bl = object != null && (object = ((JTextComponent)object).getText()) != null ? !StringsKt.isBlank((CharSequence)((CharSequence)object)) : false;
        if (bl) {
            JTextField jTextField = this.sshPathText;
            ssh.setOutPath(jTextField != null ? jTextField.getText() : null);
        }
        JTextField jTextField = this.sshBashPath;
        if (StringUtil.isNotEmpty((String)(jTextField != null ? jTextField.getText() : null))) {
            JTextField jTextField2 = this.sshBashPath;
            ssh.setBashPath(jTextField2 != null ? jTextField2.getText() : null);
        }
        JTextField jTextField3 = this.sshHostText;
        if (StringUtil.isNotEmpty((String)(jTextField3 != null ? jTextField3.getText() : null))) {
            JTextField jTextField4 = this.sshHostText;
            ssh.setHost(jTextField4 != null ? jTextField4.getText() : null);
        }
        JTextField jTextField5 = this.sshPortText;
        if (StringUtil.isNotEmpty((String)(jTextField5 != null ? jTextField5.getText() : null))) {
            JTextField jTextField6 = this.sshPortText;
            ssh.setPort(jTextField6 != null ? jTextField6.getText() : null);
        }
        JTextField jTextField7 = this.sshUserText;
        if (StringUtil.isNotEmpty((String)(jTextField7 != null ? jTextField7.getText() : null))) {
            JTextField jTextField8 = this.sshUserText;
            ssh.setUser(jTextField8 != null ? jTextField8.getText() : null);
        }
        JPasswordField jPasswordField = this.sshPasswordText;
        if ((char[])(jPasswordField != null ? jPasswordField.getPassword() : null) != null) {
            JPasswordField jPasswordField2 = this.sshPasswordText;
            Intrinsics.checkNotNull((Object)jPasswordField2);
            char[] cArray = jPasswordField2.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            if (!(cArray.length == 0)) {
                Base64.Encoder encoder = Base64.getEncoder();
                JPasswordField jPasswordField3 = this.sshPasswordText;
                Intrinsics.checkNotNull((Object)jPasswordField3);
                char[] cArray2 = jPasswordField3.getPassword();
                Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"getPassword(...)");
                ssh.setPassword(encoder.encodeToString(EncryptionSupportKt.toByteArrayAndClear((char[])cArray2)));
            }
        }
    }

    private final void saveHistoryPathList() {
        String path;
        JTextField jTextField = this.tomcatWebPath;
        String string = path = jTextField != null ? jTextField.getText() : null;
        if (StringUtil.isEmpty((String)path)) {
            return;
        }
        List<RecentPathVO> data = this.config.getData();
        data.removeIf(arg_0 -> FastExportUI.saveHistoryPathList$lambda$29((Function1)new Function1<RecentPathVO, Boolean>(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RecentPathVO item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return StringUtil.equals((CharSequence)item.getPath(), (CharSequence)this.$path);
            }
        }, arg_0));
        data.add(RecentPathVO.Companion.getInstance(path, System.currentTimeMillis()));
        Stream<Object> stream = data.stream().distinct().sorted(Comparator.comparingLong(arg_0 -> FastExportUI.saveHistoryPathList$lambda$30(saveHistoryPathList.2.INSTANCE, arg_0)).reversed());
        List<RecentPathVO> list = stream != null ? stream.collect(Collectors.toList()) : null;
        Intrinsics.checkNotNull(list);
        this.config.setData(list);
        List<RecentPathVO> sub = this.config.getData();
        if (sub.size() > 50) {
            sub = sub.subList(0, 50);
        }
        this.config.setData(sub);
    }

    /*
     * WARNING - void declaration
     */
    private static final void initHistoryPath$lambda$1(FastExportUI this$0, List $data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        this$0.recentPathComboBoxModel.removeAll();
        Iterable $this$forEachIndexed$iv = $data;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void recentPathVO;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RecentPathVO recentPathVO2 = (RecentPathVO)item$iv;
            int index = n;
            boolean bl = false;
            this$0.recentPathComboBoxModel.addItem((Object)recentPathVO);
            if (index != 0) continue;
            this$0.recentPathComboBoxModel.setSelectedItem((Object)recentPathVO);
            JTextField jTextField = this$0.tomcatWebPath;
            if (jTextField != null) {
                jTextField.setText(recentPathVO.getPath());
            }
            this$0.prevPath = recentPathVO;
        }
    }

    private static final void initListener$lambda$2(FastExportUI this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onOK();
    }

    private static final void initListener$lambda$3(FastExportUI this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onCancel();
    }

    private static final void initListener$lambda$4(FastExportUI this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onCancel();
    }

    private static final void initListener$lambda$6$lambda$5(FastExportUI this$0, String $newValue) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JTextField jTextField = this$0.tomcatWebPath;
        if (jTextField != null) {
            jTextField.setText($newValue);
        }
        JTextField jTextField2 = this$0.tomcatWebPath;
        if (jTextField2 != null) {
            jTextField2.setToolTipText($newValue);
        }
        RecentPathVO instance = RecentPathVO.Companion.getInstance($newValue, System.currentTimeMillis());
        this$0.recentPathComboBoxModel.removeElement((Object)instance);
        this$0.recentPathComboBoxModel.insertElementAt((Object)instance, 0);
    }

    private static final void initListener$lambda$6(FastExportUI this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor != null) {
            fileChooserDescriptor.setTitle("\u8bf7\u9009\u62e9Tomcat\u7684webapps\u4e2d\u7684\u76ee\u5f55");
        }
        RecentPathVO recentPathVO = this$0.prevPath;
        String path = recentPathVO != null ? recentPathVO.getPath() : null;
        CharSequence charSequence = path;
        VirtualFile toSelect = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : LocalFileSystem.getInstance().findFileByPath(path);
        FileChooserDescriptor fileChooserDescriptor2 = descriptor;
        Intrinsics.checkNotNull((Object)fileChooserDescriptor2);
        VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor2, null, (VirtualFile)toSelect);
        if (virtualFile != null && virtualFile.exists()) {
            String newValue = virtualFile.getCanonicalPath();
            LOG.info("\u6d4f\u89c8\u7684\u5bfc\u51fa\u6839\u8def\u5f84\u7684\u8def\u5f84\uff1a" + newValue);
            ApplicationManager.getApplication().invokeLater(() -> FastExportUI.initListener$lambda$6$lambda$5(this$0, newValue));
        }
    }

    private static final void initListener$lambda$8$lambda$7(FastExportUI this$0, String $newValue) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JTextField jTextField = this$0.tomcatWebPath;
        if (jTextField != null) {
            jTextField.setText($newValue);
        }
        JTextField jTextField2 = this$0.tomcatWebPath;
        if (jTextField2 != null) {
            jTextField2.setToolTipText($newValue);
        }
    }

    private static final void initListener$lambda$8(FastExportUI this$0, ItemEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (1 == e.getStateChange()) {
            Object object = e.getItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.xf.export.vo.RecentPathVO");
            String newValue = ((RecentPathVO)object).getPath();
            LOG.info("combo\u9009\u4e2d\u7684\u8def\u5f84\uff1a" + newValue);
            ApplicationManager.getApplication().invokeLater(() -> FastExportUI.initListener$lambda$8$lambda$7(this$0, newValue));
        }
    }

    private static final void initListener$lambda$9(FastExportUI this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor != null) {
            fileChooserDescriptor.setTitle("\u8bf7\u9009\u62e9Es6\u8f6cEs5\u7684\u6839\u76ee\u5f55");
        }
        String string = this$0.config.getEs6ToEs5().getRootPath();
        Intrinsics.checkNotNull((Object)string);
        JTextField jTextField = this$0.es6Toes5RootPathText;
        Intrinsics.checkNotNull((Object)jTextField);
        this$0.fileChoose(string, jTextField);
    }

    private static final void initListener$lambda$10(FastExportUI this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor != null) {
            fileChooserDescriptor.setTitle("\u8bf7\u9009\u62e9Es6\u8f6cEs5\u6587\u4ef6\u8f6c\u6362\u7684\u6839\u76ee\u5f55");
        }
        String string = this$0.config.getEs6ToEs5().getFileRootPath();
        Intrinsics.checkNotNull((Object)string);
        JTextField jTextField = this$0.es6Toes5SrcFileRootPathText;
        Intrinsics.checkNotNull((Object)jTextField);
        this$0.fileChoose(string, jTextField);
    }

    private static final void fileChoose$lambda$11(JTextField $textField, VirtualFile $virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$textField, (String)"$textField");
        $textField.setText($virtualFile.getPath());
    }

    private static final long onOK$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final void onOK$lambda$14$lambda$13(FastExportUI this$0, Map $module2Files, Module[] $modules, boolean aborted, int errors, int warnings, CompileContext compileContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$module2Files, (String)"$module2Files");
        Intrinsics.checkNotNullParameter((Object)$modules, (String)"$modules");
        Intrinsics.checkNotNullParameter((Object)compileContext, (String)"compileContext");
        if (aborted) {
            NotificationHelper.INSTANCE.showError(this$0.project, "\u4ee3\u7801\u7f16\u8bd1\u88ab\u7ec8\u6b62\uff01");
            return;
        }
        if (errors != 0) {
            NotificationHelper.INSTANCE.showError(this$0.project, "\u4ee3\u7801\u7f16\u8bd1\u65f6\u53d1\u751f\u9519\u8bef\uff01");
            return;
        }
        try {
            LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c" + warnings + "\u4e2a\u8b66\u544a\uff0c\u51c6\u5907\u5bfc\u51fa.......");
            this$0.runExport($module2Files, $modules, compileContext);
            this$0.sshSCP();
            LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5bfc\u51fa\u5b8c\u6210\uff01");
        }
        catch (Exception e) {
            NotificationHelper.INSTANCE.showError(this$0.project, "\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25\uff01<br>" + e.getMessage());
            LOG.error("", (Throwable)e);
        }
    }

    private static final void onOK$lambda$14(boolean $hasJava, CompilerManager $compilerManager, FastExportUI this$0, Module[] $modules, Map $module2Files) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$modules, (String)"$modules");
        Intrinsics.checkNotNullParameter((Object)$module2Files, (String)"$module2Files");
        if ($hasJava) {
            $compilerManager.make(this$0.project, $modules, (arg_0, arg_1, arg_2, arg_3) -> FastExportUI.onOK$lambda$14$lambda$13(this$0, $module2Files, $modules, arg_0, arg_1, arg_2, arg_3));
        } else {
            try {
                LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u51c6\u5907\u5bfc\u51fa.......");
                this$0.runExport4WithoutJava($module2Files);
                this$0.sshSCP();
                LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\uff0c\u5bfc\u51fa\u5b8c\u6210\uff01");
            }
            catch (Exception e) {
                NotificationHelper.INSTANCE.showError(this$0.project, "\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25\uff01<br>" + e.getMessage());
                LOG.error("\u5bfc\u51faclass\u5230web\u5bb9\u5668\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static final boolean runExport$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final long copyFileAndShowMessage$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final Boolean runEs6ToEs5$lambda$18(Map $es6ToEs5DestFileMapSourceFile, FastExportUI this$0) {
        Intrinsics.checkNotNullParameter((Object)$es6ToEs5DestFileMapSourceFile, (String)"$es6ToEs5DestFileMapSourceFile");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LOG.info("ES6\u8f6cES5\u5f00\u5173\u5df2\u5f00\u542f\uff01\u9700\u8981\u8fdb\u884c\u8f6c\u6362\u64cd\u4f5c......");
        if (!$es6ToEs5DestFileMapSourceFile.isEmpty()) {
            String execDir;
            Map $this$forEach$iv = $es6ToEs5DestFileMapSourceFile;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Path dest = (Path)entry.getKey();
                Path src = (Path)entry.getValue();
                try {
                    FastExportUI.Companion.copyFile(dest, src);
                }
                catch (IOException e) {
                    LOG.error("\u6587\u4ef6\u590d\u5236\u51fa\u9519", (Throwable)e);
                }
            }
            String string = execDir = this$0.config.getEs6ToEs5().getRootPath();
            Intrinsics.checkNotNull((Object)string);
            boolean cmdResult = this$0.execCmdGulp(string, "gulp");
            if (!cmdResult) {
                NotificationHelper.INSTANCE.showError(this$0.event.getProject(), "ES6\u8f6cES5\u8f6c\u6362\u5931\u8d25");
                return false;
            }
        }
        LOG.info("ES6\u8f6cES5\u5f00\u5173\u5df2\u5f00\u542f\uff01\u8f6c\u6362\u64cd\u4f5c\u5b8c\u6210\uff01");
        return true;
    }

    private static final String sshSCP$lambda$22$lambda$21$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final void sshSCP$lambda$22(FastExportUI this$0) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            v0 = this$0.sshExportYesBtn;
            FastExportUI.LOG.info("\u662f\u5426\u5f00\u542fscp\u4f20\u8f93\uff1a" + (v0 != null ? Boolean.valueOf(v0.isSelected()) : null));
            v1 = this$0.sshExportYesBtn;
            Intrinsics.checkNotNull((Object)v1);
            if (!v1.isSelected()) break block13;
            FastExportUI.LOG.info("\u521b\u5efa SSH\u5ba2\u6237\u7aef");
            try {
                var1_1 = (Closeable)SshClient.setUpDefaultClient();
                var2_3 = null;
                try {
                    sshClient = (SshClient)var1_1;
                    $i$a$-use-FastExportUI$sshSCP$1$1 = false;
                    FastExportUI.LOG.info("\u542f\u52a8 SSH\u5ba2\u6237\u7aef");
                    sshClient.start();
                    FastExportUI.LOG.info("\u901a\u8fc7\u4e3b\u673aIP\u3001\u7aef\u53e3\u548c\u7528\u6237\u540d\uff0c\u8fde\u63a5\u4e3b\u673a\uff0c\u83b7\u53d6Session");
                    v2 = this$0.sshUserText;
                    v3 = v2 != null ? v2.getText() : null;
                    v4 = this$0.sshHostText;
                    v5 = v4 != null ? v4.getText() : null;
                    v6 = this$0.sshPortText;
                    if (v6 == null || (v6 = (var5_8 = v6.getText())) == null) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)v6);
                    v6 = StringsKt.trim((CharSequence)var5_8).toString();
                    if (v6 != null) {
                        v7 = Integer.parseInt((String)v6);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = null;
                    }
                    Intrinsics.checkNotNull(v7);
                    clientSession = ((ConnectFuture)sshClient.connect(v3, v5, v7.intValue()).verify(new CancelOption[0])).getClientSession();
                    FastExportUI.LOG.info("\u7ed9Session\u6dfb\u52a0\u5bc6\u7801");
                    v8 = this$0.sshPasswordText;
                    clientSession.addPasswordIdentity(String.valueOf((Object)((char[])(v8 != null ? v8.getPassword() : null))));
                    FastExportUI.LOG.info("\u6821\u9a8c\u7528\u6237\u540d\u548c\u5bc6\u7801\u7684\u6709\u6548\u6027");
                    isSuccess = ((AuthFuture)clientSession.auth().verify(new CancelOption[0])).isSuccess();
                    if (isSuccess) {
                        FastExportUI.LOG.info("\u6821\u9a8c\u6709\u6548\u6027\u901a\u8fc7\uff01\u521b\u5efascp\u901a\u9053");
                        creator = ScpClientCreator.instance();
                        FastExportUI.LOG.info("\u521b\u5efascp\u5ba2\u6237\u7aef......");
                        scpClient = creator.createScpClient(clientSession);
                        var9_12 = new String[]{"ssh_temp_path"};
                        local = Paths.get(Constants.INSTANCE.getDESKTOP_PATH(), var9_12);
                        v9 = this$0.sshPathText;
                        remote = v9 != null ? v9.getText() : null;
                        FastExportUI.LOG.info("Scp \u5f00\u59cb\u4e0a\u4f20. local=" + local + ",remote=" + remote);
                        v10 = UtilKt.stream((Object[])local.toFile().listFiles()).map((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, sshSCP$lambda$22$lambda$21$lambda$19(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)((Function1)sshSCP.1.1.localChildArray.1.INSTANCE)).collect(Collectors.toSet());
                        Intrinsics.checkNotNullExpressionValue(v10, (String)"collect(...)");
                        $this$toTypedArray$iv = (ScpClient.Option[])v10;
                        $i$f$toTypedArray = false;
                        thisCollection$iv = $this$toTypedArray$iv;
                        v11 = thisCollection$iv.toArray(new String[0]);
                        if (v11 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        localChildArray = v11;
                        $this$toTypedArray$iv = new ScpClient.Option[]{ScpClient.Option.Recursive};
                        scpClient.upload(localChildArray, remote, $this$toTypedArray$iv);
                        FastExportUI.LOG.info("Scp \u4e0a\u4f20\u5b8c\u6210.");
                        if (clientSession.isOpen()) {
                            clientSession.close();
                        }
                        if (sshClient.isOpen()) {
                            sshClient.stop();
                            sshClient.close();
                        }
                        $this$sshSCP_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420 = var12_16 = new StringBuilder();
                        $i$a$-buildString-FastExportUI$sshSCP$1$1$content$1 = false;
                        $this$sshSCP_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.append("\u4e0a\u4f20\u5730\u5740\uff1ahost=");
                        v12 = this$0.sshHostText;
                        $this$sshSCP_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.append(v12 != null ? v12.getText() : null);
                        $this$sshSCP_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.append(",port=");
                        v13 = this$0.sshPortText;
                        $this$sshSCP_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.append(v13 != null ? v13.getText() : null);
                        $this$sshSCP_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.append(",user=");
                        v14 = this$0.sshUserText;
                        $this$sshSCP_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.append(v14 != null ? v14.getText() : null);
                        $this$sshSCP_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.append("\nlocal=" + local);
                        $this$sshSCP_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.append("\nremote=" + remote);
                        $this$sshSCP_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.append("\n\u5b8c\u6210\uff01");
                        v15 = var12_16.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"StringBuilder().apply(builderAction).toString()");
                        content = v15;
                        NotificationHelper.INSTANCE.showInfo(this$0.project, "\u4e0a\u4f20SSH\u63d0\u793a", content);
                    }
                    var3_4 = Unit.INSTANCE;
                }
                catch (Throwable var3_5) {
                    var2_3 = var3_5;
                    throw var3_5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var1_1, (Throwable)var2_3);
                }
            }
            catch (Exception e) {
                FastExportUI.LOG.error("scp\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static final boolean findAllClasses$lambda$23(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean runExport4WithoutJava$lambda$25(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean containWeb$lambda$26(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean checkSourcePathValid$lambda$27(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean checkWebPathValid$lambda$28(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean saveHistoryPathList$lambda$29(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final long saveHistoryPathList$lambda$30(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    public static final /* synthetic */ void access$onCancel(FastExportUI $this) {
        $this.onCancel();
    }

    public static final /* synthetic */ JTextField access$getTomcatWebPath$p(FastExportUI $this) {
        return $this.tomcatWebPath;
    }

    public static final /* synthetic */ MutableCollectionComboBoxModel access$getRecentPathComboBoxModel$p(FastExportUI $this) {
        return $this.recentPathComboBoxModel;
    }

    public static final /* synthetic */ boolean access$checkSourcePathValid(FastExportUI $this, Map moduleMapSourcePaths, Module module, String path) {
        return $this.checkSourcePathValid(moduleMapSourcePaths, module, path);
    }

    public static final /* synthetic */ boolean access$checkWebPathValid(FastExportUI $this, Map moduleMapSourcePaths, Module module, String path) {
        return $this.checkWebPathValid(moduleMapSourcePaths, module, path);
    }

    static {
        Logger logger = Logger.getInstance(FastExportUI.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        FileChooserDescriptor fileChooserDescriptor = descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        Intrinsics.checkNotNull((Object)fileChooserDescriptor);
        fileChooserDescriptor.setShowFileSystemRoots(true);
        FileChooserDescriptor fileChooserDescriptor2 = descriptor;
        Intrinsics.checkNotNull((Object)fileChooserDescriptor2);
        fileChooserDescriptor2.setHideIgnored(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextField jTextField;
        JButton jButton2;
        JTextField jTextField2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField3;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JTextField jTextField4;
        JTextField jTextField5;
        JPasswordField jPasswordField;
        JTextField jTextField6;
        JTextField jTextField7;
        JButton jButton3;
        JTextField jTextField8;
        JButton jButton4;
        JButton jButton5;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel.setMaximumSize(new Dimension(-1, -1));
        jPanel.setMinimumSize(new Dimension(-1, -1));
        jPanel.setPreferredSize(new Dimension(-1, -1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        this.buttonExport = jButton5 = new JButton();
        jButton5.setText("\u5bfc\u51fa");
        jPanel3.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.buttonCancel = jButton4 = new JButton();
        jButton4.setText("\u53d6\u6d88");
        jPanel3.add((Component)jButton4, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(10, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.historyCombo = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 3, 8, 1, 7, 0, null, null, null));
        this.tomcatWebPath = jTextField8 = new JTextField();
        jTextField8.setAutoscrolls(true);
        jTextField8.setText("");
        jTextField8.setToolTipText("\u9700\u8981\u586b\u5199\u7684\u76ee\u5f55\u4f8b\u5982\uff1a..\\ApacheJetspeed\\webapps\\seeyon");
        jPanel4.add((Component)jTextField8, new GridConstraints(0, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("\u5386\u53f2\u8bb0\u5f55\uff1a");
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 4, 0, 7, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("\u5bfc\u51fa\u6839\u8def\u5f84\uff1a");
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 7, 0, null, null, null));
        this.chooseTomcatWebPath = jButton3 = new JButton();
        jButton3.setText("\u6d4f\u89c8");
        jPanel4.add((Component)jButton3, new GridConstraints(0, 4, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("SSH\u5bfc\u51fa\u8def\u5f84\uff1a");
        jPanel4.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 4, 0, 7, 0, null, null, null));
        this.sshPathText = jTextField7 = new JTextField();
        jPanel4.add((Component)jTextField7, new GridConstraints(4, 1, 1, 3, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("SSH \u8d26\u53f7\uff1a");
        jPanel4.add((Component)jLabel4, new GridConstraints(6, 0, 1, 1, 4, 0, 7, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("SSH \u5bc6\u7801\uff1a");
        jPanel4.add((Component)jLabel5, new GridConstraints(6, 2, 1, 1, 4, 0, 7, 0, null, null, null));
        this.sshUserText = jTextField6 = new JTextField();
        jPanel4.add((Component)jTextField6, new GridConstraints(6, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.sshPasswordText = jPasswordField = new JPasswordField();
        jPanel4.add((Component)jPasswordField, new GridConstraints(6, 3, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("SSH HOST\uff1a");
        jPanel4.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 4, 0, 7, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("SSH \u7aef\u53e3\uff1a");
        jPanel4.add((Component)jLabel7, new GridConstraints(5, 2, 1, 1, 4, 0, 7, 0, null, null, null));
        this.sshPortText = jTextField5 = new JTextField();
        jPanel4.add((Component)jTextField5, new GridConstraints(5, 3, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.sshHostText = jTextField4 = new JTextField();
        jPanel4.add((Component)jTextField4, new GridConstraints(5, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("\u662f\u5426\u5f00\u542fSSH\u5bfc\u51fa\uff1a");
        jPanel4.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.sshExportYesBtn = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("\u662f");
        jPanel4.add((Component)jRadioButton4, new GridConstraints(2, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.sshExportNoBtn = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        jRadioButton3.setText("\u5426");
        jPanel4.add((Component)jRadioButton3, new GridConstraints(2, 2, 1, 1, 8, 0, 7, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("SSH \u53ef\u6267\u884cbash\u7a0b\u5e8f\u8def\u5f84\uff1a");
        jPanel4.add((Component)jLabel9, new GridConstraints(3, 0, 1, 1, 4, 0, 7, 0, null, null, null));
        this.sshBashPath = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(3, 1, 1, 3, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("\u662f\u5426\u5f00\u542fJavaScript ES6\u8f6cES5\uff1a");
        jPanel4.add((Component)jLabel10, new GridConstraints(7, 0, 1, 1, 4, 0, 7, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("ES6\u8f6cES5\u529f\u80fd\u6839\u76ee\u5f55\uff1a");
        jPanel4.add((Component)jLabel11, new GridConstraints(8, 0, 1, 1, 4, 0, 7, 0, null, null, null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("ES6\u8f6cES5\u529f\u80fd\u6587\u4ef6\u8f6c\u6362\u6839\u76ee\u5f55\uff1a");
        jPanel4.add((Component)jLabel12, new GridConstraints(9, 0, 1, 1, 4, 0, 7, 0, null, null, null));
        this.es6Toes5RadioYesBtn = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("\u662f");
        jPanel4.add((Component)jRadioButton2, new GridConstraints(7, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.es6Toes5RadioNoBtn = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        jRadioButton.setText("\u5426");
        jPanel4.add((Component)jRadioButton, new GridConstraints(7, 2, 1, 1, 8, 0, 7, 0, null, null, null));
        this.es6Toes5RootPathText = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(8, 1, 1, 3, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.es6Toes5RootPathChooseBtn = jButton2 = new JButton();
        jButton2.setText("\u6d4f\u89c8");
        jPanel4.add((Component)jButton2, new GridConstraints(8, 4, 1, 1, 0, 1, 7, 0, null, null, null));
        this.es6Toes5SrcFileRootPathText = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(9, 1, 1, 3, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.es6Toes5SrcFileRootPathChooseBtn = jButton = new JButton();
        jButton.setText("\u6d4f\u89c8");
        jPanel4.add((Component)jButton, new GridConstraints(9, 4, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J(\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0019H\u0002R\u001f\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/xf/export/ui/FastExportUI$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "setLOG", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "descriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "getDescriptor", "()Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "setDescriptor", "(Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;)V", "copyFile", "", "dest", "Ljava/nio/file/Path;", "src", "runAsyncForCopyFile", "Lkotlin/Pair;", "", "destFileMapSourceFile", "", "Idea-Export-Web2-Jdk17"})
    @SourceDebugExtension(value={"SMAP\nFastExportUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastExportUI.kt\ncom/xf/export/ui/FastExportUI$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,873:1\n211#2,2:874\n37#3:876\n36#3,3:877\n*S KotlinDebug\n*F\n+ 1 FastExportUI.kt\ncom/xf/export/ui/FastExportUI$Companion\n*L\n856#1:874,2\n868#1:876\n868#1:877,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public final void setLOG(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
            LOG = logger;
        }

        @Nullable
        public final FileChooserDescriptor getDescriptor() {
            return descriptor;
        }

        public final void setDescriptor(@Nullable FileChooserDescriptor fileChooserDescriptor) {
            descriptor = fileChooserDescriptor;
        }

        private final void copyFile(Path dest, Path src) throws IOException {
            if (Files.notExists(dest.getParent(), new LinkOption[0])) {
                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            }
            Files.deleteIfExists(dest);
            Files.createFile(dest, new FileAttribute[0]);
            this.getLOG().info("\u590d\u5236\u6587\u4ef6\uff0c" + src + ", \u5230\uff1a" + dest);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(src, dest, copyOptionArray);
            this.getLOG().info("\u590d\u5236\u6587\u4ef6\uff0c" + src + ", \u5230\uff1a" + dest + "\u6210\u529f\uff01");
        }

        private final Pair<Integer, Integer> runAsyncForCopyFile(Map<Path, Path> destFileMapSourceFile) {
            List all = new ArrayList();
            AtomicInteger total = new AtomicInteger();
            AtomicInteger failedTotal = new AtomicInteger();
            Map<Path, Path> $this$forEach$iv = destFileMapSourceFile;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Path, Path>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Path, Path> element$iv;
                Map.Entry<Path, Path> entry = element$iv = iterator.next();
                boolean bl = false;
                Path dest = entry.getKey();
                Path src = entry.getValue();
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> Companion.runAsyncForCopyFile$lambda$1$lambda$0(dest, src, total, failedTotal));
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
                all.add(completableFuture);
            }
            Collection $this$toTypedArray$iv = all;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
            if (completableFutureArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            CompletableFuture[] completableFutureArray2 = completableFutureArray;
            CompletableFuture.allOf(Arrays.copyOf(completableFutureArray2, completableFutureArray2.length)).join();
            return new Pair((Object)total.get(), (Object)failedTotal.get());
        }

        private static final void runAsyncForCopyFile$lambda$1$lambda$0(Path $dest, Path $src, AtomicInteger $total, AtomicInteger $failedTotal) {
            Intrinsics.checkNotNullParameter((Object)$dest, (String)"$dest");
            Intrinsics.checkNotNullParameter((Object)$src, (String)"$src");
            Intrinsics.checkNotNullParameter((Object)$total, (String)"$total");
            Intrinsics.checkNotNullParameter((Object)$failedTotal, (String)"$failedTotal");
            try {
                Companion.copyFile($dest, $src);
                $total.getAndIncrement();
            }
            catch (Exception e) {
                $failedTotal.getAndIncrement();
                Companion.getLOG().error("", (Throwable)e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

