/*
 * Decompiled with CFR 0.152.
 */
package com.xf.util.export.ui;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.xf.util.export.config.Config;
import com.xf.util.export.helper.Constants;
import com.xf.util.export.helper.NotificationHelper;
import com.xf.util.export.ui.DoExportService;
import com.xf.util.export.vo.OaVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class ExportUI
extends JDialog {
    private static final Logger LOG = Logger.getInstance(ExportUI.class);
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton btnChoose;
    private JBTextField rootPathTextField;
    private JBCheckBox sourceNeedExportCheckBox;
    private JBTextField sourceDirPrefixTextField;
    private JBCheckBox patchNeedExportCheckBox;
    private JBTextField patchDirPrefixTextField;
    private JBCheckBox webappsNeedExportCheckBox;
    private JBTextField webappsContextTextField;
    private JBTextArea patchMappingJarNameTextArea;
    private JBTextArea rootBugDescTextArea;
    private JBTextField patchReadmeFileNameTextField;
    private JBTextField rootBugNoTextField;
    private JBTextField rootFileNameSplitTextField;
    private JBTextField rootFileNameSuffixTextField;
    private JBTextField rootFileNamePrefixTextField;
    private JBTextField patchWebappsContextTextField;
    private JComboBox<OaVersion> rootOaVersionComboBox;
    private JBTextField patchJarSplitTextField;
    private JBCheckBox needUseRelativePathForSourceCheckBox;
    private JBCheckBox needUseRelativePathForPatchCheckBox;
    private JPanel globalPanel;
    private JPanel srcPanel;
    private JPanel webappsPanel;
    private JPanel pakPanel;
    private final AnActionEvent event;
    private final Project project;
    private final List<Module> moduleList;
    private final VirtualFile[] selectedFiles;
    private final Config config;
    private final DoExportService doExportService;
    private final FileChooserDescriptor descriptor;

    public ExportUI(AnActionEvent event, VirtualFile[] selectedFiles, Config config) {
        this.$$$setupUI$$$();
        this.moduleList = new ArrayList<Module>();
        this.descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.config = config;
        this.event = event;
        this.selectedFiles = selectedFiles;
        this.project = event.getProject();
        this.doExportService = new DoExportService(event, this.project, selectedFiles, config);
        this.moduleList.addAll(Arrays.asList(ModuleManager.getInstance((Project)Objects.requireNonNull(this.project)).getModules()));
        this.initComponentData();
        this.initBtnEvent();
        this.initUIShowData();
    }

    private void initComponentData() {
        DefaultComboBoxModel aModel = new DefaultComboBoxModel();
        this.rootOaVersionComboBox.setModel(aModel);
    }

    private void initUIShowData() {
        this.descriptor.setShowFileSystemRoots(true);
        this.descriptor.setHideIgnored(true);
        this.descriptor.setTitle("\u5bfc\u51fa\u6839\u76ee\u5f55");
        ApplicationManager.getApplication().invokeLater(() -> {
            this.rootPathTextField.setText(this.config.getRoot().getOutRootPath());
            this.rootFileNamePrefixTextField.setText(this.config.getRoot().getPrefixName());
            this.rootFileNameSplitTextField.setText(this.config.getRoot().getNameSeparator());
            this.rootFileNameSuffixTextField.setText(ExportUI.getString(this.config.getRoot().getSuffixName(), DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd")));
            this.rootBugNoTextField.setText(this.config.getRoot().getBugNo());
            for (OaVersion version : this.config.getRoot().getOaVersions()) {
                ((DefaultComboBoxModel)this.rootOaVersionComboBox.getModel()).addElement(version);
            }
            this.config.getRoot().getOaVersions().stream().filter(OaVersion::isSelected).findFirst().ifPresent(oaVersion -> {
                this.rootOaVersionComboBox.setSelectedItem(oaVersion);
                this.config.getRoot().setCurrentVersion((OaVersion)oaVersion);
            });
            this.rootBugDescTextArea.setText(this.config.getRoot().getBugDesc());
            this.sourceDirPrefixTextField.setText(this.config.getSource().getPrefixDirName());
            this.sourceNeedExportCheckBox.setSelected(this.config.getSource().getNeedExport().booleanValue());
            this.needUseRelativePathForSourceCheckBox.setSelected(this.config.getSource().getNeedExportRelativePath().booleanValue());
            this.patchNeedExportCheckBox.setSelected(this.config.getPatch().getNeedExport().booleanValue());
            this.needUseRelativePathForPatchCheckBox.setSelected(this.config.getPatch().getNeedExportRelativePath().booleanValue());
            this.patchWebappsContextTextField.setText(this.config.getPatch().getWebappsName());
            this.patchDirPrefixTextField.setText(this.config.getPatch().getPrefixDirName());
            this.patchReadmeFileNameTextField.setText(this.config.getPatch().getReadmeFileName());
            StringBuilder join = new StringBuilder();
            Set moduleNames = this.moduleList.stream().map(Module::getName).collect(Collectors.toCollection(LinkedHashSet::new));
            for (String moduleName2 : moduleNames) {
                if (this.config.getPatch().getJarNameMapping().containsKey(moduleName2)) continue;
                this.config.getPatch().getJarNameMapping().put(moduleName2, this.config.getPatch().getWebappsName() + this.config.getPatch().getJarNameSplit() + moduleName2);
            }
            this.config.getPatch().getJarNameMapping().forEach((moduleName, jarName) -> {
                if (moduleNames.contains(moduleName)) {
                    if (join.length() > 0) {
                        join.append("\n");
                    }
                    join.append((String)moduleName).append(":").append((String)jarName);
                }
            });
            this.patchMappingJarNameTextArea.setText(join.toString());
            this.patchJarSplitTextField.setText(this.config.getPatch().getJarNameSplit());
            this.webappsNeedExportCheckBox.setSelected(this.config.getWebapps().getNeedExport().booleanValue());
            this.webappsContextTextField.setText(this.config.getWebapps().getWebappsName());
        });
        this.btnChoose.addActionListener(e -> {
            VirtualFile toSelect = StrUtil.isBlank((CharSequence)this.config.getRoot().getOutRootPath()) ? null : LocalFileSystem.getInstance().findFileByPath(this.config.getRoot().getOutRootPath());
            VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)this.descriptor, null, (VirtualFile)toSelect);
            if (virtualFile != null && virtualFile.exists()) {
                this.rootPathTextField.setText(virtualFile.getCanonicalPath());
            }
        });
    }

    private void saveCurrentConfig() {
        Config defaultConfig = Config.getDefaultConfig();
        this.config.setPluginVersion(Constants.PLUGIN_VERSION);
        this.config.getRoot().setOutRootPath(ExportUI.getString(this.rootPathTextField.getText(), new String[0]));
        this.config.getRoot().setPrefixName(ExportUI.getString(this.rootFileNamePrefixTextField.getText(), defaultConfig.getRoot().getPrefixName()));
        this.config.getRoot().setNameSeparator(ExportUI.getString(this.rootFileNameSplitTextField.getText(), defaultConfig.getRoot().getNameSeparator()));
        this.config.getRoot().setSuffixName(ExportUI.getString(this.rootFileNameSuffixTextField.getText(), defaultConfig.getRoot().getSuffixName()));
        this.config.getRoot().setBugNo(ExportUI.getString(this.rootBugNoTextField.getText(), defaultConfig.getRoot().getBugNo()));
        this.config.getRoot().setBugDesc(ExportUI.getString(this.rootBugDescTextArea.getText(), defaultConfig.getRoot().getBugDesc()));
        OaVersion currentVersion = (OaVersion)this.rootOaVersionComboBox.getSelectedItem();
        if (currentVersion != null) {
            this.config.getRoot().getOaVersions().forEach(item -> {
                item.setSelected(StrUtil.equals((CharSequence)currentVersion.getName(), (CharSequence)item.getName()));
                if (item.isSelected()) {
                    this.config.getRoot().setCurrentVersion((OaVersion)item);
                }
            });
        }
        this.config.getSource().setNeedExport(this.sourceNeedExportCheckBox.isSelected());
        this.config.getSource().setNeedExportRelativePath(this.needUseRelativePathForSourceCheckBox.isSelected());
        this.config.getSource().setPrefixDirName(ExportUI.getString(this.sourceDirPrefixTextField.getText(), defaultConfig.getSource().getPrefixDirName()));
        this.config.getPatch().setNeedExport(this.patchNeedExportCheckBox.isSelected());
        this.config.getPatch().setNeedExportRelativePath(this.needUseRelativePathForPatchCheckBox.isSelected());
        this.config.getPatch().setPrefixDirName(ExportUI.getString(this.patchDirPrefixTextField.getText(), defaultConfig.getPatch().getPrefixDirName()));
        this.config.getPatch().setWebappsName(ExportUI.getString(this.patchWebappsContextTextField.getText(), defaultConfig.getPatch().getWebappsName()));
        this.config.getPatch().setReadmeFileName(ExportUI.getString(this.patchReadmeFileNameTextField.getText(), defaultConfig.getPatch().getReadmeFileName()));
        String jarMappingTextAreaText = this.patchMappingJarNameTextArea.getText();
        if (StrUtil.isNotBlank((CharSequence)jarMappingTextAreaText)) {
            String[] split;
            for (String keyVal : split = jarMappingTextAreaText.split("\n")) {
                if (!StrUtil.isNotBlank((CharSequence)keyVal) || !keyVal.contains(":")) continue;
                String[] keyValList = keyVal.split(":");
                String key = keyValList[0];
                String value = keyValList[1];
                if (!StrUtil.isNotBlank((CharSequence)key) || !StrUtil.isNotBlank((CharSequence)value)) continue;
                this.config.getPatch().getJarNameMapping().put(key, value);
            }
        }
        this.config.getPatch().setJarNameSplit(ExportUI.getString(this.patchJarSplitTextField.getText(), defaultConfig.getPatch().getJarNameSplit()));
        this.config.getWebapps().setNeedExport(this.webappsNeedExportCheckBox.isSelected());
        this.config.getWebapps().setWebappsName(ExportUI.getString(this.webappsContextTextField.getText(), defaultConfig.getWebapps().getWebappsName()));
        Config.updateConfig(this.config);
    }

    public static String getString(String value, String ... defaultValue) {
        String val = StrUtil.trim((CharSequence)value);
        if (StrUtil.isBlank((CharSequence)val)) {
            return defaultValue == null ? "" : defaultValue[0];
        }
        return val;
    }

    private void initBtnEvent() {
        this.buttonOK.addActionListener(e -> this.onOK());
        this.buttonCancel.addActionListener(e -> this.onCancel());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExportUI.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onOK() {
        String outPath = this.rootPathTextField.getText().trim();
        if (StrUtil.isBlank((CharSequence)outPath)) {
            NotificationHelper.showWarn(this.project, "\u8bf7\u5148\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6839\u8def\u5f84\uff01");
            return;
        }
        if (!(this.patchNeedExportCheckBox.isSelected() || this.sourceNeedExportCheckBox.isSelected() || this.webappsNeedExportCheckBox.isSelected())) {
            NotificationHelper.showError(this.project, "\u5fc5\u987b\u8981\u9009\u62e9\u4e00\u4e2a\u8981\u80fd\u5bfc\u51fa\u7684\u7c7b\u578b\uff01");
            return;
        }
        this.saveCurrentConfig();
        try {
            if (!this.doExportService.findAllNeedExportFiles()) {
                return;
            }
        }
        catch (MalformedURLException e) {
            LOG.error("findAllNeedExportFiles\u5f02\u5e38\uff1a", (Throwable)e);
            NotificationHelper.showError(this.project, "\u67e5\u627e\u6240\u6709\u7684\u539f\u6587\u4ef6\u5f02\u5e38\uff01");
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.sourceNeedExportCheckBox.isSelected()) {
                this.doExportService.runExport4Source();
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.patchNeedExportCheckBox.isSelected() || this.webappsNeedExportCheckBox.isSelected()) {
                this.doExportService.runExport4WithoutJava();
                this.doExportService.runExport4WithJava();
            }
        });
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JBTextArea jBTextArea;
        JBTextField jBTextField2;
        JBTextField jBTextField3;
        JBCheckBox jBCheckBox;
        JBTextField jBTextField4;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        JBTextField jBTextField5;
        JBCheckBox jBCheckBox3;
        JPanel jPanel2;
        JBCheckBox jBCheckBox4;
        JBTextField jBTextField6;
        JBCheckBox jBCheckBox5;
        JPanel jPanel3;
        JBTextArea jBTextArea2;
        JBTextField jBTextField7;
        JBTextField jBTextField8;
        JBTextField jBTextField9;
        JBTextField jBTextField10;
        JButton jButton;
        JBTextField jBTextField11;
        JPanel jPanel4;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel5;
        this.contentPane = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 10, 0, 10), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton3 = new JButton();
        jButton3.setText("\u5bfc\u51fa");
        jButton3.setMnemonic('\u5bfc');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton2 = new JButton();
        jButton2.setText("\u53d6\u6d88");
        jButton2.setMnemonic('\u53d6');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.globalPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(7, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel4, new GridConstraints(0, 0, 1, 3, 0, 3, 0, 0, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-8813692)), "\u5168\u5c40\u914d\u7f6e", 0, 0, this.$$$getFont$$$("Microsoft YaHei", -1, 20, jPanel4.getFont()), new Color(-8813692)));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("\u8f93\u51fa\u6839\u76ee\u5f55\uff1a");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.rootPathTextField = jBTextField11 = new JBTextField();
        jPanel4.add((Component)jBTextField11, new GridConstraints(0, 1, 1, 2, 0, 1, 7, 7, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.btnChoose = jButton = new JButton();
        jButton.setText("\u6d4f\u89c8");
        jButton.setMnemonic('\u6d4f');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 8, 0, 7, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("\u6587\u4ef6\u540d\u79f0\u524d\u7f00\uff1a");
        jPanel4.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.rootFileNamePrefixTextField = jBTextField10 = new JBTextField();
        jPanel4.add((Component)jBTextField10, new GridConstraints(1, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("\u6587\u4ef6\u540d\u79f0\u540e\u7f00\uff1a");
        jPanel4.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.rootFileNameSuffixTextField = jBTextField9 = new JBTextField();
        jPanel4.add((Component)jBTextField9, new GridConstraints(2, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("\u6587\u4ef6\u540d\u79f0\u5206\u5272\u7b26\uff1a");
        jPanel4.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.rootFileNameSplitTextField = jBTextField8 = new JBTextField();
        jPanel4.add((Component)jBTextField8, new GridConstraints(3, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("BUG\u7f16\u53f7\uff1a");
        jPanel4.add((Component)jBLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.rootBugNoTextField = jBTextField7 = new JBTextField();
        jPanel4.add((Component)jBTextField7, new GridConstraints(4, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("OA\u7248\u672c\uff1a");
        jPanel4.add((Component)jBLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.rootOaVersionComboBox = jComboBox;
        jPanel4.add(jComboBox, new GridConstraints(5, 1, 1, 2, 8, 1, 7, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("BUG\u95ee\u9898\u63cf\u8ff0\uff1a");
        jPanel4.add((Component)jBLabel7, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel4.add((Component)jScrollPane, new GridConstraints(6, 1, 1, 2, 0, 3, 7, 7, null, null, null));
        this.rootBugDescTextArea = jBTextArea2 = new JBTextArea();
        jBTextArea2.setLineWrap(true);
        jBTextArea2.setRows(3);
        jBTextArea2.setWrapStyleWord(true);
        jScrollPane.setViewportView((Component)jBTextArea2);
        this.srcPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel8.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-8813692)), "\u6e90\u7801\u5bfc\u51fa\u914d\u7f6e", 0, 0, this.$$$getFont$$$("Microsoft YaHei", -1, 20, jPanel3.getFont()), new Color(-8813692)));
        this.sourceNeedExportCheckBox = jBCheckBox5 = new JBCheckBox();
        jBCheckBox5.setText("\u662f\u5426\u9700\u8981\u5bfc\u51fa");
        jBCheckBox5.setMnemonic('\u662f');
        jBCheckBox5.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("\u6e90\u7801\u6587\u4ef6\u5939\u540d\u79f0\u524d\u7f00\uff1a");
        jPanel3.add((Component)jBLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.sourceDirPrefixTextField = jBTextField6 = new JBTextField();
        jPanel3.add((Component)jBTextField6, new GridConstraints(2, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        this.needUseRelativePathForSourceCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setSelected(true);
        jBCheckBox4.setText("\u662f\u5426\u6309\u7167\u76f8\u5bf9\u8def\u5f84\u5bfc\u51fa");
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 1, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel3.add((Component)spacer5, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 1, null, null, null));
        this.webappsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel8.add((Component)jPanel2, new GridConstraints(1, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-8813692)), "web\u5bb9\u5668\u5bfc\u51fa\u914d\u7f6e", 0, 0, this.$$$getFont$$$("Microsoft YaHei", -1, 20, jPanel2.getFont()), new Color(-8813692)));
        this.webappsNeedExportCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("\u662f\u5426\u9700\u8981\u5bfc\u51fa");
        jBCheckBox3.setMnemonic('\u662f');
        jBCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel2.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel2.add((Component)spacer7, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("webapps\u4e2d\u7684web\u4e0a\u4e0b\u6587\u540d\u79f0\uff1a");
        jPanel2.add((Component)jBLabel9, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.webappsContextTextField = jBTextField5 = new JBTextField();
        jPanel2.add((Component)jBTextField5, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.pakPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel8.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-8813692)), "\u8865\u4e01\u5305\u5bfc\u51fa\u914d\u7f6e", 0, 0, this.$$$getFont$$$("Microsoft YaHei", -1, 20, jPanel.getFont()), new Color(-8813692)));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setText("\u8865\u4e01\u5305\u6587\u4ef6\u5939\u540d\u79f0\u524d\u7f00\uff1a");
        jPanel.add((Component)jBLabel10, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel.add((Component)spacer8, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.patchNeedExportCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("\u662f\u5426\u9700\u8981\u5bfc\u51fa");
        jBCheckBox2.setMnemonic('\u662f');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.patchDirPrefixTextField = jBTextField4 = new JBTextField();
        jPanel.add((Component)jBTextField4, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.needUseRelativePathForPatchCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("\u662f\u5426\u6309\u7167\u76f8\u5bf9\u8def\u5f84\u5bfc\u51fa");
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel.add((Component)spacer9, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel.add((Component)spacer10, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setText("web\u4e0a\u4e0b\u6587\u540d\u79f0\uff1a");
        jPanel.add((Component)jBLabel11, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel12 = new JBLabel();
        jBLabel12.setText("\u8865\u4e01\u5305\u4fee\u590d\u8bf4\u660e\u6587\u4ef6\u540d\u79f0\uff1a");
        jPanel.add((Component)jBLabel12, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.patchWebappsContextTextField = jBTextField3 = new JBTextField();
        jPanel.add((Component)jBTextField3, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.patchReadmeFileNameTextField = jBTextField2 = new JBTextField();
        jPanel.add((Component)jBTextField2, new GridConstraints(4, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel13 = new JBLabel();
        jBLabel13.setText("\u6a21\u5757\u540d\u79f0\u6620\u5c04jar\u6587\u4ef6\u540d\u79f0\uff1a");
        jPanel.add((Component)jBLabel13, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel.add((Component)jScrollPane2, new GridConstraints(5, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.patchMappingJarNameTextArea = jBTextArea = new JBTextArea();
        jBTextArea.setLineWrap(false);
        jBTextArea.setRows(3);
        jBTextArea.setWrapStyleWord(false);
        jScrollPane2.setViewportView((Component)jBTextArea);
        JBLabel jBLabel14 = new JBLabel();
        jBLabel14.setText("jar\u540d\u79f0\u5206\u5272\u7b26\uff1a");
        jPanel.add((Component)jBLabel14, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.patchJarSplitTextField = jBTextField = new JBTextField();
        jPanel.add((Component)jBTextField, new GridConstraints(6, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        jBLabel6.setLabelFor(jComboBox);
        jBLabel13.setLabelFor(jScrollPane2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

