/*
 * Decompiled with CFR 0.152.
 */
package com.xf.util.export.ui;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.xf.util.export.config.Config;
import com.xf.util.export.helper.Constants;
import com.xf.util.export.helper.NotificationHelper;
import com.xf.util.export.vo.MyFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jetbrains.annotations.NotNull;

public class DoExportService {
    private static final Logger LOG = Logger.getInstance(DoExportService.class);
    private final AnActionEvent event;
    private final Project project;
    private final List<Module> moduleList = new ArrayList<Module>();
    private final VirtualFile[] selectedFiles;
    private final Config config;
    private final Map<Module, Set<VirtualFile>> moduleMapSourcePaths = new HashMap<Module, Set<VirtualFile>>();
    private final Map<Module, List<MyFile>> module2Files = new HashMap<Module, List<MyFile>>();
    private final List<MyFile> filesToCompile = new ArrayList<MyFile>();
    private final List<MyFile> filesToNoCompile = new ArrayList<MyFile>();
    private long exportFileTotal = 0L;

    public DoExportService(AnActionEvent event, Project project, VirtualFile[] selectedFiles, Config config) {
        this.event = event;
        this.project = project;
        this.selectedFiles = selectedFiles;
        this.config = config;
    }

    public void runExport4WithJava() {
        if (this.filesToCompile.isEmpty()) {
            return;
        }
        Collection filesToCompile = this.filesToCompile.stream().map(MyFile::getFile).collect(Collectors.toSet());
        Set moduleTemps = this.filesToCompile.stream().map(MyFile::getModule).collect(Collectors.toSet());
        Module[] affectedModulesToCompile = (Module[])ArrayUtil.toArray(moduleTemps, Module.class);
        FileSetCompileScope scope = new FileSetCompileScope(filesToCompile, affectedModulesToCompile);
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.project);
        compilerManager.make((CompileScope)scope, (aborted, errors, warnings, compileContext) -> {
            if (aborted) {
                NotificationHelper.showError(this.project, "\u4ee3\u7801\u7f16\u8bd1\u88ab\u7ec8\u6b62\uff01");
                return;
            }
            if (errors != 0) {
                NotificationHelper.showError(this.project, "\u4ee3\u7801\u7f16\u8bd1\u65f6\u53d1\u751f\u9519\u8bef\uff01");
                return;
            }
            try {
                LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u51c6\u5907\u5bfc\u51fa.......");
                this.runExport4CompileFile(compileContext);
                LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5bfc\u51fa\u5b8c\u6210\uff01");
            }
            catch (Exception e) {
                NotificationHelper.showError(this.project, "\u5bfc\u51fajava\u6587\u4ef6\u5931\u8d25\uff01<br>" + e.getMessage());
                LOG.error("\u5bfc\u51fajava\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            }
            NotificationHelper.showInfo(this.project, "java\u6587\u4ef6\u5bfc\u51fa\u6210\u529f", "\u6253\u5f00java\u6587\u4ef6\u5bfc\u51fa\u6839\u8def\u5f84", "file://" + this.config.getRoot().getOutRootPath());
        });
    }

    private void runExport4CompileFile(CompileContext compileContext) {
        boolean needExportWebapps = this.config.getWebapps().getNeedExport();
        boolean needExportClasses = this.config.getPatch().getNeedExport();
        if (!needExportWebapps && !needExportClasses) {
            return;
        }
        HashMap<Path, Path> destFileMapSourceFile = new HashMap<Path, Path>();
        String outRootPath = this.config.getRoot().getOutRootPath();
        String dirName = this.getDirName(this.config.getPatch().getPrefixDirName());
        Path finalOutRootPath = Paths.get(outRootPath, dirName);
        Path finalOutRootWebAppsPath = Paths.get(outRootPath, new String[0]);
        int compileCount = 0;
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (MyFile exportFile : this.filesToCompile) {
            PsiClass[] classes;
            Module module = exportFile.getModule();
            String moduleName = module.getName();
            String relativePath = exportFile.getRelativePath();
            Path packagePath = Paths.get(relativePath, new String[0]);
            VirtualFile compilerOutputPath = compileContext.getModuleOutputDirectory(module);
            Path classFilesPath = Paths.get(Objects.requireNonNull(compilerOutputPath).getPath(), packagePath.toString());
            String moduleDirName = this.config.getPatch().getJarNameMapping().get(moduleName);
            Path saveClassPath = Paths.get(finalOutRootPath.toString(), moduleDirName);
            Path saveWebAppsPath = this.getSaveWebAppsPath(finalOutRootWebAppsPath, module);
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(exportFile.getFile());
            PsiJavaFile javaFile = (PsiJavaFile)psiFile;
            for (PsiClass aClass : classes = javaFile.getClasses()) {
                HashMap<Path, Path> destFileMapSourceFile2;
                int num = 0;
                if (needExportClasses) {
                    destFileMapSourceFile2 = new HashMap<Path, Path>();
                    this.findAllClasses(aClass, destFileMapSourceFile2, classFilesPath, saveClassPath, this.config.getPatch().getNeedExportRelativePath(), packagePath, "");
                    num = destFileMapSourceFile2.size();
                    destFileMapSourceFile.putAll(destFileMapSourceFile2);
                }
                if (needExportWebapps) {
                    destFileMapSourceFile2 = new HashMap();
                    this.findAllClasses(aClass, destFileMapSourceFile2, classFilesPath, saveWebAppsPath, true, packagePath, "");
                    destFileMapSourceFile.putAll(destFileMapSourceFile2);
                    if (num == 0) {
                        num = destFileMapSourceFile2.size();
                    }
                }
                compileCount += num;
            }
        }
        LOG.info("\u7f16\u8bd1\u6210\u529f\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + destFileMapSourceFile.size() + "\u4e2a");
        Pair<Integer, Integer> result = DoExportService.runAsyncForCopyFile(destFileMapSourceFile);
        int total = (Integer)result.getKey();
        int failedTotal = (Integer)result.getValue();
        if (needExportClasses) {
            this.generatorPatchReadmeFile(finalOutRootPath.toString());
        }
        String content = "java\u6587\u4ef6\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + this.exportFileTotal + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u7684\u603b\u6570\u91cf\uff1a" + compileCount + "\u4e2a).<br>  (\u7f16\u8bd1\u540e\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u91cf\uff1a" + destFileMapSourceFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a). ";
        NotificationHelper.showInfo(this.project, content);
    }

    private Path getSaveWebAppsPath(Path finalOutRootWebAppsPath, Module module) {
        Path saveWebAppsPath;
        if (this.config.getRoot().getCurrentVersion().getVersion() >= 81100000000L) {
            String jarName = this.config.getPatch().getJarNameMapping().get(module.getName()) + ".jar";
            saveWebAppsPath = Paths.get(finalOutRootWebAppsPath.toString(), this.config.getWebapps().getWebappsName(), "WEB-INF", "lib", jarName);
        } else {
            saveWebAppsPath = Paths.get(finalOutRootWebAppsPath.toString(), this.config.getWebapps().getWebappsName(), "WEB-INF", "classes");
        }
        return saveWebAppsPath;
    }

    private void findAllClasses(PsiClass aClass, Map<Path, Path> destFileMapSourceFile, Path classFilesPath, Path saveClassPath, boolean needPackagePath, Path packagePath, String prefixName) {
        String fileName = (StrUtil.isBlank((CharSequence)prefixName) ? "" : prefixName + "$") + aClass.getName();
        Path src = Paths.get(classFilesPath.toString(), fileName + ".class");
        Path target = needPackagePath ? Paths.get(saveClassPath.toString(), packagePath.toString(), src.getFileName().toString()) : Paths.get(saveClassPath.toString(), src.getFileName().toString());
        destFileMapSourceFile.put(target, src);
        DirectoryStream.Filter<Path> pathFilter = path -> path.getFileName().toString().matches("^" + Pattern.quote(fileName + "$") + ".*\\.class$");
        try (DirectoryStream<Path> classPathsProxy = Files.newDirectoryStream(classFilesPath, pathFilter);){
            for (Path src2 : classPathsProxy) {
                Path target2 = needPackagePath ? Paths.get(saveClassPath.toString(), packagePath.toString(), src2.getFileName().toString()) : Paths.get(saveClassPath.toString(), src2.getFileName().toString());
                destFileMapSourceFile.put(target2, src2);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        for (PsiClass innerClass : aClass.getInnerClasses()) {
            this.findAllClasses(innerClass, destFileMapSourceFile, classFilesPath, saveClassPath, needPackagePath, packagePath, fileName);
        }
    }

    public void runExport4WithoutJava() {
        if (this.filesToNoCompile.isEmpty()) {
            return;
        }
        HashMap<Path, Path> destFileMapSourceFile = new HashMap<Path, Path>();
        String outRootPath = this.config.getRoot().getOutRootPath();
        String fileName = this.getDirName(this.config.getPatch().getPrefixDirName());
        Path finalPatchOutRootPath = Paths.get(outRootPath, fileName);
        Path finalWebappsOutRootPath = Paths.get(outRootPath, new String[0]);
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\u8865\u4e01\u5305\uff0c\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6.......");
        for (MyFile exportFile : this.filesToNoCompile) {
            Path target;
            Path src = Paths.get(exportFile.getFile().getPath(), new String[0]);
            Module module = exportFile.getModule();
            String moduleName = module.getName();
            String moduleDirName = this.config.getPatch().getJarNameMapping().get(moduleName);
            String relativePath = exportFile.getRelativePath();
            Path packagePath = Paths.get(relativePath, new String[0]);
            String fileNameAndSuffix = exportFile.getFile().getName();
            if (exportFile.isInSourceDir()) {
                target = this.config.getPatch().getNeedExportRelativePath() == false ? Paths.get(finalPatchOutRootPath.toString(), moduleDirName, fileNameAndSuffix) : Paths.get(finalPatchOutRootPath.toString(), moduleDirName, packagePath.toString(), fileNameAndSuffix);
                if (this.config.getPatch().getNeedExport().booleanValue()) {
                    destFileMapSourceFile.put(target, src);
                }
                Path saveWebAppsPath = this.getSaveWebAppsPath(finalWebappsOutRootPath, module);
                Path target2 = Paths.get(saveWebAppsPath.toString(), packagePath.toString(), fileNameAndSuffix);
                if (!this.config.getWebapps().getNeedExport().booleanValue()) continue;
                destFileMapSourceFile.put(target2, src);
                continue;
            }
            if (!exportFile.isInWebDir()) continue;
            target = this.config.getPatch().getNeedExportRelativePath() == false ? Paths.get(finalPatchOutRootPath.toString(), this.config.getPatch().getWebappsName(), fileNameAndSuffix) : Paths.get(finalPatchOutRootPath.toString(), this.config.getPatch().getWebappsName(), packagePath.toString(), fileNameAndSuffix);
            if (this.config.getPatch().getNeedExport().booleanValue()) {
                destFileMapSourceFile.put(target, src);
            }
            Path target2 = Paths.get(finalWebappsOutRootPath.toString(), this.config.getWebapps().getWebappsName(), packagePath.toString(), fileNameAndSuffix);
            if (!this.config.getWebapps().getNeedExport().booleanValue()) continue;
            destFileMapSourceFile.put(target2, src);
        }
        LOG.info("\u975ejava\u6587\u4ef6\u5bfc\u51fa\u8865\u4e01\u5305\uff0c\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff1a" + destFileMapSourceFile.size() + "\u4e2a");
        Pair<Integer, Integer> result = DoExportService.runAsyncForCopyFile(destFileMapSourceFile);
        int total = (Integer)result.getKey();
        int failedTotal = (Integer)result.getValue();
        this.generatorPatchReadmeFile(finalPatchOutRootPath.toString());
        String content = "\u975ejava\u6587\u4ef6\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + this.exportFileTotal + "\u4e2a).<br>  (\u975ejava\u6587\u4ef6\u5bfc\u51fa\u603b\u6570\u91cf\uff1a" + destFileMapSourceFile.size() + "\u4e2a\uff0c\u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a). ";
        NotificationHelper.showInfo(this.project, content);
    }

    private void generatorPatchReadmeFile(String outPath) {
        String webContextName = this.config.getPatch().getWebappsName();
        String bugFileName = this.config.getPatch().getReadmeFileName();
        String bugNum = this.config.getRoot().getBugNo();
        String oaVersion = this.config.getRoot().getCurrentVersion().getName();
        String bugDesc = this.config.getRoot().getBugDesc();
        File seeyon = new File(outPath);
        if (seeyon.exists()) {
            File[] files = seeyon.listFiles();
            ArrayList moduleNames = new ArrayList();
            Arrays.stream(Objects.requireNonNull(files)).forEach(file -> {
                if (file.isDirectory()) {
                    moduleNames.add(file.getName());
                }
            });
            File bugFixFile = new File(Paths.get(outPath, bugFileName, bugFileName.lastIndexOf(".") > -1 ? "" : ".txt").toString());
            try {
                bugFixFile.delete();
            }
            catch (Exception e) {
                LOG.error("\u751f\u6210\u8bf4\u660e\u6587\u4ef6\u65f6\uff0c\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            }
            try {
                bugFixFile.createNewFile();
            }
            catch (IOException e) {
                LOG.error("\u751f\u6210\u8bf4\u660e\u6587\u4ef6\u65f6\uff0c\u521b\u5efaBUG\u8bf4\u660e\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
            }
            if (bugFixFile.exists()) {
                try {
                    String content = "\u4e00\u3001BUG\u7f16\u53f7\uff1a\n    %s\n\n    \u5236\u4f5c\u65e5\u671f\uff1a%s\n\u4e8c\u3001\u4fee\u6539\u95ee\u9898\uff1a\n    %s\n\n\u4e09\u3001\u9002\u7528\u73af\u5883\uff1a\n\n    \u4f9d\u8d56\u7248\u672c: %s\n    \u6570\u636e\u5e93\uff1a\u6240\u6709\u6570\u636e\u5e93\n\n\u56db\u3001\u64cd\u4f5c\u6b65\u9aa4\uff1a\n\n    \u7b2c\u4e00\u6b65\uff1a\u505c\u6b62A8\u670d\u52a1\n    \u7b2c\u4e8c\u6b65\uff1a\u5907\u4efd\u6587\u4ef6\u3001\u6587\u4ef6\u5939\uff08\u6ce8\u610f\u662f\u5907\u4efd\uff0c\u4e0d\u662f\u5c06\u539f\u6587\u4ef6\u3001\u6587\u4ef6\u5939\u66f4\u540d\u6216\u5220\u9664\uff09 \u5907\u4efdApacheJetspeed\\webapps\\seeyon\u6587\u4ef6\u5939\n    \u7b2c\u4e09\u6b65\uff1a\u8986\u76d6\u6587\u4ef6\u3001\u6587\u4ef6\u5939\n        %s\n        \n    \u7b2c\u56db\u6b65\uff1a\u6e05\u7a7aA8\u7684\\ApacheJetspeed\\work\u76ee\u5f55\u4e0b\u6240\u6709\u5185\u5bb9\uff1b \n\n    \u7b2c\u4e94\u6b65\uff1a\u542f\u52a8A8\u670d\u52a1\uff1b\n\n    \u7b2c\u516d\u6b65: \u6e05\u9664\u5ba2\u6237\u7aef\u6d4f\u89c8\u5668\u7f13\u5b58\u548cie\u4e34\u65f6\u6587\u4ef6\n\n";
                    StringBuilder desc = new StringBuilder();
                    ArrayList<String> descList = new ArrayList<String>();
                    if (moduleNames.contains(webContextName)) {
                        descList.add("%s\u3001\u5c06\u8865\u4e01\u5305\u4e0b\u7684seeyon\u6587\u4ef6\u5939\u62f7\u8d1d\u5230\u670d\u52a1\u5668\u4e0b\u7684webapps\\seeyon \u6587\u4ef6\u5939\u7684\u76f8\u540c\u6587\u4ef6 \n");
                    }
                    moduleNames.forEach(fileName -> {
                        if (!fileName.equals(webContextName)) {
                            descList.add("%s\u3001\u627e\u5230\u5b89\u88c5\u76ee\u5f55\u7684ApacheJetspeed\u4e0b\u7684webapps\\seeyon\\WEB-INF\\lib \u6587\u4ef6\u5939\u4e0b\uff1a\u5c06" + fileName + ".jar\u7528\u89e3\u538b\u7f29\u5de5\u5177\u6253\u5f00\uff0c\u7136\u540e\u628a\u8865\u4e01\u5305\u4e0b " + fileName + " \u6587\u4ef6\u52a0\u4e0b\u7684com\u6587\u4ef6\u4e0b \u62d6\u5230\u91cc\u9762\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c\u3002\u7136\u540e\u5173\u95ed\u89e3\u538b\u7f29\u540e\u7684" + fileName + ".jar\n");
                        }
                    });
                    for (int i = 0; i < descList.size(); ++i) {
                        desc.append(i == 0 ? "" : "        ").append(String.format((String)descList.get(i), i + 1));
                    }
                    String date = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                    content = String.format(content, bugNum, date, bugDesc, oaVersion, desc);
                    FileUtil.writeString((String)content, (File)bugFixFile, (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    LOG.error("\u751f\u6210\u8bf4\u660e\u6587\u4ef6\u65f6\uff0c\u5199\u5165BUG\u8bf4\u660e\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
                }
            }
        }
    }

    private String getDirName(String prefixDirName) {
        StringBuilder dirName = new StringBuilder();
        dirName.append(FileNameUtil.cleanInvalid((String)prefixDirName));
        dirName.append(FileNameUtil.cleanInvalid((String)this.config.getRoot().getPrefixName()));
        dirName.append(FileNameUtil.cleanInvalid((String)this.config.getRoot().getNameSeparator()));
        dirName.append(FileNameUtil.cleanInvalid((String)this.config.getRoot().getCurrentVersion().getName()));
        dirName.append(FileNameUtil.cleanInvalid((String)this.config.getRoot().getNameSeparator()));
        dirName.append(FileNameUtil.cleanInvalid((String)StrUtil.maxLength((CharSequence)this.config.getRoot().getBugDesc().trim(), (int)60)));
        dirName.append(FileNameUtil.cleanInvalid((String)this.config.getRoot().getNameSeparator()));
        dirName.append(FileNameUtil.cleanInvalid((String)this.config.getRoot().getBugNo()));
        dirName.append(FileNameUtil.cleanInvalid((String)this.config.getRoot().getNameSeparator()));
        dirName.append(FileNameUtil.cleanInvalid((String)this.config.getRoot().getSuffixName()));
        return dirName.toString();
    }

    public void runExport4Source() {
        HashMap<Path, Path> destFileMapSourceFile = new HashMap<Path, Path>();
        String dirName = this.getDirName(this.config.getSource().getPrefixDirName());
        Path finalOutRootPath = Paths.get(this.config.getRoot().getOutRootPath(), new String[0]);
        for (Map.Entry<Module, List<MyFile>> entry : this.module2Files.entrySet()) {
            Module module = entry.getKey();
            List<MyFile> virtualFiles = entry.getValue();
            for (MyFile exportFile : virtualFiles) {
                String moduleName = module.getName();
                Path src = Paths.get(exportFile.getFile().getPath(), new String[0]);
                if (!this.config.getSource().getNeedExportRelativePath().booleanValue()) {
                    Path target = Paths.get(finalOutRootPath.toString(), dirName, moduleName, exportFile.getFile().getName());
                    destFileMapSourceFile.put(target, src);
                    continue;
                }
                Path relativizePath = Paths.get(exportFile.getRelativePath(), new String[0]);
                Path target = Paths.get(finalOutRootPath.toString(), dirName, moduleName, relativizePath.toString(), exportFile.getFile().getName());
                destFileMapSourceFile.put(target, src);
            }
        }
        LOG.info("\u5171\u6dfb\u52a0\u8981\u5bfc\u51fa\u7684\u6e90\u6587\u4ef6\uff1a" + destFileMapSourceFile.size() + "\u4e2a");
        Pair<Integer, Integer> result = DoExportService.runAsyncForCopyFile(destFileMapSourceFile);
        int total = (Integer)result.getKey();
        int failedTotal = (Integer)result.getValue();
        String content = "\u6e90\u7801\u5bfc\u51fa\u6210\u529f(" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ").<br> (\u9009\u4e2d\u7684\u6e90\u7801\u603b\u6570\u91cf\uff1a" + this.exportFileTotal + "\u4e2a).<br>  \u5bfc\u51fa\u6210\u529f\uff1a" + total + "\u4e2a\uff0c\u5bfc\u51fa\u5931\u8d25\uff1a" + failedTotal + "\u4e2a).<br> ";
        NotificationHelper.showInfo(this.project, content, "\u6253\u5f00\u6e90\u7801\u5bfc\u51fa\u6839\u8def\u5f84", "file://" + finalOutRootPath);
    }

    private static Pair<Integer, Integer> runAsyncForCopyFile(Map<Path, Path> destFileMapSourceFile) {
        ArrayList all = new ArrayList();
        AtomicInteger total = new AtomicInteger();
        AtomicInteger failedTotal = new AtomicInteger();
        destFileMapSourceFile.forEach((dest, src) -> all.add(CompletableFuture.runAsync(() -> {
            try {
                DoExportService.copyFile(dest, src);
                total.getAndIncrement();
            }
            catch (Exception e) {
                failedTotal.getAndIncrement();
                LOG.error("", (Throwable)e);
            }
        })));
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        return new Pair((Object)total.get(), (Object)failedTotal.get());
    }

    private static void copyFile(Path dest, Path src) throws IOException {
        if (Files.notExists(dest.getParent(), new LinkOption[0])) {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        }
        LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src + ", \u5230\uff1a" + dest);
        Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
        LOG.info("\u590d\u5236\u6587\u4ef6\uff0c" + src + ", \u5230\uff1a" + dest + "\u6210\u529f\uff01");
    }

    public boolean findAllNeedExportFiles() throws MalformedURLException {
        for (VirtualFile file : this.selectedFiles) {
            final Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.project);
            if (module != null) {
                if (!file.isDirectory()) {
                    this.addFile(module, file);
                    continue;
                }
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<VirtualFile>(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile child) {
                        if (child == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DoExportService.this.addFile(module, child);
                        return super.visitFile(child);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/xf/util/export/ui/DoExportService$1", "visitFile"));
                    }
                });
                continue;
            }
            NotificationHelper.showWarn(this.event.getProject(), file.getCanonicalPath() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5757\uff01");
        }
        this.exportFileTotal = this.module2Files.values().stream().mapToLong(List::size).sum();
        if (this.module2Files.isEmpty() || this.exportFileTotal == 0L) {
            NotificationHelper.showError(null, "\u8bf7\u5148\u9009\u4e2d\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff01");
            return false;
        }
        return true;
    }

    private void addFile(Module module, VirtualFile file) {
        if (!file.isDirectory() && this.checkFileValid(file, module)) {
            List<MyFile> virtualFiles = this.module2Files.get(module);
            if (virtualFiles == null) {
                virtualFiles = new ArrayList<MyFile>();
            }
            Set<VirtualFile> sourceRootFiles = this.moduleMapSourcePaths.get(module);
            MyFile myFile = new MyFile();
            myFile.setFile(file);
            myFile.setModule(module);
            String extension = (file.getExtension() == null ? "" : "." + file.getExtension()).toLowerCase();
            myFile.setExtension(extension);
            for (VirtualFile sourceRootFile : sourceRootFiles) {
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRootFile);
                if (relativePath == null || !StrUtil.isNotBlank((CharSequence)relativePath) || relativePath.startsWith(".")) continue;
                relativePath = relativePath.substring(0, relativePath.lastIndexOf("/"));
                if (extension.equals(".java")) {
                    this.filesToCompile.add(myFile);
                } else {
                    this.filesToNoCompile.add(myFile);
                }
                myFile.setRelativePath(relativePath);
                if (this.containWeb(sourceRootFile.getPath())) {
                    myFile.setInWebDir(true);
                    break;
                }
                if (!this.checkIsSourceDir(module, sourceRootFile)) break;
                myFile.setInSourceDir(true);
                break;
            }
            virtualFiles.add(myFile);
            this.module2Files.put(module, virtualFiles);
        }
    }

    private Set<VirtualFile> getSourcePaths(Module module) {
        HashSet sourcePaths = this.moduleMapSourcePaths.get(module);
        if (sourcePaths == null) {
            Object[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            sourcePaths = CollUtil.newHashSet((Object[])sourceRoots);
            this.moduleMapSourcePaths.put(module, sourcePaths);
        }
        return sourcePaths;
    }

    private boolean checkFileValid(VirtualFile file, Module module) {
        return this.checkWebPathValid(module, file) || this.checkSourcePathValid(module, file);
    }

    private boolean checkSourcePathValid(Module module, VirtualFile file) {
        Set<VirtualFile> sourcePaths = this.getSourcePaths(module);
        return this.checkIsRelativizePath(sourcePaths, file);
    }

    private boolean checkWebPathValid(Module module, VirtualFile file) {
        Set<VirtualFile> sourcePaths = this.getSourcePaths(module);
        if (this.checkIsRelativizePath(sourcePaths, file)) {
            return true;
        }
        if (this.containWeb(file.getPath())) {
            String webRootPath = this.findWebRootPath(file.getPath());
            if (StrUtil.isNotBlank((CharSequence)webRootPath)) {
                sourcePaths.add(VfsUtil.findFile((Path)Paths.get(webRootPath, new String[0]), (boolean)true));
            }
            return true;
        }
        return false;
    }

    private boolean checkIsRelativizePath(Set<VirtualFile> rootPaths, VirtualFile file) {
        for (VirtualFile sourceRootFile : rootPaths) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRootFile);
            if (!StrUtil.isNotBlank((CharSequence)relativePath)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIsSourceDir(Module module, VirtualFile file) {
        Set<VirtualFile> rootPaths = this.moduleMapSourcePaths.get(module);
        return rootPaths.stream().anyMatch(sourceRootFile -> file.getPath().equals(sourceRootFile.getPath()));
    }

    private boolean containWeb(String path) {
        return Arrays.stream(Constants.WEB_PATH).anyMatch(path::contains);
    }

    private String findWebRootPath(String path) {
        for (String webPath : Constants.WEB_PATH) {
            if (!path.contains(webPath)) continue;
            int webIndex = path.indexOf(webPath);
            return path.substring(0, webIndex + webPath.length());
        }
        return "";
    }
}

