/*
 * Decompiled with CFR 0.152.
 */
package com.xf.util.export.config;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.xf.util.export.helper.Constants;
import com.xf.util.export.vo.Patch;
import com.xf.util.export.vo.Root;
import com.xf.util.export.vo.Source;
import com.xf.util.export.vo.Webapps;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Objects;

public class Config
implements Serializable {
    private static final Logger LOG = Logger.getInstance(Config.class);
    private static final JSONConfig jsonConfig = JSONConfig.create().setOrder(false).setIgnoreError(false).setIgnoreCase(false).setDateFormat(null).setIgnoreNullValue(false).setTransientSupport(true).setStripTrailingZeros(false);
    private static Config config = null;
    private String pluginVersion = "";
    private Root root = new Root();
    private Source source = new Source();
    private Patch patch = new Patch();
    private Webapps webapps = new Webapps();

    private Config() {
    }

    public static Config getInstance() throws Exception {
        CopyOptions copyOptions = CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true).setIgnoreCase(false).setTransientSupport(false);
        Config defaultConfig = Config.getDefaultConfig();
        Config cloneConfig = new Config();
        BeanUtil.copyProperties((Object)defaultConfig, (Object)cloneConfig, (CopyOptions)copyOptions);
        Path path = Paths.get(Constants.CONFIG_FILE_PATH, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
                FileUtil.writeString((String)"{}", (String)Constants.CONFIG_FILE_PATH, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                LOG.error("\u914d\u7f6e\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (Throwable)e);
                throw new Exception(e);
            }
        }
        try {
            Config diyConfig;
            String configJson = FileUtil.readString((String)Constants.CONFIG_FILE_PATH, (Charset)StandardCharsets.UTF_8);
            if (StrUtil.isNotBlank((CharSequence)configJson) && !StrUtil.equals((CharSequence)"{}", (CharSequence)configJson) && (diyConfig = (Config)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((Object)configJson, (JSONConfig)jsonConfig), Config.class)) != null && StrUtil.equals((CharSequence)Constants.PLUGIN_VERSION, (CharSequence)diyConfig.getPluginVersion())) {
                BeanUtil.copyProperties((Object)diyConfig, (Object)cloneConfig, (CopyOptions)copyOptions);
            }
        }
        catch (Exception e) {
            LOG.error("\u81ea\u5b9a\u4e49\u914d\u7f6e\u8f6c\u6362\u5931\u8d25\u65f6\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7684\u914d\u7f6e", (Throwable)e);
        }
        return cloneConfig;
    }

    public static Config getDefaultConfig() {
        URL url = Config.class.getClassLoader().getResource("idea-export-patch-config-template.json");
        String configJson = FileUtil.readString((URL)Objects.requireNonNull(url), (Charset)StandardCharsets.UTF_8);
        Config defaultConfig = (Config)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((Object)configJson, (JSONConfig)jsonConfig), Config.class);
        defaultConfig.getRoot().setSuffixName(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        defaultConfig.getRoot().setOutRootPath(Constants.DESKTOP_PATH);
        return defaultConfig;
    }

    public static void updateConfig(Config config) {
        FileUtil.writeString((String)JSONUtil.toJsonPrettyStr((JSON)JSONUtil.parse((Object)config, (JSONConfig)jsonConfig)), (String)Constants.CONFIG_FILE_PATH, (Charset)StandardCharsets.UTF_8);
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public Root getRoot() {
        return this.root;
    }

    public Source getSource() {
        return this.source;
    }

    public Patch getPatch() {
        return this.patch;
    }

    public Webapps getWebapps() {
        return this.webapps;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public void setRoot(Root root) {
        this.root = root;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    public void setWebapps(Webapps webapps) {
        this.webapps = webapps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pluginVersion = this.getPluginVersion();
        String other$pluginVersion = other.getPluginVersion();
        if (this$pluginVersion == null ? other$pluginVersion != null : !this$pluginVersion.equals(other$pluginVersion)) {
            return false;
        }
        Root this$root = this.getRoot();
        Root other$root = other.getRoot();
        if (this$root == null ? other$root != null : !((Object)this$root).equals(other$root)) {
            return false;
        }
        Source this$source = this.getSource();
        Source other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Patch this$patch = this.getPatch();
        Patch other$patch = other.getPatch();
        if (this$patch == null ? other$patch != null : !((Object)this$patch).equals(other$patch)) {
            return false;
        }
        Webapps this$webapps = this.getWebapps();
        Webapps other$webapps = other.getWebapps();
        return !(this$webapps == null ? other$webapps != null : !((Object)this$webapps).equals(other$webapps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginVersion = this.getPluginVersion();
        result = result * 59 + ($pluginVersion == null ? 43 : $pluginVersion.hashCode());
        Root $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : ((Object)$root).hashCode());
        Source $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Patch $patch = this.getPatch();
        result = result * 59 + ($patch == null ? 43 : ((Object)$patch).hashCode());
        Webapps $webapps = this.getWebapps();
        result = result * 59 + ($webapps == null ? 43 : ((Object)$webapps).hashCode());
        return result;
    }

    public String toString() {
        return "Config(pluginVersion=" + this.getPluginVersion() + ", root=" + this.getRoot() + ", source=" + this.getSource() + ", patch=" + this.getPatch() + ", webapps=" + this.getWebapps() + ")";
    }
}

