/*
 * Decompiled with CFR 0.152.
 */
package com.xf.util.export.service;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.xf.util.export.config.Config;
import com.xf.util.export.helper.Constants;
import com.xf.util.export.service.DoExportFileService;
import com.xf.util.export.service.DoExportNormalService;
import com.xf.util.export.service.DoExportPakService;
import com.xf.util.export.service.DoExportSourceService;
import com.xf.util.export.service.vo.ExportContext;
import com.xf.util.export.service.vo.OutFileMap;
import com.xf.util.export.service.vo.PakConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 =2\u00020\u0001:\u0001=B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u00101\u001a\u00020\u001cJ\u000e\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u00020\tJ\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u0005J\u0006\u00108\u001a\u000209J\u0006\u0010:\u001a\u00020\u0003J\u0010\u0010;\u001a\u00020\u001c2\u0006\u00103\u001a\u000204H\u0002J\u0006\u0010<\u001a\u00020\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010!\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\"\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\"\u0010'\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001e\"\u0004\b*\u0010 R\"\u0010+\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001e\"\u0004\b-\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010.\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001e\"\u0004\b0\u0010 \u00a8\u0006>"}, d2={"Lcom/xf/util/export/service/DoExportRootService;", "", "project", "Lcom/intellij/openapi/project/Project;", "selectedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "config", "Lcom/xf/util/export/config/Config;", "doExportFileService", "Lcom/xf/util/export/service/DoExportFileService;", "getDoExportFileService", "()Lcom/xf/util/export/service/DoExportFileService;", "doExportNormalService", "Lcom/xf/util/export/service/DoExportNormalService;", "getDoExportNormalService", "()Lcom/xf/util/export/service/DoExportNormalService;", "doExportPakService", "Lcom/xf/util/export/service/DoExportPakService;", "getDoExportPakService", "()Lcom/xf/util/export/service/DoExportPakService;", "doExportSourceService", "Lcom/xf/util/export/service/DoExportSourceService;", "getDoExportSourceService", "()Lcom/xf/util/export/service/DoExportSourceService;", "es62Es5ConfigFun", "Lkotlin/Function0;", "", "getEs62Es5ConfigFun", "()Lkotlin/jvm/functions/Function0;", "setEs62Es5ConfigFun", "(Lkotlin/jvm/functions/Function0;)V", "globalSaveConfigFun", "getGlobalSaveConfigFun", "setGlobalSaveConfigFun", "normalSaveConfigFun", "getNormalSaveConfigFun", "setNormalSaveConfigFun", "pakRealConfigDataFun", "Lcom/xf/util/export/service/vo/PakConfig;", "getPakRealConfigDataFun", "setPakRealConfigDataFun", "pakSaveConfigFun", "getPakSaveConfigFun", "setPakSaveConfigFun", "sourceSaveConfigFun", "getSourceSaveConfigFun", "setSourceSaveConfigFun", "closeWin", "export", "context", "Lcom/xf/util/export/service/vo/ExportContext;", "getConfig", "getModuleNameList", "", "getOutFileMap", "Lcom/xf/util/export/service/vo/OutFileMap;", "getProject", "runExport", "saveConfig", "Companion", "Idea-Export-Patch2-Jdk17"})
public final class DoExportRootService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Project project;
    @NotNull
    private final Config config;
    @NotNull
    private final DoExportFileService doExportFileService;
    @NotNull
    private final DoExportSourceService doExportSourceService;
    @NotNull
    private final DoExportNormalService doExportNormalService;
    @NotNull
    private final DoExportPakService doExportPakService;
    @Nullable
    private Function0<Unit> globalSaveConfigFun;
    @Nullable
    private Function0<Unit> sourceSaveConfigFun;
    @Nullable
    private Function0<Unit> normalSaveConfigFun;
    @Nullable
    private Function0<Unit> pakSaveConfigFun;
    @Nullable
    private Function0<Unit> es62Es5ConfigFun;
    @Nullable
    private Function0<PakConfig> pakRealConfigDataFun;
    @NotNull
    private static final Logger LOG;
    private static boolean opened;

    public DoExportRootService(@NotNull Project project, @NotNull List<VirtualFile> selectedFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(selectedFiles, (String)"selectedFiles");
        this.project = project;
        this.config = Config.Companion.getInstance(this.project);
        this.doExportFileService = new DoExportFileService(this, selectedFiles);
        this.doExportSourceService = new DoExportSourceService(this);
        this.doExportNormalService = new DoExportNormalService(this);
        this.doExportPakService = new DoExportPakService(this);
        opened = true;
    }

    @NotNull
    public final DoExportFileService getDoExportFileService() {
        return this.doExportFileService;
    }

    @NotNull
    public final DoExportSourceService getDoExportSourceService() {
        return this.doExportSourceService;
    }

    @NotNull
    public final DoExportNormalService getDoExportNormalService() {
        return this.doExportNormalService;
    }

    @NotNull
    public final DoExportPakService getDoExportPakService() {
        return this.doExportPakService;
    }

    @Nullable
    public final Function0<Unit> getGlobalSaveConfigFun() {
        return this.globalSaveConfigFun;
    }

    public final void setGlobalSaveConfigFun(@Nullable Function0<Unit> function0) {
        this.globalSaveConfigFun = function0;
    }

    @Nullable
    public final Function0<Unit> getSourceSaveConfigFun() {
        return this.sourceSaveConfigFun;
    }

    public final void setSourceSaveConfigFun(@Nullable Function0<Unit> function0) {
        this.sourceSaveConfigFun = function0;
    }

    @Nullable
    public final Function0<Unit> getNormalSaveConfigFun() {
        return this.normalSaveConfigFun;
    }

    public final void setNormalSaveConfigFun(@Nullable Function0<Unit> function0) {
        this.normalSaveConfigFun = function0;
    }

    @Nullable
    public final Function0<Unit> getPakSaveConfigFun() {
        return this.pakSaveConfigFun;
    }

    public final void setPakSaveConfigFun(@Nullable Function0<Unit> function0) {
        this.pakSaveConfigFun = function0;
    }

    @Nullable
    public final Function0<Unit> getEs62Es5ConfigFun() {
        return this.es62Es5ConfigFun;
    }

    public final void setEs62Es5ConfigFun(@Nullable Function0<Unit> function0) {
        this.es62Es5ConfigFun = function0;
    }

    @Nullable
    public final Function0<PakConfig> getPakRealConfigDataFun() {
        return this.pakRealConfigDataFun;
    }

    public final void setPakRealConfigDataFun(@Nullable Function0<PakConfig> function0) {
        this.pakRealConfigDataFun = function0;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final List<String> getModuleNameList() {
        return this.doExportFileService.getModuleNameList();
    }

    @NotNull
    public final OutFileMap getOutFileMap() {
        return this.doExportFileService.getOutFileMap();
    }

    public final void saveConfig() {
        LOG.info("\u5f00\u59cb\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5230\u5b9e\u4f53config\u5bf9\u8c61......");
        String string = Constants.INSTANCE.getPLUGIN_VERSION();
        Intrinsics.checkNotNull((Object)string);
        this.config.setPluginVersion(string);
        Function0<Unit> function0 = this.globalSaveConfigFun;
        if (function0 != null) {
            function0.invoke();
        }
        Function0<Unit> function02 = this.sourceSaveConfigFun;
        if (function02 != null) {
            function02.invoke();
        }
        Function0<Unit> function03 = this.normalSaveConfigFun;
        if (function03 != null) {
            function03.invoke();
        }
        Function0<Unit> function04 = this.pakSaveConfigFun;
        if (function04 != null) {
            function04.invoke();
        }
        Function0<Unit> function05 = this.es62Es5ConfigFun;
        if (function05 != null) {
            function05.invoke();
        }
        LOG.info("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5230\u5b9e\u4f53config\u5bf9\u8c61\u5b8c\u6210\uff01");
    }

    public final void closeWin() {
        opened = false;
    }

    public final void export(@NotNull ExportContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.doExportFileService.compile(new ExportContext((Function0<? extends Object>)((Function0)new Function0<Unit>(this, context){
            final /* synthetic */ DoExportRootService this$0;
            final /* synthetic */ ExportContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(0);
            }

            public final void invoke() {
                DoExportRootService.access$runExport(this.this$0, this.$context);
            }
        }), (Function0<? extends Object>)((Function0)new Function0<Object>(context){
            final /* synthetic */ ExportContext $context;
            {
                this.$context = $context;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$context.getErrorCallback().invoke();
            }
        })));
    }

    private final void runExport(ExportContext context) {
        Project project = this.project;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, context, project){
            final /* synthetic */ DoExportRootService this$0;
            final /* synthetic */ ExportContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super($super_call_param$1, "\u5bfc\u51fa\u4efb\u52a1\u8fdb\u884c\u4e2d", false);
            }

            public void run(@NotNull ProgressIndicator progressIndicator) {
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                progressIndicator.setIndeterminate(false);
                DoExportRootService.Companion.getLOG().info("[\u603b\u8fdb\u5ea6]\u5f00\u59cb\u5bfc\u51fa......");
                progressIndicator.setText("[\u603b\u8fdb\u5ea6]\u5f00\u59cb\u5bfc\u51fa......");
                progressIndicator.setText("[\u603b\u8fdb\u5ea6]\u6b63\u5728\u8ba1\u7b97\u5bfc\u51fa\u6570\u91cf......");
                progressIndicator.setFraction(0.0);
                this.this$0.getDoExportFileService().analysis(new ExportContext((Function0<? extends Object>)((Function0)new Function0<Unit>(this.this$0, progressIndicator, this.$context){
                    final /* synthetic */ DoExportRootService this$0;
                    final /* synthetic */ ProgressIndicator $progressIndicator;
                    final /* synthetic */ ExportContext $context;
                    {
                        this.this$0 = $receiver;
                        this.$progressIndicator = $progressIndicator;
                        this.$context = $context;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getDoExportSourceService().export(this.$progressIndicator, new ExportContext((Function0<? extends Object>)((Function0)new Function0<Unit>(this.this$0, this.$progressIndicator, this.$context){
                            final /* synthetic */ DoExportRootService this$0;
                            final /* synthetic */ ProgressIndicator $progressIndicator;
                            final /* synthetic */ ExportContext $context;
                            {
                                this.this$0 = $receiver;
                                this.$progressIndicator = $progressIndicator;
                                this.$context = $context;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getDoExportNormalService().export(this.$progressIndicator, new ExportContext((Function0<? extends Object>)((Function0)new Function0<Unit>(this.this$0, this.$progressIndicator, this.$context){
                                    final /* synthetic */ DoExportRootService this$0;
                                    final /* synthetic */ ProgressIndicator $progressIndicator;
                                    final /* synthetic */ ExportContext $context;
                                    {
                                        this.this$0 = $receiver;
                                        this.$progressIndicator = $progressIndicator;
                                        this.$context = $context;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.this$0.getDoExportPakService().export(this.$progressIndicator, new ExportContext((Function0<? extends Object>)((Function0)new Function0<Object>(this.$context){
                                            final /* synthetic */ ExportContext $context;
                                            {
                                                this.$context = $context;
                                                super(0);
                                            }

                                            @Nullable
                                            public final Object invoke() {
                                                return this.$context.getSuccessCallback().invoke();
                                            }
                                        }), (Function0<? extends Object>)((Function0)new Function0<Object>(this.$context){
                                            final /* synthetic */ ExportContext $context;
                                            {
                                                this.$context = $context;
                                                super(0);
                                            }

                                            @Nullable
                                            public final Object invoke() {
                                                return this.$context.getErrorCallback().invoke();
                                            }
                                        })));
                                    }
                                }), (Function0<? extends Object>)((Function0)new Function0<Object>(this.$context){
                                    final /* synthetic */ ExportContext $context;
                                    {
                                        this.$context = $context;
                                        super(0);
                                    }

                                    @Nullable
                                    public final Object invoke() {
                                        return this.$context.getErrorCallback().invoke();
                                    }
                                })));
                            }
                        }), (Function0<? extends Object>)((Function0)new Function0<Object>(this.$context){
                            final /* synthetic */ ExportContext $context;
                            {
                                this.$context = $context;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return this.$context.getErrorCallback().invoke();
                            }
                        })));
                    }
                }), (Function0<? extends Object>)((Function0)new Function0<Object>(this.$context){
                    final /* synthetic */ ExportContext $context;
                    {
                        this.$context = $context;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$context.getErrorCallback().invoke();
                    }
                })));
            }
        });
    }

    public static final /* synthetic */ void access$runExport(DoExportRootService $this, ExportContext context) {
        $this.runExport(context);
    }

    static {
        Logger logger = Logger.getInstance(DoExportRootService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/xf/util/export/service/DoExportRootService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "opened", "", "getOpened", "()Z", "setOpened", "(Z)V", "Idea-Export-Patch2-Jdk17"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public final boolean getOpened() {
            return opened;
        }

        public final void setOpened(boolean bl) {
            opened = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

