/*
 * Decompiled with CFR 0.152.
 */
package com.xf.util.export.service;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.ZipUtil;
import com.xf.util.export.config.Config;
import com.xf.util.export.config.Pak;
import com.xf.util.export.helper.MessageHelper;
import com.xf.util.export.helper.NotificationHelper;
import com.xf.util.export.service.DoExportRootService;
import com.xf.util.export.service.vo.ExportContext;
import com.xf.util.export.service.vo.OutFile;
import com.xf.util.export.service.vo.OutFileMap;
import com.xf.util.export.service.vo.OutRelativeFile;
import com.xf.util.export.service.vo.PakConfig;
import com.xf.util.export.ui.vo.Option;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/xf/util/export/service/DoExportPakService;", "", "doExportRootService", "Lcom/xf/util/export/service/DoExportRootService;", "(Lcom/xf/util/export/service/DoExportRootService;)V", "config", "Lcom/xf/util/export/config/Config;", "getDoExportRootService", "()Lcom/xf/util/export/service/DoExportRootService;", "setDoExportRootService", "outFileMap", "Lcom/xf/util/export/service/vo/OutFileMap;", "uriDownload", "", "uriSubmit", "export", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "context", "Lcom/xf/util/export/service/vo/ExportContext;", "generateCompressedPackage", "outRootPath", "Ljava/nio/file/Path;", "pakConfig", "Lcom/xf/util/export/service/vo/PakConfig;", "getMinVersion", "parseCheckResultAndDownloadFile", "it", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "client", "Lorg/apache/http/impl/client/CloseableHttpClient;", "requestPakMakeSite", "", "url", "Companion", "Idea-Export-Patch2-Jdk17"})
@SourceDebugExtension(value={"SMAP\nDoExportPakService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoExportPakService.kt\ncom/xf/util/export/service/DoExportPakService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,417:1\n211#2,2:418\n13536#3,2:420\n1849#4,2:422\n1849#4,2:424\n764#4:426\n855#4,2:427\n1043#4:429\n1849#4,2:430\n1849#4,2:432\n1849#4,2:434\n1849#4,2:436\n1000#4,2:438\n1009#4,2:440\n1009#4,2:442\n1000#4,2:444\n*S KotlinDebug\n*F\n+ 1 DoExportPakService.kt\ncom/xf/util/export/service/DoExportPakService\n*L\n109#1:418,2\n194#1:420,2\n209#1:422,2\n213#1:424,2\n298#1:426\n298#1:427,2\n299#1:429\n322#1:430,2\n338#1:432,2\n357#1:434,2\n377#1:436,2\n392#1:438,2\n393#1:440,2\n394#1:442,2\n395#1:444,2\n*E\n"})
public final class DoExportPakService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DoExportRootService doExportRootService;
    @NotNull
    private Config config;
    @NotNull
    private OutFileMap outFileMap;
    @NotNull
    private final String uriSubmit;
    @NotNull
    private final String uriDownload;
    @NotNull
    private static final Logger LOG;

    public DoExportPakService(@NotNull DoExportRootService doExportRootService) {
        Intrinsics.checkNotNullParameter((Object)doExportRootService, (String)"doExportRootService");
        this.doExportRootService = doExportRootService;
        this.config = this.doExportRootService.getConfig();
        this.outFileMap = this.doExportRootService.getOutFileMap();
        this.uriSubmit = "/downloadPatch";
        this.uriDownload = "/download?filePath={filePath}&fileName={fileName}";
    }

    @NotNull
    public final DoExportRootService getDoExportRootService() {
        return this.doExportRootService;
    }

    public final void setDoExportRootService(@NotNull DoExportRootService doExportRootService) {
        Intrinsics.checkNotNullParameter((Object)doExportRootService, (String)"<set-?>");
        this.doExportRootService = doExportRootService;
    }

    public final void export(@NotNull ProgressIndicator progressIndicator, @NotNull ExportContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LOG.info("[\u603b\u8fdb\u5ea6]pak\u8865\u4e01\u5305\u662f\u5426\u5bfc\u51fa[" + this.config.getGlobal().getCanExportPak() + "]");
        progressIndicator.setText("[\u603b\u8fdb\u5ea6]pak\u8865\u4e01\u5305" + (this.config.getGlobal().getCanExportPak() ? "" : "\u4e0d") + "\u9700\u8981\u5bfc\u51fa");
        if (!this.config.getGlobal().getCanExportPak()) {
            DoExportPakService.export$successMsgOutput(progressIndicator, this, context);
            return;
        }
        LOG.info("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8fdb\u884c\u76ee\u6807\u76f8\u5bf9\u8def\u5f84\u8865\u5145\u6210\u7edd\u5bf9\u8def\u5f84\u5904\u7406\u5f00\u59cb......");
        progressIndicator.setText("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8fdb\u884c\u76ee\u6807\u76f8\u5bf9\u8def\u5f84\u8865\u5145\u6210\u7edd\u5bf9\u8def\u5f84\u5904\u7406\u5f00\u59cb......");
        Function0<PakConfig> function0 = this.doExportRootService.getPakRealConfigDataFun();
        PakConfig pakConfig = function0 != null ? (PakConfig)function0.invoke() : null;
        Intrinsics.checkNotNull((Object)pakConfig);
        PakConfig pakConfig2 = pakConfig;
        Object object = pakConfig2.getRootUrl();
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u8f93\u5165\u5236\u4f5cpak\u8865\u4e01\u5305\u7684\u9996\u9875\u5730\u5740\uff01");
            context.getErrorCallback().invoke();
            return;
        }
        if (StringsKt.isBlank((CharSequence)pakConfig2.getBugNo())) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u8f93\u5165BUG\u7f16\u53f7\uff01");
            context.getErrorCallback().invoke();
            return;
        }
        if (StringsKt.isBlank((CharSequence)pakConfig2.getDogCode())) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u8f93\u5165\u52a0\u5bc6\u72d7\u53f7\uff01");
            context.getErrorCallback().invoke();
            return;
        }
        if (StringsKt.isBlank((CharSequence)pakConfig2.getBugDesc())) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u8f93\u5165\u8865\u4e01\u63cf\u8ff0\uff01");
            context.getErrorCallback().invoke();
            return;
        }
        String string2 = pakConfig2.getRootUrl();
        Intrinsics.checkNotNull((Object)string2);
        if (StringsKt.endsWith$default((String)string2, (String)"/", (boolean)false, (int)2, null)) {
            String string3 = pakConfig2.getRootUrl();
            Intrinsics.checkNotNull((Object)string3);
            String string4 = pakConfig2.getRootUrl();
            Intrinsics.checkNotNull((Object)string4);
            String string5 = string3.substring(0, string4.length() - 1);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = pakConfig2.getRootUrl();
        }
        pakConfig2.setRootUrl(string);
        object = pakConfig2.getJarNameMapping();
        if (object == null || object.isEmpty()) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u586b\u5199\u6a21\u5757jar\u540d\u79f0\uff01\u8981\u6c42\u6620\u5c04\u683c\u5f0f\u4e3a-> \u6a21\u5757\u540d\u79f0:\u5b9e\u9645jar\u6587\u4ef6\u540d\u79f0\uff08\u591a\u4e2a\u65f6\u6bcf\u4e2a\u4e00\u884c\uff0c\u4e14\u540d\u79f0\u4e0d\u5e26\u540e\u7f00\uff09\uff01");
            context.getErrorCallback().invoke();
            return;
        }
        if (pakConfig2.getProductLine() == null) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u9009\u62e9\u4e00\u4e2a\u4ea7\u54c1\u7ebf");
            context.getErrorCallback().invoke();
            return;
        }
        object = pakConfig2.getVersionList();
        if (object == null || object.isEmpty()) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u7248\u672c");
            context.getErrorCallback().invoke();
            return;
        }
        object = pakConfig2.getBuildIdList();
        if (object == null || object.isEmpty()) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2aBuildId");
            context.getErrorCallback().invoke();
            return;
        }
        Map<String, String> jarNameMapping = this.config.getPak().getJarNameMapping();
        String minVersion = this.getMinVersion(pakConfig2);
        String[] stringArray = new String[]{"pak\u8865\u4e01\u5305"};
        Path outRootPath = Paths.get(this.config.getGlobal().getOutRootPath(), stringArray);
        Map<Path, OutRelativeFile> $this$forEach$iv = this.outFileMap.getAfterCompilationFileMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Path, OutRelativeFile>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Path, OutRelativeFile> element$iv;
            Map.Entry<Path, OutRelativeFile> entry = element$iv = iterator.next();
            boolean bl = false;
            Path src = entry.getKey();
            OutRelativeFile dest = entry.getValue();
            Path outPath = null;
            String jarName = jarNameMapping.get(dest.getModule().getName()) + ".jar";
            switch (WhenMappings.$EnumSwitchMapping$0[dest.getType().ordinal()]) {
                case 1: {
                    Path path;
                    Path path2;
                    String[] stringArray2;
                    if (minVersion.compareTo("V8.1SP1") > 0) {
                        stringArray2 = new String[]{this.config.getGlobal().getWebappsName(), "WEB-INF", "lib", jarName, ((Object)dest.getRelativePath()).toString()};
                        path2 = Paths.get(((Object)outRootPath).toString(), stringArray2);
                        Intrinsics.checkNotNull((Object)path2);
                        path = path2;
                    } else {
                        stringArray2 = new String[]{this.config.getGlobal().getWebappsName(), "WEB-INF", "classes", ((Object)dest.getRelativePath()).toString()};
                        path2 = Paths.get(((Object)outRootPath).toString(), stringArray2);
                        Intrinsics.checkNotNull((Object)path2);
                        path = path2;
                    }
                    outPath = path;
                    break;
                }
                case 2: {
                    Path path;
                    Path path2;
                    String[] stringArray2;
                    if (minVersion.compareTo("V8.1SP1") > 0) {
                        stringArray2 = new String[]{this.config.getGlobal().getWebappsName(), "WEB-INF", "lib", jarName, ((Object)dest.getRelativePath()).toString()};
                        path2 = Paths.get(((Object)outRootPath).toString(), stringArray2);
                        Intrinsics.checkNotNull((Object)path2);
                        path = path2;
                    } else {
                        stringArray2 = new String[]{this.config.getGlobal().getWebappsName(), "WEB-INF", "classes", ((Object)dest.getRelativePath()).toString()};
                        path2 = Paths.get(((Object)outRootPath).toString(), stringArray2);
                        Intrinsics.checkNotNull((Object)path2);
                        path = path2;
                    }
                    outPath = path;
                    break;
                }
                case 3: {
                    Path path;
                    Path path2;
                    String[] stringArray2;
                    if (minVersion.compareTo("V8.1SP1") > 0) {
                        stringArray2 = new String[]{this.config.getGlobal().getWebappsName(), "WEB-INF", "lib", jarName, ((Object)dest.getRelativePath()).toString()};
                        path2 = Paths.get(((Object)outRootPath).toString(), stringArray2);
                        Intrinsics.checkNotNull((Object)path2);
                        path = path2;
                    } else {
                        stringArray2 = new String[]{this.config.getGlobal().getWebappsName(), "WEB-INF", "classes", ((Object)dest.getRelativePath()).toString()};
                        path2 = Paths.get(((Object)outRootPath).toString(), stringArray2);
                        Intrinsics.checkNotNull((Object)path2);
                        path = path2;
                    }
                    outPath = path;
                    break;
                }
                default: {
                    String[] stringArray2 = new String[]{this.config.getGlobal().getWebappsName(), ((Object)dest.getRelativePath()).toString()};
                    Path path = Paths.get(((Object)outRootPath).toString(), stringArray2);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    outPath = path;
                }
            }
            this.outFileMap.getCopyFileMap().put(new OutFile(outPath, dest.getRelativePath()), src);
            LOG.info("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u5c06\u76ee\u6807\u76f8\u5bf9\u8def\u5f84[" + dest.getRelativePath() + "]\u8865\u5145\u6210\u7edd\u5bf9\u8def\u5f84[" + outPath + "]\u5b8c\u6210\uff01");
        }
        LOG.info("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u76ee\u6807\u76f8\u5bf9\u8def\u5f84\u8865\u5145\u6210\u7edd\u5bf9\u8def\u5f84\u5b8c\u6210\uff01");
        progressIndicator.setText("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u76ee\u6807\u76f8\u5bf9\u8def\u5f84\u8865\u5145\u6210\u7edd\u5bf9\u8def\u5f84\u5b8c\u6210\uff01");
        if (this.config.getPak().getEs62es5()) {
            this.doExportRootService.getDoExportFileService().es62es5(this.outFileMap.getCopyFileMap(), new ExportContext((Function0<? extends Object>)((Function0)new Function0<Unit>(this, progressIndicator, outRootPath, pakConfig2, context){
                final /* synthetic */ DoExportPakService this$0;
                final /* synthetic */ ProgressIndicator $progressIndicator;
                final /* synthetic */ Path $outRootPath;
                final /* synthetic */ PakConfig $pakConfig;
                final /* synthetic */ ExportContext $context;
                {
                    this.this$0 = $receiver;
                    this.$progressIndicator = $progressIndicator;
                    this.$outRootPath = $outRootPath;
                    this.$pakConfig = $pakConfig;
                    this.$context = $context;
                    super(0);
                }

                public final void invoke() {
                    DoExportPakService.access$export$doSuccess(this.this$0, this.$progressIndicator, this.$outRootPath, this.$pakConfig, this.$context);
                }
            }), (Function0<? extends Object>)((Function0)new Function0<Object>(context){
                final /* synthetic */ ExportContext $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$context.getErrorCallback().invoke();
                }
            })));
        } else {
            DoExportPakService.export$doSuccess(this, progressIndicator, outRootPath, pakConfig2, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateCompressedPackage(Path outRootPath, PakConfig pakConfig, ExportContext context) {
        String[] stringArray = new String[]{"pak\u8865\u4e01\u5305.zip"};
        Path zipPath = Paths.get(((Object)outRootPath).toString(), stringArray);
        Files.deleteIfExists(zipPath);
        String[] stringArray2 = new String[]{this.config.getGlobal().getWebappsName()};
        Path srcPath = Paths.get(((Object)outRootPath).toString(), stringArray2);
        Object object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
        OutputStream zipFileOutputStream = Files.newOutputStream(zipPath, object);
        object = new ZipOutputStream(zipFileOutputStream);
        Throwable throwable = null;
        try {
            Unit unit;
            File[] children;
            ZipOutputStream zipOutputStream = (ZipOutputStream)object;
            boolean bl = false;
            if (children != null) {
                children = srcPath.toFile().listFiles();
                Intrinsics.checkNotNull((Object)children);
                File[] $this$forEach$iv = children;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File child = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    ZipUtil.addDirToZipRecursively((ZipOutputStream)zipOutputStream, (File)srcPath.toFile(), (File)child, (String)this.config.getGlobal().getWebappsName(), null, null);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            zipOutputStream = unit;
        }
        catch (Throwable zipOutputStream) {
            throwable = zipOutputStream;
            throw zipOutputStream;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(pakConfig.getRootUrl() + this.uriSubmit);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addBinaryBody("patchFile", zipPath.toFile());
        Option option = pakConfig.getProductLine();
        builder.addTextBody("productedition", option != null ? option.getValue() : null);
        Option option2 = pakConfig.getPakType();
        builder.addTextBody("patchtype", option2 != null ? option2.getValue() : null);
        builder.addTextBody("bugId", pakConfig.getBugNo());
        builder.addTextBody("dogNo", pakConfig.getDogCode());
        builder.addTextBody("description", pakConfig.getBugDesc());
        List<Option> list = pakConfig.getBuildIdList();
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Option it = (Option)element$iv;
            boolean bl = false;
            builder.addTextBody("buildId", it.getValue());
            builder.addTextBody("_buildId", "on");
        }
        List<Option> list2 = pakConfig.getVersionList();
        Intrinsics.checkNotNull(list2);
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Option it = (Option)element$iv;
            boolean bl = false;
            builder.addTextBody("productversion", it.getValue());
            builder.addTextBody("_productversion", "on");
        }
        HttpEntity entity = builder.build();
        httpPost.setEntity(entity);
        Closeable closeable = (Closeable)client.execute((HttpUriRequest)httpPost);
        Object object2 = null;
        try {
            CloseableHttpResponse response = (CloseableHttpResponse)closeable;
            boolean bl = false;
            ExportContext exportContext2 = new ExportContext((Function0<? extends Object>)((Function0)new Function0<Object>(srcPath, zipPath, context){
                final /* synthetic */ Path $srcPath;
                final /* synthetic */ Path $zipPath;
                final /* synthetic */ ExportContext $context;
                {
                    this.$srcPath = $srcPath;
                    this.$zipPath = $zipPath;
                    this.$context = $context;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    Files.deleteIfExists(this.$srcPath);
                    Files.deleteIfExists(this.$zipPath);
                    return this.$context.getSuccessCallback().invoke();
                }
            }), (Function0<? extends Object>)((Function0)new Function0<Object>(context){
                final /* synthetic */ ExportContext $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$context.getErrorCallback().invoke();
                }
            }));
            Intrinsics.checkNotNull((Object)response);
            Intrinsics.checkNotNull((Object)client);
            this.parseCheckResultAndDownloadFile(response, pakConfig, client, outRootPath, exportContext2);
        }
        catch (Throwable throwable2) {
            try {
                object2 = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)closeable, object2);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseCheckResultAndDownloadFile(CloseableHttpResponse it, PakConfig pakConfig, CloseableHttpClient client, Path outRootPath, ExportContext context) {
        if (it.getStatusLine().getStatusCode() != 200) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8865\u4e01\u5236\u4f5c\u63d0\u4ea4\u63a5\u53e3\u8bf7\u6c42\u62a5\u9519=status=" + it.getStatusLine().getStatusCode() + ", reason:" + it.getStatusLine().getReasonPhrase());
            context.getErrorCallback().invoke();
            return;
        }
        InputStream inputStream = it.getEntity().getContent();
        List readLines = IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNull((Object)readLines);
        String readString = CollectionsKt.joinToString$default((Iterable)readLines, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        LOG.info("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + readString);
        JSONObject jsonObject = JSON.parseObject((String)readString);
        int status = jsonObject.getIntValue("status");
        if (status == 500) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8865\u4e01\u5236\u4f5c\u63d0\u4ea4\u63a5\u53e3\u8bf7\u6c42\u62a5\u9519=" + jsonObject.getString("error"));
            context.getErrorCallback().invoke();
            return;
        }
        List logicErrorList = jsonObject.getList("logicError", String.class, new JSONReader.Feature[0]);
        Collection collection = logicErrorList;
        if (!(collection == null || collection.isEmpty())) {
            Intrinsics.checkNotNull((Object)logicErrorList);
            Iterable iterable = logicErrorList;
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
            String errorList = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8865\u4e01\u5236\u4f5c\u63d0\u4ea4\u63a5\u53e3\u8bf7\u6c42\u62a5\u9519logicError=" + errorList);
            context.getErrorCallback().invoke();
            return;
        }
        JSONObject checkPatchMap = jsonObject.getJSONObject("checkPatchMap");
        List checkPatchResList = new ArrayList();
        checkPatchMap.forEach((arg_0, arg_1) -> DoExportPakService.parseCheckResultAndDownloadFile$lambda$6((Function2)new Function2<String, Object, Unit>((List<String>)checkPatchResList){
            final /* synthetic */ List<String> $checkPatchResList;
            {
                this.$checkPatchResList = $checkPatchResList;
                super(2);
            }

            public final void invoke(String key, Object value) {
                this.$checkPatchResList.add("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8865\u4e01\u5305\u5173\u8054BuildID\uff08" + key + "\uff09\u7248\u672c\u6821\u9a8c\u7ed3\u679c\uff1a" + value);
            }
        }, arg_0, arg_1));
        if (!checkPatchResList.isEmpty()) {
            Iterable iterable = checkPatchResList;
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
            String checkResult = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
            LOG.info("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u7ed3\u679c\u6821\u9a8c\uff1a" + checkResult + " ");
        }
        LOG.info("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u63a5\u53e3\u662f\u5426\u9519\u8bef\uff1a" + jsonObject.getString("interfaceError"));
        String filePath = jsonObject.getString("filePath");
        String fileName = jsonObject.getString("fileName");
        String filePathEncode = URLEncoder.encode(filePath, "utf-8");
        String fileNameEncode = URLEncoder.encode(fileName, "utf-8");
        String string = pakConfig.getRootUrl();
        Intrinsics.checkNotNull((Object)filePathEncode);
        String string2 = StringsKt.replace$default((String)this.uriDownload, (String)"{filePath}", (String)filePathEncode, (boolean)false, (int)4, null);
        Intrinsics.checkNotNull((Object)fileNameEncode);
        String downloadUrl = string + StringsKt.replace$default((String)string2, (String)"{fileName}", (String)fileNameEncode, (boolean)false, (int)4, null);
        HttpGet downloadClient = new HttpGet(downloadUrl);
        Closeable closeable = (Closeable)client.execute((HttpUriRequest)downloadClient);
        Throwable throwable = null;
        try {
            Object object;
            CloseableHttpResponse response = (CloseableHttpResponse)closeable;
            boolean bl = false;
            if (response.getStatusLine().getStatusCode() == 200) {
                String[] stringArray = new String[]{fileName};
                Path pakFilePath = Paths.get(((Object)outRootPath).toString(), stringArray);
                Files.deleteIfExists(pakFilePath);
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
                OutputStream newOutputStream = Files.newOutputStream(pakFilePath, openOptionArray);
                response.getEntity().writeTo(newOutputStream);
                newOutputStream.close();
                object = context.getSuccessCallback().invoke();
            } else {
                MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8865\u4e01\u5236\u4f5c\u4e0b\u8f7d\u63a5\u53e3\u8bf7\u6c42\u62a5\u9519=status=" + response.getStatusLine().getStatusCode() + ", reason:" + response.getStatusLine().getReasonPhrase());
                object = context.getErrorCallback().invoke();
            }
            Object object2 = object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getMinVersion(PakConfig pakConfig) {
        void $this$filterTo$iv$iv;
        List<Option> list = pakConfig.getVersionList();
        Intrinsics.checkNotNull(list);
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Option it = (Option)element$iv$iv;
            boolean bl = false;
            if (!(it.getValue().compareTo("V8.1SP1") > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List optionList = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Iterable $this$sortedBy$iv = optionList;
        boolean $i$f$sortedBy = false;
        CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Option it = (Option)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getValue());
                it = (Option)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getValue())));
            }
        });
        return ((Option)optionList.get(0)).getValue();
    }

    public final boolean requestPakMakeSite(@Nullable String url) {
        Object option;
        Document document;
        CharSequence charSequence = url;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u8f93\u5165\u5236\u4f5cpak\u8865\u4e01\u5305\u7684\u9996\u9875\u5730\u5740\uff01");
            return false;
        }
        try {
            document = Jsoup.connect((String)url).timeout(5000).get();
        }
        catch (Exception e) {
            LOG.error("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u6c42\u5236\u4f5cpak\u8865\u4e01\u5305\u7684\u5730\u5740\u7684html\u5f02\u5e38\uff01", (Throwable)e);
            MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u8bf7\u6c42\u5236\u4f5cpak\u8865\u4e01\u5305\u7684\u5730\u5740\u7684html\u5f02\u5e38\uff01");
            return false;
        }
        Document document2 = document;
        Elements elements = document2.select("input[name=productedition]");
        List produceEditionList = new ArrayList();
        Elements elements2 = elements;
        Intrinsics.checkNotNull((Object)elements2);
        Iterable $this$forEach$iv = (Iterable)elements2;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            Element it = (Element)element$iv;
            boolean bl = false;
            String value = it.attr("value");
            String id = it.attr("id");
            String checked = it.attr("checked");
            Element element = it.parent();
            String string = name = element != null && (element = element.select("label")) != null ? element.text() : null;
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNull((Object)value);
            Intrinsics.checkNotNull((Object)id);
            Intrinsics.checkNotNull((Object)checked);
            Option option2 = new Option(string, value, id, !StringsKt.isBlank((CharSequence)checked), "");
            produceEditionList.add(option2);
        }
        elements = document2.select("input[name=productversion]");
        List productVersionList = new ArrayList();
        Elements $i$f$forEach22 = elements;
        Intrinsics.checkNotNull((Object)$i$f$forEach22);
        Iterable $this$forEach$iv2 = (Iterable)$i$f$forEach22;
        boolean $i$f$forEach32 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String value = it.attr("value");
            String id = it.attr("id");
            String checked = it.attr("checked");
            Element element = it.parent();
            String name = element != null && (element = element.select("label")) != null ? element.text() : null;
            Intrinsics.checkNotNull((Object)id);
            String string = StringsKt.replace$default((String)id, (String)"verInput", (String)"", (boolean)false, (int)4, null);
            Intrinsics.checkNotNull((Object)value);
            String groupName = StringsKt.replace$default((String)string, (String)value, (String)"", (boolean)false, (int)4, null);
            String string2 = name;
            Intrinsics.checkNotNull((Object)string2);
            Intrinsics.checkNotNull((Object)checked);
            option = new Option(string2, value, id, !StringsKt.isBlank((CharSequence)checked), groupName);
            productVersionList.add(option);
        }
        elements = document2.select("input[name=buildId]");
        List buildIdList = new ArrayList();
        Elements $i$f$forEach32 = elements;
        Intrinsics.checkNotNull((Object)$i$f$forEach32);
        Iterable $this$forEach$iv3 = (Iterable)$i$f$forEach32;
        boolean $i$f$forEach42 = false;
        for (Object element$iv : $this$forEach$iv3) {
            String string;
            String name;
            Element it = (Element)element$iv;
            boolean bl = false;
            String value = it.attr("value");
            String id = it.attr("id");
            String checked = it.attr("checked");
            Element element = it.parent();
            String string3 = name = element != null && (element = element.select("label")) != null ? element.text() : null;
            Object object = it.parent();
            if (object != null && (object = object.parent()) != null && (object = (option = object.attr("id"))) != null) {
                Intrinsics.checkNotNull((Object)object);
                string = StringsKt.replace$default((String)option, (String)"buildDiv", (String)"", (boolean)false, (int)4, null);
            } else {
                string = null;
            }
            String groupName = string;
            String string4 = name;
            Intrinsics.checkNotNull((Object)string4);
            Intrinsics.checkNotNull((Object)value);
            Intrinsics.checkNotNull((Object)id);
            Intrinsics.checkNotNull((Object)checked);
            boolean bl2 = !StringsKt.isBlank((CharSequence)checked);
            String string5 = groupName;
            Intrinsics.checkNotNull((Object)string5);
            Option option3 = new Option(string4, value, id, bl2, string5);
            buildIdList.add(option3);
        }
        elements = document2.select("input[name=patchtype]");
        List patchTypeList = new ArrayList();
        Elements $i$f$forEach42 = elements;
        Intrinsics.checkNotNull((Object)$i$f$forEach42);
        Iterable $this$forEach$iv4 = (Iterable)$i$f$forEach42;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv4) {
            String name;
            Element it = (Element)element$iv;
            boolean bl = false;
            String value = it.attr("value");
            String id = it.attr("id");
            String checked = it.attr("checked");
            Element element = it.parent();
            String string = name = element != null && (element = element.select("label")) != null ? element.text() : null;
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNull((Object)value);
            Intrinsics.checkNotNull((Object)id);
            Intrinsics.checkNotNull((Object)checked);
            Option option4 = new Option(string, value, id, !StringsKt.isBlank((CharSequence)checked), "");
            patchTypeList.add(option4);
        }
        List $this$sortBy$iv = produceEditionList;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Option it = (Option)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getSort());
                    it = (Option)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSort())));
                }
            });
        }
        List $this$sortByDescending$iv = productVersionList;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Option it = (Option)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getSort());
                    it = (Option)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSort())));
                }
            });
        }
        $this$sortByDescending$iv = buildIdList;
        $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Option it = (Option)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getSort());
                    it = (Option)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSort())));
                }
            });
        }
        $this$sortBy$iv = patchTypeList;
        $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Option it = (Option)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getSort());
                    it = (Option)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSort())));
                }
            });
        }
        Pak pak = this.config.getPak();
        String string = document2.select("p").html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"html(...)");
        pak.setReadMe(string);
        this.config.getPak().getProductLineList().clear();
        this.config.getPak().getProductLineList().addAll(produceEditionList);
        this.config.getPak().getVersionList().clear();
        this.config.getPak().getVersionList().addAll(productVersionList);
        this.config.getPak().getBuildIdList().clear();
        this.config.getPak().getBuildIdList().addAll(buildIdList);
        this.config.getPak().getPakTypeList().clear();
        this.config.getPak().getPakTypeList().addAll(patchTypeList);
        MessageHelper.Companion.alert(LOG, "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u66f4\u65b0\u914d\u7f6e\u5b8c\u6210\uff01");
        return true;
    }

    private static final void export$successMsgOutput(ProgressIndicator $progressIndicator, DoExportPakService this$0, ExportContext $context) {
        LOG.info("[\u603b\u8fdb\u5ea6]\u5bfc\u51fa\u5b8c\u6210\uff01\uff01");
        $progressIndicator.setFraction(1.0);
        $progressIndicator.setText("[\u603b\u8fdb\u5ea6]\u5bfc\u51fa\u5b8c\u6210\uff01\uff01");
        NotificationHelper.Companion.showInfo(this$0.doExportRootService.getProject(), "[\u603b\u8fdb\u5ea6]\u5bfc\u51fa\u5b8c\u6210\uff01\uff01");
        $context.getSuccessCallback().invoke();
    }

    private static final void export$doSuccess(DoExportPakService this$0, ProgressIndicator $progressIndicator, Path outRootPath, PakConfig pakConfig, ExportContext $context) {
        this$0.doExportRootService.getDoExportFileService().copy(new ExportContext((Function0<? extends Object>)((Function0)new Function0<Unit>(this$0, $progressIndicator, outRootPath, pakConfig, $context){
            final /* synthetic */ DoExportPakService this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ Path $outRootPath;
            final /* synthetic */ PakConfig $pakConfig;
            final /* synthetic */ ExportContext $context;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$outRootPath = $outRootPath;
                this.$pakConfig = $pakConfig;
                this.$context = $context;
                super(0);
            }

            public final void invoke() {
                NotificationHelper.Companion.showInfo(this.this$0.getDoExportRootService().getProject(), "[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u5bfc\u51fa\u5b8c\u6210\uff01\uff01\u8981\u5bfc\u51fa\u7684\u7f16\u8bd1\u540e\u6587\u4ef6\u6570\u91cf\u5171\uff1a" + DoExportPakService.access$getOutFileMap$p(this.this$0).getAfterCompilationFileMap().size() + "\u4e2a\uff0c\u5b9e\u9645\u5bfc\u51fa\u6570\u91cf\u5171\uff1a" + DoExportPakService.access$getOutFileMap$p(this.this$0).getCopyFileMap().size() + "\u4e2a\uff01");
                DoExportPakService.Companion.getLOG().info("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u6587\u4ef6copy\u5b8c\u6210\uff01");
                this.$progressIndicator.setText("[pak\u8865\u4e01\u5305\u5bfc\u51fa]\u6587\u4ef6copy\u5b8c\u6210\uff01");
                Path path = this.$outRootPath;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"$outRootPath");
                DoExportPakService.access$generateCompressedPackage(this.this$0, path, this.$pakConfig, new ExportContext((Function0<? extends Object>)((Function0)new Function0<Unit>(this.$progressIndicator, this.this$0, this.$context){
                    final /* synthetic */ ProgressIndicator $progressIndicator;
                    final /* synthetic */ DoExportPakService this$0;
                    final /* synthetic */ ExportContext $context;
                    {
                        this.$progressIndicator = $progressIndicator;
                        this.this$0 = $receiver;
                        this.$context = $context;
                        super(0);
                    }

                    public final void invoke() {
                        DoExportPakService.access$export$successMsgOutput(this.$progressIndicator, this.this$0, this.$context);
                    }
                }), (Function0<? extends Object>)((Function0)new Function0<Object>(this.$context){
                    final /* synthetic */ ExportContext $context;
                    {
                        this.$context = $context;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$context.getErrorCallback().invoke();
                    }
                })));
            }
        }), (Function0<? extends Object>)((Function0)new Function0<Object>($context){
            final /* synthetic */ ExportContext $context;
            {
                this.$context = $context;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$context.getErrorCallback().invoke();
            }
        })));
    }

    private static final void parseCheckResultAndDownloadFile$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$export$doSuccess(DoExportPakService this$0, ProgressIndicator $progressIndicator, Path outRootPath, PakConfig pakConfig, ExportContext $context) {
        DoExportPakService.export$doSuccess(this$0, $progressIndicator, outRootPath, pakConfig, $context);
    }

    public static final /* synthetic */ OutFileMap access$getOutFileMap$p(DoExportPakService $this) {
        return $this.outFileMap;
    }

    public static final /* synthetic */ void access$generateCompressedPackage(DoExportPakService $this, Path outRootPath, PakConfig pakConfig, ExportContext context) {
        $this.generateCompressedPackage(outRootPath, pakConfig, context);
    }

    public static final /* synthetic */ void access$export$successMsgOutput(ProgressIndicator $progressIndicator, DoExportPakService this$0, ExportContext $context) {
        DoExportPakService.export$successMsgOutput($progressIndicator, this$0, $context);
    }

    static {
        Logger logger = Logger.getInstance(DoExportPakService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/xf/util/export/service/DoExportPakService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "Idea-Export-Patch2-Jdk17"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OutRelativeFile.Type.values().length];
            try {
                nArray[OutRelativeFile.Type.classFile.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutRelativeFile.Type.packageFile.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutRelativeFile.Type.resourcesFile.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

