/*
 * Decompiled with CFR 0.152.
 */
package com.xf.util.export.service;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.PathKt;
import com.xf.util.export.config.Config;
import com.xf.util.export.helper.NotificationHelper;
import com.xf.util.export.service.DoExportRootService;
import com.xf.util.export.service.vo.ExportContext;
import com.xf.util.export.service.vo.OutFile;
import com.xf.util.export.service.vo.OutFileMap;
import com.xf.util.export.service.vo.OutRelativeFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/xf/util/export/service/DoExportNormalService;", "", "doExportRootService", "Lcom/xf/util/export/service/DoExportRootService;", "(Lcom/xf/util/export/service/DoExportRootService;)V", "config", "Lcom/xf/util/export/config/Config;", "getDoExportRootService", "()Lcom/xf/util/export/service/DoExportRootService;", "setDoExportRootService", "outFileMap", "Lcom/xf/util/export/service/vo/OutFileMap;", "export", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "context", "Lcom/xf/util/export/service/vo/ExportContext;", "generatePackagingInstructions", "hasAllNameList", "", "", "outRootPath", "Companion", "Idea-Export-Patch2-Jdk17"})
@SourceDebugExtension(value={"SMAP\nDoExportNormalService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoExportNormalService.kt\ncom/xf/util/export/service/DoExportNormalService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n211#2,2:151\n1858#3,3:153\n*S KotlinDebug\n*F\n+ 1 DoExportNormalService.kt\ncom/xf/util/export/service/DoExportNormalService\n*L\n61#1:151,2\n116#1:153,3\n*E\n"})
public final class DoExportNormalService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DoExportRootService doExportRootService;
    @NotNull
    private Config config;
    @NotNull
    private OutFileMap outFileMap;
    @NotNull
    private static final Logger LOG;

    public DoExportNormalService(@NotNull DoExportRootService doExportRootService) {
        Intrinsics.checkNotNullParameter((Object)doExportRootService, (String)"doExportRootService");
        this.doExportRootService = doExportRootService;
        this.config = this.doExportRootService.getConfig();
        this.outFileMap = this.doExportRootService.getOutFileMap();
    }

    @NotNull
    public final DoExportRootService getDoExportRootService() {
        return this.doExportRootService;
    }

    public final void setDoExportRootService(@NotNull DoExportRootService doExportRootService) {
        Intrinsics.checkNotNullParameter((Object)doExportRootService, (String)"<set-?>");
        this.doExportRootService = doExportRootService;
    }

    public final void export(@NotNull ProgressIndicator progressIndicator, @NotNull ExportContext context) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LOG.info("[\u603b\u8fdb\u5ea6]\u5e38\u89c4\u8865\u4e01\u5305\u662f\u5426\u5bfc\u51fa[" + this.config.getGlobal().getCanExportNormal() + "]");
        progressIndicator.setText("[\u603b\u8fdb\u5ea6]\u5e38\u89c4\u8865\u4e01\u5305" + (this.config.getGlobal().getCanExportNormal() ? "" : "\u4e0d") + "\u9700\u8981\u5bfc\u51fa");
        if (!this.config.getGlobal().getCanExportNormal()) {
            DoExportNormalService.export$successMsgOutput(progressIndicator, context);
            return;
        }
        LOG.info("[\u5e38\u89c4\u8865\u4e01\u5305\u5bfc\u51fa]\u8fdb\u884c\u76ee\u6807\u76f8\u5bf9\u8def\u5f84\u8865\u5145\u6210\u7edd\u5bf9\u8def\u5f84\u5904\u7406\u5f00\u59cb......");
        progressIndicator.setText("[\u5e38\u89c4\u8865\u4e01\u5305\u5bfc\u51fa]\u8fdb\u884c\u76ee\u6807\u76f8\u5bf9\u8def\u5f84\u8865\u5145\u6210\u7edd\u5bf9\u8def\u5f84\u5904\u7406\u5f00\u59cb......");
        String prefixDirName = this.config.getNormalPak().getPrefixDirName();
        String oaVersion = StringsKt.isBlank((CharSequence)this.config.getNormalPak().getOaVersion()) ? "" : "_" + this.config.getNormalPak().getOaVersion();
        String bugNo = StringsKt.isBlank((CharSequence)this.config.getGlobal().getBugNo()) ? "" : "_" + this.config.getGlobal().getBugNo();
        String[] stringArray = new String[]{prefixDirName + oaVersion + bugNo};
        String outRootPath = ((Object)Paths.get(this.config.getGlobal().getOutRootPath(), stringArray)).toString();
        Map<String, String> jarNameMapping = this.config.getNormalPak().getJarNameMapping();
        List hasNameList = new ArrayList();
        List hasAllNameList = new ArrayList();
        Map<Path, OutRelativeFile> $this$forEach$iv = this.outFileMap.getAfterCompilationFileMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Path, OutRelativeFile>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Path, OutRelativeFile> element$iv;
            Map.Entry<Path, OutRelativeFile> entry = element$iv = iterator.next();
            boolean bl = false;
            Path src = entry.getKey();
            OutRelativeFile dest = entry.getValue();
            Intrinsics.checkNotNull((Object)jarNameMapping.get(dest.getModule().getName()));
            Path outPath = null;
            OutRelativeFile.Type[] typeArray = new OutRelativeFile.Type[]{OutRelativeFile.Type.classFile, OutRelativeFile.Type.packageFile, OutRelativeFile.Type.resourcesFile};
            if (ArraysKt.contains((Object[])typeArray, (Object)((Object)dest.getType()))) {
                String jarName;
                var21_21 = new String[]{jarName, ((Object)dest.getRelativePath()).toString()};
                Path path = Paths.get(outRootPath, var21_21);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                outPath = path;
                if (!hasNameList.contains(jarName)) {
                    hasNameList.add(jarName);
                }
            } else {
                var21_21 = new String[]{this.config.getGlobal().getWebappsName(), ((Object)dest.getRelativePath()).toString()};
                Path path = Paths.get(outRootPath, var21_21);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                outPath = path;
                if (!hasAllNameList.contains(this.config.getGlobal().getWebappsName())) {
                    hasAllNameList.add(this.config.getGlobal().getWebappsName());
                }
            }
            this.outFileMap.getCopyFileMap().put(new OutFile(outPath, dest.getRelativePath()), src);
            LOG.info("[\u5e38\u89c4\u8865\u4e01\u5305\u5bfc\u51fa]\u5c06\u76ee\u6807\u76f8\u5bf9\u8def\u5f84[" + dest.getRelativePath() + "]\u8865\u5145\u6210\u7edd\u5bf9\u8def\u5f84[" + outPath + "]\u5b8c\u6210\uff01");
        }
        hasAllNameList.addAll(hasNameList);
        this.generatePackagingInstructions(hasAllNameList, outRootPath);
        LOG.info("[\u5e38\u89c4\u8865\u4e01\u5305\u5bfc\u51fa]\u76ee\u6807\u76f8\u5bf9\u8def\u5f84\u8865\u5145\u6210\u7edd\u5bf9\u8def\u5f84\u5b8c\u6210\uff01");
        progressIndicator.setText("[\u6e90\u7801\u5bfc\u51fa]\u76ee\u6807\u76f8\u5bf9\u8def\u5f84\u8865\u5145\u6210\u7edd\u5bf9\u8def\u5f84\u5b8c\u6210\uff01");
        if (this.config.getNormalPak().getEs62es5()) {
            this.doExportRootService.getDoExportFileService().es62es5(this.outFileMap.getCopyFileMap(), new ExportContext((Function0<? extends Object>)((Function0)new Function0<Unit>(this, progressIndicator, context){
                final /* synthetic */ DoExportNormalService this$0;
                final /* synthetic */ ProgressIndicator $progressIndicator;
                final /* synthetic */ ExportContext $context;
                {
                    this.this$0 = $receiver;
                    this.$progressIndicator = $progressIndicator;
                    this.$context = $context;
                    super(0);
                }

                public final void invoke() {
                    DoExportNormalService.access$export$doSuccess(this.this$0, this.$progressIndicator, this.$context);
                }
            }), (Function0<? extends Object>)((Function0)new Function0<Object>(context){
                final /* synthetic */ ExportContext $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$context.getErrorCallback().invoke();
                }
            })));
        } else {
            DoExportNormalService.export$doSuccess(this, progressIndicator, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generatePackagingInstructions(List<String> hasAllNameList, String outRootPath) {
        Object content = null;
        content = "";
        Iterable $this$forEachIndexed$iv = hasAllNameList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            content = content + "                        " + (index + 1) + "\u3001";
            content = content + (Intrinsics.areEqual((Object)item, (Object)this.config.getGlobal().getWebappsName()) ? "\u5c06\u8865\u4e01\u5305\u4e0b\u7684seeyon\u6587\u4ef6\u5939\u62f7\u8d1d\u5230\u670d\u52a1\u5668\u4e0b\u7684webapps\\" + (String)item + " \u6587\u4ef6\u5939\u7684\u76f8\u540c\u6587\u4ef6" + System.lineSeparator() : "\u627e\u5230\u5b89\u88c5\u76ee\u5f55\u7684ApacheJetspeed\u4e0b\u7684webapps\\seeyon\\WEB-INF\\lib \u6587\u4ef6\u5939\u4e0b\uff1a\u5c06" + (String)item + ".jar\u7528\u89e3\u538b\u7f29\u5de5\u5177\u6253\u5f00\uff0c\u7136\u540e\u628a\u8865\u4e01\u5305\u4e0b " + (String)item + " \u6587\u4ef6\u52a0\u4e0b\u7684com\u6587\u4ef6\u4e0b \u62d6\u5230\u91cc\u9762\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c\u3002\u7136\u540e\u5173\u95ed\u89e3\u538b\u7f29\u540e\u7684" + (String)item + ".jar" + System.lineSeparator());
        }
        String bugDescFileContent = StringsKt.trimIndent((String)("\n                \u4e00\u3001BUG\u7f16\u53f7\uff1a" + this.config.getGlobal().getBugNo() + "\n                    \u5236\u4f5c\u65e5\u671f\uff1a" + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "\n                \u4e8c\u3001\u4fee\u6539\u95ee\u9898\uff1a\n    \n                \u4e09\u3001\u9002\u7528\u73af\u5883\uff1a\n                    \u4f9d\u8d56\u7248\u672c: V8.2\n                    \u6570\u636e\u5e93\uff1a\u6240\u6709\u6570\u636e\u5e93\n    \n                \u56db\u3001\u64cd\u4f5c\u6b65\u9aa4\uff1a\n                    \u7b2c\u4e00\u6b65\uff1a\u505c\u6b62A8\u670d\u52a1\n                    \u7b2c\u4e8c\u6b65\uff1a\u5907\u4efd\u6587\u4ef6\u3001\u6587\u4ef6\u5939\uff08\u6ce8\u610f\u662f\u5907\u4efd\uff0c\u4e0d\u662f\u5c06\u539f\u6587\u4ef6\u3001\u6587\u4ef6\u5939\u66f4\u540d\u6216\u5220\u9664\uff09 \u5907\u4efdApacheJetspeed\\webapps\\seeyon\u6587\u4ef6\u5939\n                    \u7b2c\u4e09\u6b65\uff1a\u8986\u76d6\u6587\u4ef6\u3001\u6587\u4ef6\u5939" + System.lineSeparator() + content + "\n                    \u7b2c\u56db\u6b65\uff1a\u6e05\u7a7aA8\u7684\\ApacheJetspeed\\work\u76ee\u5f55\u4e0b\u6240\u6709\u5185\u5bb9\uff1b \n                    \u7b2c\u4e94\u6b65\uff1a\u542f\u52a8A8\u670d\u52a1\uff1b\n                    \u7b2c\u516d\u6b65: \u6e05\u9664\u5ba2\u6237\u7aef\u6d4f\u89c8\u5668\u7f13\u5b58\u548cie\u4e34\u65f6\u6587\u4ef6\n            "));
        String[] stringArray = new String[]{"BUG\u4fee\u590d\u5305\u8bf4\u660e.txt"};
        Path file = Paths.get(outRootPath, stringArray);
        Files.deleteIfExists(file);
        Intrinsics.checkNotNull((Object)file);
        CharSequence charSequence = bugDescFileContent;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        PathKt.write((Path)file, (CharSequence)charSequence, (Charset)charset, (boolean)true);
    }

    private static final void export$successMsgOutput(ProgressIndicator $progressIndicator, ExportContext $context) {
        $progressIndicator.setFraction(0.6);
        $context.getSuccessCallback().invoke();
    }

    private static final void export$doSuccess(DoExportNormalService this$0, ProgressIndicator $progressIndicator, ExportContext $context) {
        this$0.doExportRootService.getDoExportFileService().copy(new ExportContext((Function0<? extends Object>)((Function0)new Function0<Unit>(this$0, $progressIndicator, $context){
            final /* synthetic */ DoExportNormalService this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ ExportContext $context;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$context = $context;
                super(0);
            }

            public final void invoke() {
                NotificationHelper.Companion.showInfo(this.this$0.getDoExportRootService().getProject(), "[\u5e38\u89c4\u8865\u4e01\u5305\u5bfc\u51fa]\u5bfc\u51fa\u5b8c\u6210\uff01\uff01\u8981\u5bfc\u51fa\u7684\u7f16\u8bd1\u540e\u6587\u4ef6\u6570\u91cf\u5171\uff1a" + DoExportNormalService.access$getOutFileMap$p(this.this$0).getAfterCompilationFileMap().size() + "\u4e2a\uff0c\u5b9e\u9645\u5bfc\u51fa\u6570\u91cf\u5171\uff1a" + DoExportNormalService.access$getOutFileMap$p(this.this$0).getCopyFileMap().size() + "\u4e2a\uff01");
                DoExportNormalService.Companion.getLOG().info("[\u5e38\u89c4\u8865\u4e01\u5305\u5bfc\u51fa]\u6587\u4ef6copy\u5b8c\u6210\uff01");
                this.$progressIndicator.setText("[\u5e38\u89c4\u8865\u4e01\u5305\u5bfc\u51fa]\u6587\u4ef6copy\u5b8c\u6210\uff01");
                DoExportNormalService.access$export$successMsgOutput(this.$progressIndicator, this.$context);
            }
        }), (Function0<? extends Object>)((Function0)new Function0<Object>($context){
            final /* synthetic */ ExportContext $context;
            {
                this.$context = $context;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$context.getErrorCallback().invoke();
            }
        })));
    }

    public static final /* synthetic */ void access$export$doSuccess(DoExportNormalService this$0, ProgressIndicator $progressIndicator, ExportContext $context) {
        DoExportNormalService.export$doSuccess(this$0, $progressIndicator, $context);
    }

    public static final /* synthetic */ OutFileMap access$getOutFileMap$p(DoExportNormalService $this) {
        return $this.outFileMap;
    }

    public static final /* synthetic */ void access$export$successMsgOutput(ProgressIndicator $progressIndicator, ExportContext $context) {
        DoExportNormalService.export$successMsgOutput($progressIndicator, $context);
    }

    static {
        Logger logger = Logger.getInstance(DoExportNormalService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/xf/util/export/service/DoExportNormalService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "Idea-Export-Patch2-Jdk17"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

