/*
 * Decompiled with CFR 0.152.
 */
package com.xf.util.export.service;

import com.google.common.collect.Lists;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.system.OS;
import com.xf.util.export.config.Config;
import com.xf.util.export.helper.MessageHelper;
import com.xf.util.export.helper.NotificationHelper;
import com.xf.util.export.service.DoExportRootService;
import com.xf.util.export.service.vo.ExportContext;
import com.xf.util.export.service.vo.OutFile;
import com.xf.util.export.service.vo.OutFileMap;
import com.xf.util.export.service.vo.OutRelativeFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.compress.utils.Sets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 .2\u00020\u0001:\u0001.B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u001d\u001a\u00020\u00182\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u000b2\u0006\u0010!\u001a\u00020\u001aJ\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eH\u0002J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005J\u0006\u0010)\u001a\u00020\u0010J\u0018\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\fH\u0002J\u0018\u0010-\u001a\u00020&2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/xf/util/export/service/DoExportFileService;", "", "doExportRootService", "Lcom/xf/util/export/service/DoExportRootService;", "selectedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/xf/util/export/service/DoExportRootService;Ljava/util/List;)V", "config", "Lcom/xf/util/export/config/Config;", "file2MutableMap", "", "Lcom/intellij/openapi/module/Module;", "moduleNameList", "", "outFileMap", "Lcom/xf/util/export/service/vo/OutFileMap;", "project", "Lcom/intellij/openapi/project/Project;", "resourcesQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "sourceQueue", "webQueue", "analysis", "", "context", "Lcom/xf/util/export/service/vo/ExportContext;", "compile", "copy", "es62es5", "copyFileMap", "Lcom/xf/util/export/service/vo/OutFile;", "Ljava/nio/file/Path;", "exportContext", "execCmd", "dir", "cmd", "execCmdGulp", "", "execDir", "getModuleNameList", "getOutFileMap", "inSource", "file", "module", "inWeb", "Companion", "Idea-Export-Patch2-Jdk17"})
@SourceDebugExtension(value={"SMAP\nDoExportFileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoExportFileService.kt\ncom/xf/util/export/service/DoExportFileService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,423:1\n1849#2,2:424\n1849#2,2:426\n211#3,2:428\n211#3:430\n212#3:433\n211#3,2:440\n13536#4,2:431\n496#5,6:434\n*S KotlinDebug\n*F\n+ 1 DoExportFileService.kt\ncom/xf/util/export/service/DoExportFileService\n*L\n69#1:424,2\n96#1:426,2\n208#1:428,2\n130#1:430\n130#1:433\n294#1:440,2\n148#1:431,2\n278#1:434,6\n*E\n"})
public final class DoExportFileService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<VirtualFile> selectedFiles;
    @NotNull
    private Config config;
    @NotNull
    private Project project;
    @NotNull
    private Map<VirtualFile, Module> file2MutableMap;
    @NotNull
    private List<String> moduleNameList;
    @NotNull
    private ArrayBlockingQueue<VirtualFile> sourceQueue;
    @NotNull
    private ArrayBlockingQueue<VirtualFile> resourcesQueue;
    @NotNull
    private ArrayBlockingQueue<VirtualFile> webQueue;
    @NotNull
    private final OutFileMap outFileMap;
    @NotNull
    private static final Logger LOG;

    public DoExportFileService(@NotNull DoExportRootService doExportRootService, @NotNull List<VirtualFile> selectedFiles) {
        Intrinsics.checkNotNullParameter((Object)doExportRootService, (String)"doExportRootService");
        Intrinsics.checkNotNullParameter(selectedFiles, (String)"selectedFiles");
        this.selectedFiles = selectedFiles;
        this.config = doExportRootService.getConfig();
        this.project = doExportRootService.getProject();
        this.file2MutableMap = new HashMap();
        this.moduleNameList = new ArrayList();
        this.sourceQueue = new ArrayBlockingQueue(2);
        this.resourcesQueue = new ArrayBlockingQueue(2);
        this.webQueue = new ArrayBlockingQueue(2);
        this.outFileMap = new OutFileMap();
        Iterable $this$forEach$iv = this.selectedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module module;
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (it.isDirectory()) continue;
            Intrinsics.checkNotNull((Object)ModuleUtil.findModuleForFile((VirtualFile)it, (Project)this.project));
            this.file2MutableMap.put(it, module);
            if (this.moduleNameList.contains(module.getName())) continue;
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.moduleNameList.add(string);
        }
    }

    @NotNull
    public final OutFileMap getOutFileMap() {
        return this.outFileMap;
    }

    @NotNull
    public final List<String> getModuleNameList() {
        return this.moduleNameList;
    }

    public final void compile(@NotNull ExportContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        List compilerSelectedFiles = arrayList;
        HashSet hashSet = Sets.newHashSet((Object[])new Module[0]);
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        Set compilerSelectedModules = hashSet;
        ArrayList arrayList2 = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList2, (String)"newArrayList(...)");
        List staticSelectedFiles = arrayList2;
        CompilerManager compiler = CompilerManager.getInstance((Project)this.project);
        Iterable $this$forEach$iv = this.selectedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            CompilerManager compilerManager = compiler;
            Boolean bl2 = compilerManager != null ? Boolean.valueOf(compilerManager.isCompilableFileType(it.getFileType())) : null;
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                compilerSelectedFiles.add(it);
                Module module = this.file2MutableMap.get(it);
                Intrinsics.checkNotNull((Object)module);
                compilerSelectedModules.add(module);
                continue;
            }
            staticSelectedFiles.add(it);
        }
        if (!((Collection)compilerSelectedFiles).isEmpty() && (this.config.getGlobal().getCanExportNormal() || this.config.getGlobal().getCanExportPak())) {
            FileSetCompileScope scope = new FileSetCompileScope((Collection)compilerSelectedFiles, (Module[])ArrayUtil.toObjectArray((Collection)compilerSelectedModules, Module.class));
            CompilerManager compilerManager = compiler;
            if (compilerManager != null) {
                compilerManager.make((CompileScope)scope, (arg_0, arg_1, arg_2, arg_3) -> DoExportFileService.compile$lambda$2(context, arg_0, arg_1, arg_2, arg_3));
            }
        } else {
            LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u7f16\u8bd1]\u65e0\u9700\u7f16\u8bd1\uff0c\u51c6\u5907\u5bfc\u51fa.......");
            context.getSuccessCallback().invoke();
        }
    }

    public final void analysis(@NotNull ExportContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ApplicationManager.getApplication().runReadAction(() -> DoExportFileService.analysis$lambda$7(this, context));
    }

    public final void copy(@NotNull ExportContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u62f7\u8d1d]\u6587\u4ef6\u62f7\u8d1d\u5f00\u59cb......\u62f7\u8d1d\u6570\u91cf=" + this.outFileMap.getCopyFileMap().size() + "!");
        int count = 0;
        Map<OutFile, Path> $this$forEach$iv = this.outFileMap.getCopyFileMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<OutFile, Path>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<OutFile, Path> element$iv;
            Map.Entry<OutFile, Path> entry = element$iv = iterator.next();
            boolean bl = false;
            OutFile dest = entry.getKey();
            Path src = entry.getValue();
            try {
                Files.createDirectories(dest.getAbsolutePath().getParent(), new FileAttribute[0]);
                Files.deleteIfExists(dest.getAbsolutePath());
                Files.createFile(dest.getAbsolutePath(), new FileAttribute[0]);
                File file = new File(src.toUri());
                File file2 = dest.getAbsolutePath().toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                FilesKt.copyTo$default((File)file, (File)file2, (boolean)true, (int)0, (int)4, null);
                LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u62f7\u8d1d]\u4ece\u6587\u4ef6[" + src + "]\u62f7\u8d1d\u5230\u6587\u4ef6[" + dest.getAbsolutePath() + "]\uff01");
                ++count;
            }
            catch (Exception e) {
                LOG.error("[\u5bfc\u51fa\u6587\u4ef6\u62f7\u8d1d][\u5931\u8d25]\u4ece\u6587\u4ef6[" + src + "]\u62f7\u8d1d\u5230\u6587\u4ef6[" + dest.getAbsolutePath() + "]\u62f7\u8d1d\u5931\u8d25!", (Throwable)e);
            }
        }
        LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u62f7\u8d1d]\u6587\u4ef6\u62f7\u8d1d\u5b8c\u6210\uff01\u5b9e\u9645\u62f7\u8d1d\u6570\u91cf=" + count + "\uff01");
        this.outFileMap.getCopyFileMap().clear();
        LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u62f7\u8d1d]\u6e05\u7a7a\u672c\u6b21\u6587\u4ef6\u62f7\u8d1dmap\uff01");
        context.getSuccessCallback().invoke();
    }

    private final boolean inSource(VirtualFile file, Module module) {
        List list = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
        List sourceRoots = list;
        for (VirtualFile sourceRoot : sourceRoots) {
            if (!file.toNioPath().startsWith(sourceRoot.toNioPath())) continue;
            this.sourceQueue.offer(sourceRoot);
            return true;
        }
        List list2 = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSourceRoots(...)");
        List resourcesRoots = list2;
        for (VirtualFile resourcesRoot : resourcesRoots) {
            if (!file.toNioPath().startsWith(resourcesRoot.toNioPath())) continue;
            this.resourcesQueue.offer(resourcesRoot);
            return true;
        }
        return false;
    }

    private final boolean inWeb(VirtualFile file, Module module) {
        List list = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
        List sourceRoots = list;
        VirtualFile sourceRoot = (VirtualFile)sourceRoots.get(0);
        String[] stringArray = new String[]{this.config.getGlobal().getProjectWebName()};
        Path webSourceRoot = Paths.get(((Object)sourceRoot.getParent().toNioPath()).toString(), stringArray);
        if (file.toNioPath().startsWith(webSourceRoot)) {
            VirtualFile virtualFile = VfsUtil.findFile((Path)webSourceRoot, (boolean)true);
            Intrinsics.checkNotNull((Object)virtualFile);
            this.webQueue.offer(virtualFile);
            return true;
        }
        return false;
    }

    public final void es62es5(@NotNull Map<OutFile, Path> copyFileMap, @NotNull ExportContext exportContext2) {
        Intrinsics.checkNotNullParameter(copyFileMap, (String)"copyFileMap");
        Intrinsics.checkNotNullParameter((Object)exportContext2, (String)"exportContext");
        ApplicationManager.getApplication().invokeLater(() -> DoExportFileService.es62es5$lambda$11(copyFileMap, exportContext2, this));
    }

    private final boolean execCmdGulp(String execDir, String cmd) {
        String cmdResult = this.execCmd(execDir, cmd);
        CharSequence charSequence = cmdResult;
        if (new Regex("\u603b\u8ba1\uff1a\\d+").containsMatchIn(charSequence)) {
            return true;
        }
        boolean windowsCmdNotFound = StringsKt.startsWith$default((String)cmdResult, (String)("'" + cmd + "' "), (boolean)false, (int)2, null);
        boolean linuxCmdNotFound = StringsKt.contains$default((CharSequence)cmdResult, (CharSequence)("/bin/bash: " + cmd + ":"), (boolean)false, (int)2, null);
        if (windowsCmdNotFound || linuxCmdNotFound || StringsKt.contains$default((CharSequence)cmdResult, (CharSequence)("npm install " + cmd), (boolean)false, (int)2, null)) {
            cmdResult = this.execCmd(execDir, "npm install " + cmd + " -g");
            CharSequence charSequence2 = cmdResult;
            return new Regex("(changed|added) \\d+ packages, and audited \\d+ packages").containsMatchIn(charSequence2) ? this.execCmdGulp(execDir, cmd) : false;
        }
        if (StringsKt.contains$default((CharSequence)cmdResult, (CharSequence)"Local modules not found in", (boolean)false, (int)2, null)) {
            cmdResult = this.execCmd(execDir, "npm install");
            CharSequence charSequence3 = cmdResult;
            return new Regex("(changed|added) \\d+ packages, and audited \\d+ packages").containsMatchIn(charSequence3) ? this.execCmdGulp(execDir, cmd) : false;
        }
        if (StringsKt.contains$default((CharSequence)cmdResult, (CharSequence)" Local gulp not found in", (boolean)false, (int)2, null)) {
            cmdResult = this.execCmd(execDir, "npm install " + cmd);
            CharSequence charSequence4 = cmdResult;
            return new Regex("(changed|added) \\d+ packages, and audited \\d+ packages").containsMatchIn(charSequence4) ? this.execCmdGulp(execDir, cmd) : false;
        }
        return false;
    }

    private final String execCmd(String dir, String cmd) {
        List cmdList = new ArrayList();
        if (OS.CURRENT == OS.Windows) {
            cmdList.add("cmd");
            cmdList.add("/c");
            cmdList.add("chcp 65001 & cd /d " + dir + " & " + cmd);
        } else {
            cmdList.add("/bin/bash");
            cmdList.add("-c");
            cmdList.add("cd " + dir + " && " + cmd);
        }
        Process process = null;
        try {
            LOG.info("[ES6\u8f6cES5]\u5f00\u59cb\u6267\u884c\u547d\u4ee4" + CollectionsKt.joinToString$default((Iterable)cmdList, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            process = new ProcessBuilder(cmdList).redirectErrorStream(true).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8), 1024);
            StringBuilder cmdResult = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"Active code page", (boolean)false, (int)2, null)) {
                    cmdResult.append(line);
                }
                LOG.info("[ES6\u8f6cES5]\u547d\u4ee4\u6267\u884c\u8fc7\u7a0b\uff1a" + line);
                line = reader.readLine();
            }
            int waitFor = process.waitFor();
            if (waitFor == 0) {
                LOG.info("[ES6\u8f6cES5]\u547d\u4ee4\u6267\u884c\u6210\u529f\uff01cmd\u7ed3\u679c\uff1a" + cmdResult);
            } else {
                LOG.info("[ES6\u8f6cES5]\u547d\u4ee4\u6267\u884c\u5931\u8d25\uff01cmd\u7ed3\u679c\uff1a" + cmdResult);
            }
            process.destroy();
            String string = cmdResult.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        catch (Exception e) {
            block8: {
                LOG.error("[ES6\u8f6cES5]\u6267\u884c\u5f02\u5e38", (Throwable)e);
                MessageHelper.Companion.alert(LOG, "[ES6\u8f6cES5]\u6267\u884c\u5f02\u5e38" + e.getMessage());
                Process process2 = process;
                if (process2 == null) break block8;
                process2.destroy();
            }
            return "";
        }
    }

    private static final void compile$lambda$2(ExportContext $context, boolean aborted, int errors, int warnings, CompileContext compileContext) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)compileContext, (String)"compileContext");
        if (aborted) {
            MessageHelper.Companion.alert(LOG, "[\u5bfc\u51fa\u6587\u4ef6\u7f16\u8bd1]\u7f16\u8bd1\u5931\u8d25\uff0c\u4ee3\u7801\u7f16\u8bd1\u88ab\u7ec8\u6b62\uff01");
            $context.getErrorCallback().invoke();
            return;
        }
        if (errors != 0) {
            MessageHelper.Companion.alert(LOG, "[\u5bfc\u51fa\u6587\u4ef6\u7f16\u8bd1]\u7f16\u8bd1\u5931\u8d25\uff0c\u4ee3\u7801\u7f16\u8bd1\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u5b58\u5728" + errors + "\u4e2a\u7f16\u8bd1\u9519\u8bef!");
            $context.getErrorCallback().invoke();
            return;
        }
        LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u7f16\u8bd1]\u7f16\u8bd1\u6210\u529f\uff0c\u8b66\u544a\u6570\u91cf\uff1a" + warnings + "\u4e2a\uff0c\u51c6\u5907\u5bfc\u51fa.......");
        $context.getSuccessCallback().invoke();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean analysis$lambda$7$lambda$6$lambda$5$lambda$3(Pattern $fileNameMatch, Path path, BasicFileAttributes attributes) {
        if (!attributes.isRegularFile()) return false;
        Intrinsics.checkNotNull((Object)path);
        if (!PathKt.isFile((Path)path)) return false;
        if (!$fileNameMatch.matcher(((Object)path.getFileName()).toString()).find()) return false;
        return true;
    }

    private static final void analysis$lambda$7$lambda$6$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void analysis$lambda$7(DoExportFileService this$0, ExportContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u89e3\u6790]\u5171\u9700\u89e3\u6790\u7684\u9009\u4e2d\u7684\u6587\u4ef6\u6709[" + this$0.file2MutableMap.size() + "]\u4e2a\uff0c\u9a6c\u4e0a\u5f00\u59cb\u89e3\u6790......");
        Map<VirtualFile, Module> $this$forEach$iv = this$0.file2MutableMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VirtualFile, Module>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            PsiFile psiFile;
            Object object2;
            Map.Entry<VirtualFile, Module> element$iv;
            Map.Entry<VirtualFile, Module> entry = element$iv = iterator.next();
            boolean bl = false;
            VirtualFile file = entry.getKey();
            Module module = entry.getValue();
            if (this$0.config.getGlobal().getCanExportSource()) {
                Path path;
                String string = PathMacroUtil.getModuleDir((String)ModuleUtil.getModuleDirPath((Module)module));
                Intrinsics.checkNotNull((Object)string);
                String moduleDirPath = ((Object)Paths.get(string, new String[0])).toString();
                Path relativePath = Paths.get(StringsKt.replace$default((String)((Object)file.toNioPath()).toString(), (String)moduleDirPath, (String)"", (boolean)false, (int)4, null), new String[0]);
                Map<Path, OutRelativeFile> map = this$0.outFileMap.getSourceFileMap();
                Intrinsics.checkNotNullExpressionValue((Object)file.toNioPath(), (String)"toNioPath(...)");
                Intrinsics.checkNotNull((Object)relativePath);
                object2 = new OutRelativeFile(module, OutRelativeFile.Type.sourceFile, relativePath);
                map.put(path, (OutRelativeFile)object2);
                LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u89e3\u6790]\u5df2\u89e3\u6790\u5230\u6587\u4ef6[" + file.toNioPath() + "]\u8f6c\u6362\u4e3a\u76f8\u5bf9\u8def\u5f84[" + relativePath + "]");
            }
            if (!this$0.config.getGlobal().getCanExportNormal() && !this$0.config.getGlobal().getCanExportPak()) continue;
            String moduleOutputDirectory = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)PsiUtil.getPsiFile((Project)this$0.project, (VirtualFile)file), (String)"getPsiFile(...)");
            if (psiFile instanceof PsiJavaFile) {
                PsiClass[] classes;
                String packagePath;
                Intrinsics.checkNotNullExpressionValue((Object)((PsiJavaFile)psiFile).getClasses(), (String)"getClasses(...)");
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.replace((String)((PsiJavaFile)psiFile).getPackageName(), (String)".", (String)File.separator), (String)"replace(...)");
                String string = moduleOutputDirectory;
                Intrinsics.checkNotNull((Object)string);
                object = new String[]{packagePath};
                Path path = Paths.get(string, object);
                PsiClass[] $this$forEach$iv2 = classes;
                boolean $i$f$forEach2 = false;
                int n = $this$forEach$iv2.length;
                for (int i = 0; i < n; ++i) {
                    PsiClass element$iv2;
                    PsiClass clazz = element$iv2 = $this$forEach$iv2[i];
                    boolean bl2 = false;
                    Pattern fileNameMatch = Pattern.compile("(^" + clazz.getName() + "\\.class$)|(^" + clazz.getName() + "\\$.*\\.class$)");
                    Stream<Path> listFiles = Files.find(path, -1, (arg_0, arg_1) -> DoExportFileService.analysis$lambda$7$lambda$6$lambda$5$lambda$3(fileNameMatch, arg_0, arg_1), new FileVisitOption[0]);
                    listFiles.forEach(arg_0 -> DoExportFileService.analysis$lambda$7$lambda$6$lambda$5$lambda$4((Function1)new Function1<Path, Unit>(packagePath, this$0, module){
                        final /* synthetic */ String $packagePath;
                        final /* synthetic */ DoExportFileService this$0;
                        final /* synthetic */ Module $module;
                        {
                            this.$packagePath = $packagePath;
                            this.this$0 = $receiver;
                            this.$module = $module;
                            super(1);
                        }

                        public final void invoke(Path it) {
                            String[] stringArray = new String[1];
                            Intrinsics.checkNotNull((Object)it);
                            stringArray[0] = PathsKt.getName((Path)it);
                            Path relativePath = Paths.get(this.$packagePath, stringArray);
                            Map<Path, OutRelativeFile> map = DoExportFileService.access$getOutFileMap$p(this.this$0).getAfterCompilationFileMap();
                            Intrinsics.checkNotNull((Object)relativePath);
                            map.put(it, new OutRelativeFile(this.$module, OutRelativeFile.Type.classFile, relativePath));
                            DoExportFileService.Companion.getLOG().info("[\u5bfc\u51fa\u6587\u4ef6\u89e3\u6790]\u5df2\u89e3\u6790\u5230\u6587\u4ef6[" + it + "]\u8f6c\u6362\u4e3a\u76f8\u5bf9\u8def\u5f84[" + relativePath + "]");
                        }
                    }, arg_0));
                }
                continue;
            }
            if (this$0.inSource(file, module)) {
                Path path;
                OutRelativeFile.Type type;
                VirtualFile sourceRoot = this$0.sourceQueue.poll();
                VirtualFile resourcesRoot = this$0.resourcesQueue.poll();
                if (sourceRoot != null) {
                    type = OutRelativeFile.Type.packageFile;
                } else if (resourcesRoot != null) {
                    type = OutRelativeFile.Type.resourcesFile;
                } else {
                    LOG.warn("[\u5bfc\u51fa\u6587\u4ef6\u89e3\u6790]\u6587\u4ef6[" + file.toNioPath() + "]\u672a\u83b7\u53d6\u5230\u6587\u4ef6\u7c7b\u578b\uff0c\u672a\u88ab\u5bfc\u51fa\uff01");
                    continue;
                }
                OutRelativeFile.Type fileType = type;
                Path relativePath = Paths.get(StringsKt.replace$default((String)((Object)file.toNioPath()).toString(), (String)((Object)sourceRoot.toNioPath()).toString(), (String)"", (boolean)false, (int)4, null), new String[0]);
                Map<Path, OutRelativeFile> map = this$0.outFileMap.getAfterCompilationFileMap();
                Intrinsics.checkNotNullExpressionValue((Object)file.toNioPath(), (String)"toNioPath(...)");
                Intrinsics.checkNotNull((Object)relativePath);
                OutRelativeFile outRelativeFile = new OutRelativeFile(module, fileType, relativePath);
                map.put(path, outRelativeFile);
                LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u89e3\u6790]\u5df2\u89e3\u6790\u5230\u6587\u4ef6[" + file.toNioPath() + "]\u8f6c\u6362\u4e3a\u76f8\u5bf9\u8def\u5f84[" + relativePath + "]");
                continue;
            }
            if (this$0.inWeb(file, module)) {
                VirtualFile webSourceRoot = this$0.webQueue.poll();
                Path relativePath = Paths.get(StringsKt.replace$default((String)((Object)file.toNioPath()).toString(), (String)((Object)webSourceRoot.toNioPath()).toString(), (String)"", (boolean)false, (int)4, null), new String[0]);
                object2 = this$0.outFileMap.getAfterCompilationFileMap();
                Intrinsics.checkNotNullExpressionValue((Object)file.toNioPath(), (String)"toNioPath(...)");
                Intrinsics.checkNotNull((Object)relativePath);
                OutRelativeFile outRelativeFile = new OutRelativeFile(module, OutRelativeFile.Type.webFile, relativePath);
                object2.put(object, outRelativeFile);
                LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u89e3\u6790]\u5df2\u89e3\u6790\u5230\u6587\u4ef6[" + file.toNioPath() + "]\u8f6c\u6362\u4e3a\u76f8\u5bf9\u8def\u5f84[" + relativePath + "]");
                continue;
            }
            LOG.warn("[\u5bfc\u51fa\u6587\u4ef6\u89e3\u6790]\u6587\u4ef6[" + file.toNioPath() + "]\u4e0d\u7b26\u5408\u6761\u4ef6\u672a\u88ab\u5bfc\u51fa\uff01");
        }
        LOG.info("[\u5bfc\u51fa\u6587\u4ef6\u89e3\u6790]\u89e3\u6790\u5b8c\u6210\uff01\u5df2\u89e3\u6790\u7684\u6e90\u6587\u4ef6\u5171\u6709[" + this$0.outFileMap.getSourceFileMap().size() + "]\u4e2a\uff01\u5df2\u89e3\u6790\u7684\u7f16\u8bd1\u540e\u6587\u4ef6\u5171\u6709[" + this$0.outFileMap.getAfterCompilationFileMap().size() + "]\u4e2a\uff01");
        NotificationHelper.Companion.showInfo(this$0.project, StringsKt.trimMargin$default((String)("[\u5bfc\u51fa\u6587\u4ef6\u89e3\u6790]\u5171\u9700\u89e3\u6790\u7684\u9009\u4e2d\u7684\u6587\u4ef6\u6709[" + this$0.file2MutableMap.size() + "]\u4e2a\n        |\u5df2\u89e3\u6790\u7684\u6e90\u6587\u4ef6\u5171\u6709[" + this$0.outFileMap.getSourceFileMap().size() + "]\u4e2a\uff01\u5df2\u89e3\u6790\u7684\u7f16\u8bd1\u540e\u6587\u4ef6\u5171\u6709[" + this$0.outFileMap.getAfterCompilationFileMap().size() + "]\u4e2a\uff01"), null, (int)1, null));
        $context.getSuccessCallback().invoke();
    }

    private static final void es62es5$lambda$11$failRun(ExportContext $exportContext) {
        LOG.info("[ES6\u8f6cES5]\u6267\u884c\u7ed3\u679c\u4e0d\u6210\u529f\uff01");
        MessageHelper.Companion.alert(LOG, "[ES6\u8f6cES5]\u6267\u884c\u7ed3\u679c\u4e0d\u6210\u529f\uff01\u8be6\u60c5\u8bf7\u89c1idea\u7684\u65e5\u5fd7\uff01");
        $exportContext.getErrorCallback().invoke();
    }

    private static final void es62es5$lambda$11$successRun(ExportContext $exportContext) {
        LOG.info("[ES6\u8f6cES5]\u6267\u884c\u7ed3\u679c\u6210\u529f\uff01");
        $exportContext.getSuccessCallback().invoke();
    }

    private static final void es62es5$lambda$11(Map $copyFileMap, ExportContext $exportContext, DoExportFileService this$0) {
        Map.Entry element$iv;
        Intrinsics.checkNotNullParameter((Object)$copyFileMap, (String)"$copyFileMap");
        Intrinsics.checkNotNullParameter((Object)$exportContext, (String)"$exportContext");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LOG.info("[ES6\u8f6cES5]\u5f00\u59cb\u6267\u884c......");
        Map pathMap = new HashMap();
        Map $this$filterTo$iv = $copyFileMap;
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)((Object)((OutFile)entry.getKey()).getAbsolutePath().getFileName()).toString(), (String)".js", (boolean)false, (int)2, null)) continue;
            pathMap.put(element$iv.getKey(), element$iv.getValue());
        }
        if (pathMap.isEmpty()) {
            LOG.info("[ES6\u8f6cES5]js\u6587\u4ef6\u4e0d\u5b58\u5728\u8df3\u8fc7\u6267\u884c\uff01");
            $exportContext.getSuccessCallback().invoke();
            return;
        }
        if (StringsKt.isBlank((CharSequence)this$0.config.getEs62Es5().getRootPath())) {
            MessageHelper.Companion.alert(LOG, "[ES6\u8f6cES5]\u8bf7\u9009\u62e9ES6\u8f6cES5\u7684\u7a0b\u5e8f\u6839\u76ee\u5f55\uff01");
            $exportContext.getErrorCallback().invoke();
            return;
        }
        if (StringsKt.isBlank((CharSequence)this$0.config.getEs62Es5().getJsPath())) {
            MessageHelper.Companion.alert(LOG, "[ES6\u8f6cES5]\u8bf7\u9009\u62e9ES6\u8f6cES5\u7684js\u6587\u4ef6\u8f6c\u6362\u76ee\u5f55\uff01");
            $exportContext.getErrorCallback().invoke();
            return;
        }
        Map $this$forEach$iv = pathMap;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            OutFile dest = (OutFile)entry.getKey();
            Path src = (Path)entry.getValue();
            String[] stringArray = new String[]{((Object)dest.getRelativePath()).toString()};
            Path destFile = Paths.get(this$0.config.getEs62Es5().getJsPath(), stringArray);
            Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
            Files.deleteIfExists(destFile);
            Files.createFile(destFile, new FileAttribute[0]);
            File file = new File(src.toUri());
            File file2 = destFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            FilesKt.copyTo$default((File)file, (File)file2, (boolean)true, (int)0, (int)4, null);
            Intrinsics.checkNotNull((Object)destFile);
            $copyFileMap.put(dest, destFile);
        }
        String execDir = this$0.config.getEs62Es5().getRootPath();
        boolean cmdResult = this$0.execCmdGulp(execDir, "gulp");
        if (cmdResult) {
            DoExportFileService.es62es5$lambda$11$successRun($exportContext);
        } else {
            DoExportFileService.es62es5$lambda$11$failRun($exportContext);
        }
    }

    public static final /* synthetic */ OutFileMap access$getOutFileMap$p(DoExportFileService $this) {
        return $this.outFileMap;
    }

    static {
        Logger logger = Logger.getInstance(DoExportFileService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/xf/util/export/service/DoExportFileService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "Idea-Export-Patch2-Jdk17"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

