/*
 * Decompiled with CFR 0.152.
 */
package com.xf.util.export.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.xf.util.export.helper.Constants;
import com.xf.util.export.helper.MessageHelper;
import com.xf.util.export.service.DoExportRootService;
import com.xf.util.export.ui.ExportNewDialog;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/xf/util/export/action/ExportAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "Idea-Export-Patch2-Jdk17"})
public final class ExportAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            MessageHelper.Companion.alert(LOG, "\u8bf7\u5148\u914d\u7f6e\u9879\u76ee\u7ed3\u6784\uff01\u901a\u8fc7\u5feb\u6377\u952e\uff1aCtrl+Shift+Alt+S\uff0c\u6253\u5f00\u9879\u76ee\u914d\u7f6e\u9762\u677f\uff01");
            return;
        }
        Object[] files = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Object[] objectArray = files;
        if (objectArray == null || objectArray.length == 0) {
            MessageHelper.Companion.alert(LOG, "\u672a\u9009\u4e2d\u4efb\u4f55\u9700\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff01");
            return;
        }
        ExportNewDialog ui = new ExportNewDialog(new DoExportRootService(project, ArraysKt.toMutableList((Object[])files)));
        ui.setTitle(Constants.INSTANCE.getPLUGIN_NAME());
        Dimension size = new Dimension(600, 600);
        ui.setSize(size);
        ui.setPreferredSize(size);
        ui.setMinimumSize(size);
        ui.setMaximumSize(size);
        ui.setResizable(true);
        ui.setModal(false);
        ui.setLocationRelativeTo(null);
        ui.setVisible(true);
        ui.requestFocus();
    }

    static {
        Logger logger = Logger.getInstance(ExportAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/xf/util/export/action/ExportAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "Idea-Export-Patch2-Jdk17"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

